/*
 * The original code created by Software AG
 * is part of Software AG Tamino X-Application and
 * Copyright (c) 2001 - 2002 Software AG, All Rights Reserved.
 *
 * Software AG highly appreciate the efforts and contributions of
 * the Source Partners. For more information, please see
 * http://www.softwareag.com/developer/x-application/guide.htm
 *
 * You can redistribute this software and/or modify it under the terms of
 * the Software AG Source Add-On Software License
 * http://www.softwareag.com/developer/x-application/license.htm
 */


package com.softwareag.xtools.xapplication.jsp.taglib;

import com.softwareag.xtools.xapplication.businessdocument.Page;
import com.softwareag.xtools.xapplication.jsp.ExceptionContainer;
import com.softwareag.xtools.xapplication.jsp.JspTag;
import com.softwareag.xtools.xapplication.jsp.util.HtmlElement;
import com.softwareag.xtools.xapplication.jsp.util.Arguments;
import com.softwareag.xtools.xapplication.store.StoreException;
import java.io.IOException;
import java.text.MessageFormat;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;

/**
 ** Defines the count tag. The count tag without parameters shows the same behavior as the display tag
 ** with parameter value $COUNT. Furthermore it is possible to select a certain target of the tags context.
 ** It is also possible to count released from the context, but setting a query.
 ** This query can fix or dynamic. If it is dynamic then the query must be set to 'USEBODY'.
 **
 ** @author <a href="http://www.softwareag.com/developer/x-application/default.htm">Software AG Tamino X-Application Developers</a>
 ** @version $Revision: 1.3 $
 **/
public class CountTag extends JspTag {
    
    private String query = null;
    private String target = null;
    /**
     ** sets the Query property
     **
     ** @param value String xpath for query property
     **/
    public void setQuery(String query) {
        this.query = query;
    }
    
    /**
     ** sets the target property
     **
     ** @param value String xpath for target property
     **/
    public void setTarget(String target) {
        this.target = target;
    }
    
    /**
     ** Standard method of JSP tags that is called when the start tag is processed.
     **
     ** @return return-code according to JSP spec
     **/
    public int doStartTagCore() {
        return EVAL_BODY_TAG;
    }
    
    /**
     ** Standard method of JSP tags that is called after the body is completly read.
     **
     ** @return int return-code according to JSP spec
     **
     ** @throws ExceptionContainer standard exception
     ** @throws IOException to indicate IO problem
     **/
    public int doAfterBodyCore() throws ExceptionContainer, IOException {
        processField();
        return SKIP_BODY;
    }
    
    
    /**
     ** Abstract method of FieldTag which is called by the superclass to
     ** process this specific field.
     **
     ** @throws ExceptionContainer standard exception
     ** @throws IOException exception from Store
     **/
    public void processField() throws ExceptionContainer, IOException {
        BodyContent bc;
        JspWriter enclosing;
        String countValue;
        String bodyContentStr;
        ContextTag contextTag = ContextTag.lookup(this);
        
        bc = getBodyContent();
        bodyContentStr = bc.getString();
        enclosing = bc.getEnclosingWriter();
        
        if (target != null && query != null ) {
            throw new ExceptionContainer("230");
        }
        if (target == null && query == null && bodyContentStr.length() > 0) {
            throw new ExceptionContainer("231");
        }
        if (target == null && query != null && query.equalsIgnoreCase("usebody") && bodyContentStr.length() == 0) {
            throw new ExceptionContainer("232");
        }
        if (target == null && query != null && query.equalsIgnoreCase("usebody") == false && bodyContentStr.length() > 0) {
            throw new ExceptionContainer("233");
        }
        //same as before
        if (target == null &&  query == null  && bodyContentStr.length() == 0) {
            try {
            countValue = contextTag.getElementValue("$COUNT", false, true);
            enclosing.write(countValue);
            } catch (NullPointerException e) {
                throw new ExceptionContainer("234");
            }
        }
        
        if (target != null && query == null) {
            try {
                countValue = Integer.toString(((Page)sessionContext.getPage(target)).size(true));
                enclosing.write(countValue);
            } catch (NullPointerException e) {
                throw new ExceptionContainer("234");
            }
        }
        //count by tamino
        if (target == null && query != null) {
            if (query.equalsIgnoreCase("usebody")) {
                try {
                    countValue = Integer.toString(sessionContext.getWorkspace().getStore().count(bodyContentStr.trim()));
                }
                catch(StoreException se) {
                    throw new ExceptionContainer("235", bodyContentStr.toString());
                }
            }
            else {
                try {
                    countValue = Integer.toString(sessionContext.getWorkspace().getStore().count(query));
                }
                catch(StoreException se) {
                    throw new ExceptionContainer("236", query);
                }
            }
            enclosing.write(countValue);
        }
    }
}

