#
#	module.make
#
#	$Id: module.make,v 1.2 2001/05/04 07:07:36 frwe Exp $
#
#	Makefile fragment for SAGDOC-based documentation
#
#	This makefile fragment defines any documents in the current
#	documentation module directory. At configuration time it
#	is renamed to GNUmakefile and allows the production of HTML
#	PostScript, PDF and DocBook from within this directory as
#	well as from the top-level source directory.
#
#	Copyright 2001, Software AG
#
#	This makefile and related documentation is part of the XML
#	processing framework being used for in-house SAGDOC-based XML
#	documentation. Any comments or suggestions for improvement
#	are welcome.
#
#	Frank.Wegmann@softwareag.com
#


# define title as it should appear on the cover page of the PDF version
CVR_TITLE	= 

# define document title as it appears on the header of each page
# in the PDF version
HEADER_TITLE	= 

# define name of the output directory; without XLink/XPointer this
# is critical: if a name has been established, it may only be altered
# after all team members agree upon that, since *all* links have to
# be checked and changed accordingly!
DOC_INSTALLDIR	= graphics

# define name of resulting DocBook instance
DOC_DOCBOOK_XML	= 

# define documentation sources; if there is more than one XML file
# the one including or linking to any other files is the first
DOC_XML_SRC	= 

# please indicate the SAGDOC version in case you still use a DOCTYPE
# declaration pointing to a local file
SAGDOC_REQ	= 

# define graphics source files
DOC_SVG_SRC	= 

# define graphics files
DOC_GRAPHICS	:=

DOC_OTHERS	= $(wildcard *.gif)

# directories that have to be created during the build process
# don't miss that otherwise producing PDF (sectionwise) will fail
DOC_NEWDIRS	= 

# this should contain the name of any generated HTML files that
# should not be used in the further processing, i.e. they will
# get deleted before renaming them to ISO9660 conformant (8.3)
HTML_TO_DISPOSE = 

# all source files that should be installed as is
DOC_INSTALLFILES = $(DOC_GRAPHICS) $(DOC_OTHERS)

#
# end of configurable section
#
############################################################

# all source files that are needed during the build process
DOC_FILES	= $(DOC_XML_SRC) $(DOC_SVG_SRC)	\
		  $(DOC_GRAPHICS)

# define location of common makefile parts; this variable is being
# substituted at build time to allow production inside the current
# directory
ifndef ($(DOC_MAKEFILES),)
DOC_MAKEFILES=@MAKEFILES_DIR@
endif

include $(DOC_MAKEFILES)/tools.make

#  extra empty rules: the only thing to be done here is to install
# config is copied one to one from targets.make.in

config: $(DOC_BUILD_ROOT)/$$CURRENT_DIR

$(DOC_BUILD_ROOT)/$$CURRENT_DIR:
	$(MKDIRS) $@ ; \
	(cd $@;				\
	 $(MKDIRS) $(DOC_NEWDIRS) $(EXTRA_DIRS) ;	\
	  for g in $(DOC_FILES) $(DOC_OTHERS) $(EXTRA_FILES); do	\
	    if [ ! -h "$$g" ]; then  \
	      ln -s $(DOC_TOPLEV)/$$CURRENT_DIR/$$g $$g ; fi; \
	  done ; \
	  sed -e "s'@MAKEFILES_DIR@'$(DOC_MAKEFILES)'g"	\
	    $(DOC_TOPLEV)/$$CURRENT_DIR/module.make > GNUmakefile ; \
	  if [ ! -f "$(DOC_GRAPHICS_LOF_FILE)" ]; then \
	    echo $(DOC_GRAPHICS) > $(DOC_GRAPHICS_LOF_FILE) ; fi ; \
	)

html:
	touch .html.done;

pdf:
	touch .pdf.done;

docbook: 
	touch .docbook.done;

.PHONY : install
install:
	installdir=`echo "$(DOC_INSTALL_ROOT)/$(DOC_INSTALLDIR)" | tr -d ' ' | tr -d '\011'` ; \
	$(MKDIRS) $$installdir ; \
	$(TAR) chf - $(DOC_INSTALLFILES) | (cd $$installdir; $(TAR) xpf -)

jumphi.txt:
	touch .jumphi.done;


## Local variables:
## mode: makefile
## End:
