#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <etbcdef.h>
#include <etbcinf.h>

static char rbuf[sizeof(ETB_HD_CIS) + sizeof(ETB_INFO_SV)];
static char ebuf[40];

static ETBCB etbcb;					// Broker Control block
static ETB_INFO_API cisinfo;		// broker INFO structure - used as send buffer
ETB_HD_CIS *phdrcis;				// header returned by broker - first part of receive buffer
ETB_INFO_SV *pinfosv;				// info returned by Broker - last part of receive buffer
/*
** utility functions
*/
void getError(int *,int *);
void PrintHeader(ETB_HD_CIS * h);
void PrintInfo(ETB_INFO_SV * s);

int x=0;
int errclass,errcode;

int main (int argc, char *argv[]){

phdrcis = (ETB_HD_CIS *)malloc(sizeof(ETB_HD_CIS));
pinfosv = (ETB_INFO_SV *)malloc(sizeof(ETB_INFO_SV));
/*
** initialise broker control block
*/
etbcb.api_type = API_TYPE1;
etbcb.api_version = 1;
strcpy(etbcb.broker_id,"ETB001");
strcpy(etbcb.server_class,"SAG");
strcpy(etbcb.server_name,"ETBCIS");
strcpy(etbcb.service,"INFO");
strcpy(etbcb.user_id,"CIS client");
etbcb.errtext_length = 40;
/*
** initialise INFO structure sent to Broker
*/
cisinfo.lReturnBlock = sizeof(rbuf);
cisinfo.Version = 1;
cisinfo.ObjectType = 6;
strcpy(cisinfo.server_class,"ACLASS");
/*
** call Broker - first call is a SEND with WAIT;
** subsequent calls are RECEIVE with NO WAIT
*/
etbcb.function=FCT_SEND;
etbcb.send_length=sizeof(ETB_INFO_API);
etbcb.receive_length=sizeof(rbuf);
strcpy(etbcb.wait,"10s");
strcpy(etbcb.conv_id,"NEW");
broker(&etbcb,(char *)&cisinfo,rbuf,ebuf);
getError(&errclass,&errcode);
/*
** loop until END OF CONVERSATION (Broker error 00030005)
** received from Broker
*/
while(!errclass){
/*
** get header from receive buffer
*/
memset(phdrcis,'\0',sizeof(ETB_HD_CIS));
memcpy(phdrcis,rbuf,sizeof(ETB_HD_CIS));
PrintHeader(phdrcis);
/*
** get info from receive buffer
*/
memset(pinfosv,'\0',sizeof(ETB_INFO_SV));
memcpy(pinfosv,rbuf+32,sizeof(ETB_INFO_SV));
PrintInfo(pinfosv);
/*
** get next buffer from Broker
*/
etbcb.function=FCT_RECEIVE;
etbcb.send_length=0;
strcpy(etbcb.wait,"NO");
broker(&etbcb,(char *)&cisinfo,rbuf,ebuf);
getError(&errclass,&errcode);
}
}
/*
** Utility function implementations
*/ 
void getError(int * eclass,int * ecode){
	char tmp[8];
	strncpy(tmp,etbcb.error_code,8);
    *ecode = atoi(tmp+4);
	tmp[4] = '\0';
	*eclass = atoi(tmp);
}

void PrintHeader(ETB_HD_CIS * h){
printf("\n----------------------------- SERVICES HEADER -----------------------------\n\n");
printf("error\ttotal\treturned\tmax class\tmax server\tmax service\n\n");
printf("%d",h->ErrorCode);
printf("\t%d",h->nObjectTotal);
printf("\t%d",h->nObjectCurrent);
printf("\t\t%d",h->lClassMax);
printf("\t\t%d",h->lServerMax);
printf("\t\t%d\n",h->lServiceMax);
printf("\n---------------------------------------------------------------------------\n");
}

void PrintInfo(ETB_INFO_SV * s){
printf("\n----------------------------- SERVICES INFO -----------------------------\n\n");
printf("class : \t\t%.32s\n",s->server_class);
printf("server : \t\t%.32s\n",s->server);
printf("service : \t\t%.32s\n",s->service);
printf("\nSERVER:\n");
printf("active\twaits\ttimes all occupied\ttotal requsets\n\n");
printf("%d",s->nServerActive);
printf("\t%d",s->nWaitServer);
printf("\t%d",s->nServerOccupied);
printf("\t\t\t%d\n\n",s->nTotalRequests);
printf("CONVERSATION:\n");
printf("timeout\tactive\thigh water mark\tpending\thigh water mark pending\n\n");
printf("%d",s->ConvNonact);
printf("\t%d",s->nConvActive);
printf("\t%d",s->nConvHigh);
printf("\t\t%d",s->nPending);
printf("\t%d",s->nPendingHigh);
printf("\n---------------------------------------------------------------------------\n");
}
