package de.sagd.u4etx.cis.objects;

import de.sagd.u4etx.cis.*;

public abstract class AbstractServiceResponseObject
    implements IServiceResponseObject
{
    protected byte[] abResponse;
    protected int iOff;
    protected int iLen;

    public AbstractServiceResponseObject(byte[] abResponse, int iOff, int iLen)
        throws ServiceResponseException
    {
        if (abResponse.length - iOff < getLength()) {
            throw new ServiceResponseException("Malformed response (wrong length [" + getLength() + " bytes] extpected but [" + (abResponse.length - iOff) + " bytes] received)");
        }

        this.abResponse = abResponse;
        this.iOff = iOff;
        this.iLen = iLen;
    }

    public int getLength()
    {
        return -1;
    }

    /////////// BROKER OBJECT (RETURN DEFAULT VALUES)

    public String getPlatform()
    {
        return null;
    }

    public int getRuntime()
    {
        return -1;
    }

    public int getNumWorkerAct()
    {
        return -1;
    }

    public int getNumLong()
    {
        return -1;
    }

    public int getLongAct()
    {
        return -1;
    }

    public int getLongHigh()
    {
        return -1;
    }

    public int getNumShort()
    {
        return -1;
    }

    public int getShortAct()
    {
        return -1;
    }

    public int getShortHigh()
    {
        return -1;
    }

    public int getLongSize()
    {
        return -1;
    }

    public int getShortSize()
    {
        return -1;
    }

    public int getNumService()
    {
        return -1;
    }

    public int getServiceAct()
    {
        return -1;
    }

    public int getNumServer()
    {
        return -1;
    }

    public int getServerAct()
    {
        return -1;
    }

    public int getServerHigh()
    {
        return -1;
    }

    public int getNumClient()
    {
        return -1;
    }

    public int getClientAct()
    {
        return -1;
    }

    public int getClientHigh()
    {
        return -1;
    }

    public int getConvHigh()
    {
        return -1;
    }

    public int getNumConv()
    {
        return -1;
    }

    public int getTraceLevel()
    {
        return -1;
    }

    public int getReserve()
    {
        return -1;
    }

    public int getCStore()
    {
        return -1;
    }

    public int getLMaxUOWS()
    {
        return -1;
    }

    public int getLMaxUOWMsg()
    {
        return -1;
    }

    public int getCPStore()
    {
        return -1;
    }

    public int getCUWStatP()
    {
        return -1;
    }

    public int getLUWTime()
    {
        return -1;
    }

    public int getLMaxDELCNT()
    {
        return -1;
    }

    public int getLMaxMsgSize()
    {
        return -1;
    }

    public int getCDeferred()
    {
        return -1;
    }

    public int getTotalUOWS()
    {
        return -1;
    }

    /////////// WORKER OBJECT (RETURN DEFAULT VALUES)

    public int getWorkerID()
    {
        return -1;
    }

    public int getWorkerStat()
    {
        return -1;
    }

    public int getCallSum()
    {
        return -1;
    }

    public int getIdleSum()
    {
        return -1;
    }

    /////////// SERVICE OBJECT (RETURN DEFAULT VALUES)

    public String getServerClass()
    {
        return null;
    }

    public String getServerName()
    {
        return null;
    }

    public String getService()
    {
        return null;
    }

    public String getTrans()
    {
        return null;
    }

    public int getConvNonAct()
    {
        return -1;
    }

    //public int getServerAct();
    //public int getConvAct();
    //public int getConvHigh();
    //public int getLongAct();
    //public int getLongHigh();
    //public int getShortAct();
    //public int getShortHigh();
    public int getNumWaitServer()
    {
        return -1;
    }

    public int getNumServOCC()
    {
        return -1;
    }

    public int getNumPend()
    {
        return -1;
    }

    public int getPendHigh()
    {
        return -1;
    }

    public int getReqSum()
    {
        return -1;
    }

    //public String getCStore();
    //public int getLMaxUOWS();
    //public int getLMaxUOWMsg();
    //public String getCUWStatP();
    //public int getLUWTime();

    public int getLMaxDelCNT()
    {
        return -1;
    }

    public int getMaxMsgSize()
    {
        return -1;
    }

    //public String getCDeferred();

    public int getLTotalUOWS()
    {
        return -1;
    }

    /////////// SERVICE OBJECT (RETURN DEFAULT VALUES)

    public String getUserID()
    {
        return null;
    }

    public byte[] getPUserID()
    {
        return null;
    }

    public String getPUserIDChar()
    {
        return null;
    }

    public String getToken()
    {
        return null;
    }

    public int getCharSet()
    {
        return -1;
    }

    public int getEndian()
    {
        return -1;
    }

    public int getStatus()
    {
        return -1;
    }

    public int getReserved()
    {
        return -1;
    }

    public String getWaitConvType()
    {
        return null;
    }

    public String getWaitServerClass()
    {
        return null;
    }

    public String getWaitServerName()
    {
        return null;
    }

    public String getWaitService()
    {
        return null;
    }

    public int getConvAct()
    {
        return -1;
    }

    //public int getServiceAct();

    public int getLastActive()
    {
        return -1;
    }

    public int getNonAct()
    {
        return -1;
    }

    public int getWaitNew()
    {
        return -1;
    }

    public int getNumWaitNew()
    {
        return -1;
    }

    public int getWaitOld()
    {
        return -1;
    }

    public int getNumWaitOld()
    {
        return -1;
    }

    public int getSumConv()
    {
        return -1;
    }

    //public int getLTotalUOWS();

    /////////// CONVERSATION OBJECT (RETURN DEFAULT VALUES)

    public String getConvID()
    {
        return null;
    }

    public String getSreverUserID()
    {
        return null;
    }

    public byte[] getServerPUserID()
    {
        return null;
    }

    public String getServerPUserIDChar()
    {
        return null;
    }

    public String getServerToken()
    {
        return null;
    }

    public String getClientUserID()
    {
        return null;
    }

    public byte[] getClientPUSerID()
    {
        return null;
    }

    public String getClientPUserIDChar()
    {
        return null;
    }

    public String getClientToken()
    {
        return null;
    }

    //public String getServerClass();
    //public String getServerName();
    //public String getService();

    public int getConvTimeOut()
    {
        return -1;
    }

    //public int getLastActive();

    public int getType()
    {
        return -1;
    }

    //public int getReserved();
    //public int getLTotalUOWS();

    /////////// PSF OBJECT (RETURN DEFAULT VALUES)

    public String getUOWID()
    {
        return null;
    }

    //public String getConvID();

    public String getServerUID()
    {
        return null;
    }

    public String getSenderToken()
    {
        return null;
    }

    public String getSenderServer()
    {
        return null;
    }

    public String getSenderClass()
    {
        return null;
    }

    public String getSenderService()
    {
        return null;
    }

    public String getRecVRUID()
    {
        return null;
    }

    public String getRecVRToken()
    {
        return null;
    }

    public String getRecVRServer()
    {
        return null;
    }

    public String getRecVRClass()
    {
        return null;
    }

    public String getRecVRService()
    {
        return null;
    }

    public String getUserStatus()
    {
        return null;
    }

    public String getUWStatus()
    {
        return null;
    }

    public String getCEOC()
    {
        return null;
    }

    //public String getCStore();

    public String getCUOWStatStore()
     {
        return null;
    }

    public int getLeoCreason()
    {
        return -1;
    }

    public int getLatTempTCount()
    {
        return -1;
    }

    public int getLMSQCNT()
    {
        return -1;
    }

    public String getUWStatusLifeTime()
    {
        return null;
    }

    public String getUWCreateTime()
    {
        return null;
    }

    public int getUWLifeTime()
    {
        return -1;
    }
}