/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.common.xmlutil.gui.xmltree.attributeeditor;

import com.softwareag.xtools.common.xmlutil.gui.xmltree.AttributeMap;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.XMLTree;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.attributeeditor.AttributeSetItem;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.attributeeditor.resources.AttributeEditorResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AttributeEditor
extends JPanel {
    public static final String PREVIEW_RESOURCE = "preview.xml";
    public static final String PREVIEW_DTD = "preview.dtd";
    protected static final int INSETS = 5;
    protected AttributeMap attributeMap = null;
    protected AttributeMap defaultAttributeMap = null;
    protected JColorChooser colorChooser = null;
    protected XMLTree previewXMLTree = null;
    protected JPanel stylePanel = null;
    protected JPanel styleParentPanel = null;
    protected JPanel colorPanel = null;
    protected JPanel colorParentPanel = null;
    protected JPanel previewPanel = null;
    protected JPanel previewParentPanel = null;
    protected JRadioButton plainRadiobutton = null;
    protected JRadioButton boldRadiobutton = null;
    protected JRadioButton italicRadiobutton = null;
    protected JComboBox typeCombobox = null;

    public AttributeEditor() throws ParserConfigurationException, SAXException, IOException {
        this(new AttributeMap());
    }

    public AttributeEditor(AttributeMap attributeMap) throws ParserConfigurationException, SAXException, IOException {
        this(attributeMap, null);
    }

    public AttributeEditor(AttributeMap attributeMap, AttributeMap attributeMap2) throws ParserConfigurationException, SAXException, IOException {
        this.attributeMap = attributeMap;
        if (attributeMap2 == null) {
            attributeMap2 = new AttributeMap();
        }
        this.defaultAttributeMap = attributeMap2;
        this.initGui();
    }

    protected void initGui() throws ParserConfigurationException, SAXException, IOException {
        this.getAccessibleContext().setAccessibleDescription(AttributeEditorResource.getAccessibleDescription("attributeEditorDialog"));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        this.add((Component)jPanel, "East");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = this.createBorderedJPanel(jPanel2, "typePanel");
        jPanel3.setLayout(new BorderLayout(5, 0));
        Iterator iterator = this.getAttributeMap().getAttributeSetKeys();
        TreeSet<AttributeSetItem> treeSet = new TreeSet<AttributeSetItem>();
        String string = null;
        AttributeSetItem attributeSetItem = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            attributeSetItem = new AttributeSetItem(string, AttributeEditorResource.getString(string));
            treeSet.add(attributeSetItem);
        }
        this.typeCombobox = new JComboBox<Object>(treeSet.toArray());
        this.typeCombobox.getAccessibleContext().setAccessibleName(AttributeEditorResource.getString("typePanel"));
        this.typeCombobox.getAccessibleContext().setAccessibleDescription(AttributeEditorResource.getAccessibleDescription("typePanel"));
        this.typeCombobox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                AttributeEditor.this.updateSettings();
            }
        });
        jPanel3.add((Component)this.typeCombobox, "Center");
        JButton jButton = new JButton(AttributeEditorResource.getString("resetToDefault"));
        jButton.getAccessibleContext().setAccessibleDescription(AttributeEditorResource.getAccessibleDescription("resetToDefault"));
        jButton.setMnemonic(AttributeEditorResource.getMnemonic("resetToDefault"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeEditor.this.getAttributeMap().putAttributeSet(AttributeEditor.this.getAttributeSetKey(), new SimpleAttributeSet(AttributeEditor.this.getDefaultAttributeMap().getAttributeSet(AttributeEditor.this.getAttributeSetKey())));
                AttributeEditor.this.attributeSetChanged();
                AttributeEditor.this.updateSettings();
            }
        });
        jPanel3.add((Component)jButton, "East");
        jButton.setEnabled(this.getDefaultAttributeMap() != null);
        this.colorChooser = new JColorChooser();
        this.colorChooser.getAccessibleContext().setAccessibleName(AttributeEditorResource.getString("colorPanel"));
        this.colorChooser.getAccessibleContext().setAccessibleDescription(AttributeEditorResource.getAccessibleDescription("colorPanel"));
        this.colorChooser.setPreviewPanel(new JPanel());
        this.colorChooser.getSelectionModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                String string = AttributeEditor.this.getAttributeSetKey();
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(AttributeEditor.this.getAttributeMap().getAttributeSet(string));
                StyleConstants.setForeground(simpleAttributeSet, AttributeEditor.this.colorChooser.getColor());
                AttributeEditor.this.getAttributeMap().putAttributeSet(string, simpleAttributeSet);
                AttributeEditor.this.attributeSetChanged();
            }
        });
        this.colorParentPanel = new JPanel();
        jPanel.add((Component)this.colorParentPanel, "Center");
        this.colorPanel = this.createBorderedJPanel(this.colorParentPanel, "colorPanel");
        this.colorPanel.add((Component)this.colorChooser, "Center");
        this.styleParentPanel = new JPanel();
        jPanel.add((Component)this.styleParentPanel, "South");
        this.stylePanel = this.createBorderedJPanel(this.styleParentPanel, "stylePanel");
        this.plainRadiobutton = new JRadioButton(AttributeEditorResource.getString("plain"));
        this.plainRadiobutton.getAccessibleContext().setAccessibleDescription(AttributeEditorResource.getAccessibleDescription("plain"));
        this.plainRadiobutton.setMnemonic(AttributeEditorResource.getMnemonic("plain"));
        this.plainRadiobutton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                String string = AttributeEditor.this.getAttributeSetKey();
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(AttributeEditor.this.getAttributeMap().getAttributeSet(string));
                StyleConstants.setBold(simpleAttributeSet, false);
                StyleConstants.setItalic(simpleAttributeSet, false);
                AttributeEditor.this.getAttributeMap().putAttributeSet(string, simpleAttributeSet);
                AttributeEditor.this.attributeSetChanged();
            }
        });
        this.boldRadiobutton = new JRadioButton(AttributeEditorResource.getString("bold"));
        this.boldRadiobutton.getAccessibleContext().setAccessibleDescription(AttributeEditorResource.getAccessibleDescription("bold"));
        this.boldRadiobutton.setMnemonic(AttributeEditorResource.getMnemonic("bold"));
        this.boldRadiobutton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                String string = AttributeEditor.this.getAttributeSetKey();
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(AttributeEditor.this.getAttributeMap().getAttributeSet(string));
                StyleConstants.setBold(simpleAttributeSet, AttributeEditor.this.boldRadiobutton.isSelected());
                AttributeEditor.this.getAttributeMap().putAttributeSet(string, simpleAttributeSet);
                AttributeEditor.this.attributeSetChanged();
            }
        });
        this.italicRadiobutton = new JRadioButton(AttributeEditorResource.getString("italic"));
        this.italicRadiobutton.getAccessibleContext().setAccessibleDescription(AttributeEditorResource.getAccessibleDescription("italic"));
        this.italicRadiobutton.setMnemonic(AttributeEditorResource.getMnemonic("italic"));
        this.italicRadiobutton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                String string = AttributeEditor.this.getAttributeSetKey();
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(AttributeEditor.this.getAttributeMap().getAttributeSet(string));
                StyleConstants.setItalic(simpleAttributeSet, AttributeEditor.this.italicRadiobutton.isSelected());
                AttributeEditor.this.getAttributeMap().putAttributeSet(string, simpleAttributeSet);
                AttributeEditor.this.attributeSetChanged();
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.plainRadiobutton);
        buttonGroup.add(this.boldRadiobutton);
        buttonGroup.add(this.italicRadiobutton);
        this.stylePanel.setLayout(new GridLayout(1, 3));
        this.stylePanel.add(this.plainRadiobutton);
        this.stylePanel.add(this.boldRadiobutton);
        this.stylePanel.add(this.italicRadiobutton);
        this.previewParentPanel = new JPanel();
        this.add((Component)this.previewParentPanel, "Center");
        this.previewPanel = this.createBorderedJPanel(this.previewParentPanel, "previewPanel");
        JScrollPane jScrollPane = new JScrollPane(this.createPreviewXMLTree());
        this.previewPanel.add((Component)jScrollPane, "Center");
        this.updateSettings();
    }

    private JPanel createBorderedJPanel(JPanel jPanel, String string) {
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.getAccessibleContext().setAccessibleDescription(AttributeEditorResource.getAccessibleDescription(string));
        jPanel2.setBorder(new CompoundBorder(new TitledBorder(AttributeEditorResource.getString(string)), new EmptyBorder(5, 5, 5, 5)));
        jPanel.add((Component)jPanel2, "Center");
        return jPanel2;
    }

    protected XMLTree createPreviewXMLTree() throws ParserConfigurationException, SAXException, IOException {
        if (this.previewXMLTree == null) {
            EntityResolver entityResolver = new EntityResolver(){

                public InputSource resolveEntity(String string, String string2) {
                    InputSource inputSource = null;
                    try {
                        InputStream inputStream = this.getClass().getResourceAsStream(AttributeEditor.PREVIEW_DTD);
                        inputSource = new InputSource(inputStream);
                    }
                    catch (Exception exception) {
                        inputSource = null;
                    }
                    return inputSource;
                }
            };
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(entityResolver);
            InputStream inputStream = this.getClass().getResourceAsStream(PREVIEW_RESOURCE);
            InputSource inputSource = new InputSource(inputStream);
            Document document = documentBuilder.parse(inputSource);
            this.previewXMLTree = new XMLTree((Node)document, this.getAttributeMap());
            this.previewXMLTree.getAccessibleContext().setAccessibleName(AttributeEditorResource.getString("previewPanel"));
            this.previewXMLTree.getAccessibleContext().setAccessibleDescription(AttributeEditorResource.getAccessibleDescription("previewPanel"));
            this.previewXMLTree.expandAll();
        }
        return this.previewXMLTree;
    }

    public AttributeMap getAttributeMap() {
        return this.attributeMap;
    }

    public AttributeMap getDefaultAttributeMap() {
        return this.defaultAttributeMap;
    }

    public AttributeSet getAttributeSet() {
        return this.getAttributeMap().getAttributeSet(this.getAttributeSetKey());
    }

    public String getAttributeSetKey() {
        return ((AttributeSetItem)this.typeCombobox.getSelectedItem()).getAttributeSetKey();
    }

    public void updateSettings() {
        AttributeSet attributeSet = this.getAttributeSet();
        this.colorChooser.setColor(StyleConstants.getForeground(attributeSet));
        if (StyleConstants.isBold(attributeSet)) {
            this.boldRadiobutton.setSelected(true);
        } else if (StyleConstants.isItalic(attributeSet)) {
            this.italicRadiobutton.setSelected(true);
        } else {
            this.plainRadiobutton.setSelected(true);
        }
        this.plainRadiobutton.setEnabled(!this.isBackgroundSelected());
        this.boldRadiobutton.setEnabled(!this.isBackgroundSelected());
        this.italicRadiobutton.setEnabled(!this.isBackgroundSelected());
    }

    public boolean isBackgroundSelected() {
        return "Background".equals(this.getAttributeSetKey());
    }

    public void attributeSetChanged() {
        this.updatePreviewPanel();
    }

    public void updatePreviewPanel() {
        this.previewXMLTree.setAttributeMap(this.getAttributeMap());
    }

    public static void main(String[] stringArray) {
        try {
            JFrame jFrame = new JFrame();
            ((Component)jFrame).setSize(300, 300);
            jFrame.setDefaultCloseOperation(3);
            AttributeEditor attributeEditor = new AttributeEditor();
            jFrame.getContentPane().add(attributeEditor);
            jFrame.pack();
            ((Component)jFrame).setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

