/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.common.xmlutil.gui.xmltree;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.xtools.common.xmlutil.gui.search.TextMatcher;
import com.softwareag.xtools.common.xmlutil.gui.search.TextSearchable;
import com.softwareag.xtools.common.xmlutil.gui.search.TextSegment;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.FragmentedTextNode;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.Interval;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.XMLTree;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.XMLTreeModel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class XMLTreeTextSearcher
implements TextSearchable,
TreeSelectionListener {
    private static final boolean PRE_CHECK = Precondition.isEnabled((Class)(class$com$softwareag$xtools$common$xmlutil$gui$xmltree$XMLTreeTextSearcher == null ? (class$com$softwareag$xtools$common$xmlutil$gui$xmltree$XMLTreeTextSearcher = XMLTreeTextSearcher.class$("com.softwareag.xtools.common.xmlutil.gui.xmltree.XMLTreeTextSearcher")) : class$com$softwareag$xtools$common$xmlutil$gui$xmltree$XMLTreeTextSearcher));
    private static final boolean POST_CHECK = Postcondition.isEnabled((Class)(class$com$softwareag$xtools$common$xmlutil$gui$xmltree$XMLTreeTextSearcher == null ? (class$com$softwareag$xtools$common$xmlutil$gui$xmltree$XMLTreeTextSearcher = XMLTreeTextSearcher.class$("com.softwareag.xtools.common.xmlutil.gui.xmltree.XMLTreeTextSearcher")) : class$com$softwareag$xtools$common$xmlutil$gui$xmltree$XMLTreeTextSearcher));
    protected XMLTree xmlTree = null;
    protected FragmentedTextNode markedNode = null;
    static /* synthetic */ Class class$com$softwareag$xtools$common$xmlutil$gui$xmltree$XMLTreeTextSearcher;

    public XMLTreeTextSearcher(XMLTree xMLTree) {
        if (PRE_CHECK) {
            Precondition.check((String)"Parameter 'xmlTree' must not be null", (xMLTree != null ? 1 : 0) != 0);
        }
        this.xmlTree = xMLTree;
        xMLTree.addTreeSelectionListener(this);
    }

    public boolean searchNext(String string, TextMatcher textMatcher) {
        if (PRE_CHECK) {
            Precondition.check((String)"Parameter 'searchString' must not be null", (string != null ? 1 : 0) != 0);
        }
        if (PRE_CHECK) {
            Precondition.check((String)"Parameter 'matcher' must not be null", (textMatcher != null ? 1 : 0) != 0);
        }
        TextSegment textSegment = null;
        if (this.xmlTree.getModel() instanceof XMLTreeModel) {
            FragmentedTextNode fragmentedTextNode = this.getCurrentNode();
            Interval interval = fragmentedTextNode.getMarkInterval();
            FragmentedTextNode fragmentedTextNode2 = null;
            int n = 0;
            if (interval != null && interval.getEnd() < fragmentedTextNode.getFragmentedText().getText().length() - 1) {
                n = interval.getBegin() + 1;
                fragmentedTextNode2 = fragmentedTextNode;
            } else {
                fragmentedTextNode2 = this.getSuccessor(fragmentedTextNode);
            }
            this.clearMark();
            while (textSegment == null && fragmentedTextNode2 != null) {
                String string2 = fragmentedTextNode2.getFragmentedText().getText();
                textSegment = textMatcher.indexOf(string2, string, n);
                if (textSegment != null) {
                    TreePath treePath = new TreePath(((XMLTreeModel)this.xmlTree.getModel()).getPathToRoot(fragmentedTextNode2));
                    this.xmlTree.setSelectionPath(treePath);
                    this.markNode(fragmentedTextNode2, new Interval(textSegment.getStartIndex(), textSegment.getEndIndex()));
                    this.xmlTree.scrollPathToVisible(treePath);
                    continue;
                }
                fragmentedTextNode2 = this.getSuccessor(fragmentedTextNode2);
                n = 0;
            }
        }
        return textSegment != null;
    }

    public boolean searchPrevious(String string, TextMatcher textMatcher) {
        if (PRE_CHECK) {
            Precondition.check((String)"Parameter 'searchString' must not be null", (string != null ? 1 : 0) != 0);
        }
        if (PRE_CHECK) {
            Precondition.check((String)"Parameter 'matcher' must not be null", (textMatcher != null ? 1 : 0) != 0);
        }
        TextSegment textSegment = null;
        if (this.xmlTree.getModel() instanceof XMLTreeModel) {
            FragmentedTextNode fragmentedTextNode = this.getCurrentNode();
            Interval interval = fragmentedTextNode.getMarkInterval();
            FragmentedTextNode fragmentedTextNode2 = null;
            int n = 0;
            if (interval != null && interval.getEnd() > 0) {
                n = interval.getEnd();
                fragmentedTextNode2 = fragmentedTextNode;
            } else {
                fragmentedTextNode2 = this.getPredecessor(fragmentedTextNode);
                n = fragmentedTextNode2 != null ? fragmentedTextNode2.getFragmentedText().getText().length() : 0;
            }
            this.clearMark();
            while (textSegment == null && fragmentedTextNode2 != null) {
                String string2 = fragmentedTextNode2.getFragmentedText().getText();
                textSegment = textMatcher.lastIndexOf(string2, string, n);
                if (textSegment != null) {
                    TreePath treePath = new TreePath(((XMLTreeModel)this.xmlTree.getModel()).getPathToRoot(fragmentedTextNode2));
                    this.xmlTree.setSelectionPath(treePath);
                    this.markNode(fragmentedTextNode2, new Interval(textSegment.getStartIndex(), textSegment.getEndIndex()));
                    this.xmlTree.scrollPathToVisible(treePath);
                    continue;
                }
                n = (fragmentedTextNode2 = this.getPredecessor(fragmentedTextNode2)) != null ? fragmentedTextNode2.getFragmentedText().getText().length() : 0;
            }
        }
        return textSegment != null;
    }

    public void resetPosition(boolean bl) {
        if (this.xmlTree.getModel() instanceof XMLTreeModel) {
            if (bl) {
                this.xmlTree.setSelectionPath(new TreePath(((XMLTreeModel)this.xmlTree.getModel()).getPathToRoot(this.getFirstNode())));
            } else {
                this.xmlTree.setSelectionPath(new TreePath(((XMLTreeModel)this.xmlTree.getModel()).getPathToRoot(this.getLastNode())));
            }
        }
    }

    protected void markNode(FragmentedTextNode fragmentedTextNode, Interval interval) {
        this.clearMark();
        this.markedNode = fragmentedTextNode;
        fragmentedTextNode.setMarkInterval(interval);
        ((XMLTreeModel)this.xmlTree.getModel()).nodeChanged(fragmentedTextNode);
    }

    protected void clearMark() {
        if (this.markedNode != null) {
            this.markedNode.setMarkInterval(null);
            ((XMLTreeModel)this.xmlTree.getModel()).nodeChanged(this.markedNode);
        }
    }

    protected FragmentedTextNode getFirstNode() {
        return (FragmentedTextNode)this.xmlTree.getModel().getRoot();
    }

    protected FragmentedTextNode getLastNode() {
        FragmentedTextNode fragmentedTextNode = (FragmentedTextNode)this.xmlTree.getModel().getRoot();
        while (fragmentedTextNode.getChildCount() > 0) {
            fragmentedTextNode = (FragmentedTextNode)fragmentedTextNode.getChildAt(fragmentedTextNode.getChildCount() - 1);
        }
        return fragmentedTextNode;
    }

    protected FragmentedTextNode getCurrentNode() {
        FragmentedTextNode fragmentedTextNode = null;
        TreePath treePath = this.xmlTree.getSelectionPath();
        if (treePath != null) {
            fragmentedTextNode = (FragmentedTextNode)treePath.getLastPathComponent();
        }
        if (fragmentedTextNode == null) {
            fragmentedTextNode = this.getFirstNode();
        }
        return fragmentedTextNode;
    }

    protected FragmentedTextNode getSuccessor(FragmentedTextNode fragmentedTextNode) {
        FragmentedTextNode fragmentedTextNode2 = null;
        fragmentedTextNode2 = fragmentedTextNode.getChildCount() > 0 ? (FragmentedTextNode)fragmentedTextNode.getChildAt(0) : this.getNextSibling(fragmentedTextNode);
        return fragmentedTextNode2;
    }

    protected FragmentedTextNode getPredecessor(FragmentedTextNode fragmentedTextNode) {
        FragmentedTextNode fragmentedTextNode2 = null;
        if (fragmentedTextNode.getParent() != null) {
            FragmentedTextNode fragmentedTextNode3 = (FragmentedTextNode)fragmentedTextNode.getParent();
            int n = fragmentedTextNode3.getIndex(fragmentedTextNode);
            fragmentedTextNode2 = n > 0 ? this.getDeepestRightChild((FragmentedTextNode)fragmentedTextNode3.getChildAt(n - 1)) : fragmentedTextNode3;
        }
        return fragmentedTextNode2;
    }

    protected FragmentedTextNode getNextSibling(FragmentedTextNode fragmentedTextNode) {
        FragmentedTextNode fragmentedTextNode2 = null;
        if (fragmentedTextNode.getParent() != null) {
            FragmentedTextNode fragmentedTextNode3 = (FragmentedTextNode)fragmentedTextNode.getParent();
            int n = fragmentedTextNode3.getIndex(fragmentedTextNode);
            fragmentedTextNode2 = n < fragmentedTextNode3.getChildCount() - 1 ? (FragmentedTextNode)fragmentedTextNode3.getChildAt(n + 1) : this.getNextSibling(fragmentedTextNode3);
        }
        return fragmentedTextNode2;
    }

    protected FragmentedTextNode getDeepestRightChild(FragmentedTextNode fragmentedTextNode) {
        FragmentedTextNode fragmentedTextNode2 = fragmentedTextNode;
        if (fragmentedTextNode != null && fragmentedTextNode.getChildCount() > 0) {
            fragmentedTextNode2 = this.getDeepestRightChild((FragmentedTextNode)fragmentedTextNode.getChildAt(fragmentedTextNode.getChildCount() - 1));
        }
        return fragmentedTextNode2;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.xmlTree.getModel() instanceof XMLTreeModel) {
            this.clearMark();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

