/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.common.xmlutil.gui.xmltree;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.AttributeMap;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.DocumentTreeNode;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.EndTagNodeSupport;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.FragmentedTextNode;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLTreeModel
extends DefaultTreeModel
implements TreeExpansionListener {
    private static final boolean PRE_CHECK = Precondition.isEnabled((Class)(class$com$softwareag$xtools$common$xmlutil$gui$xmltree$XMLTreeModel == null ? (class$com$softwareag$xtools$common$xmlutil$gui$xmltree$XMLTreeModel = XMLTreeModel.class$("com.softwareag.xtools.common.xmlutil.gui.xmltree.XMLTreeModel")) : class$com$softwareag$xtools$common$xmlutil$gui$xmltree$XMLTreeModel));
    private static final boolean POST_CHECK = Postcondition.isEnabled((Class)(class$com$softwareag$xtools$common$xmlutil$gui$xmltree$XMLTreeModel == null ? (class$com$softwareag$xtools$common$xmlutil$gui$xmltree$XMLTreeModel = XMLTreeModel.class$("com.softwareag.xtools.common.xmlutil.gui.xmltree.XMLTreeModel")) : class$com$softwareag$xtools$common$xmlutil$gui$xmltree$XMLTreeModel));
    protected Node node = null;
    static /* synthetic */ Class class$com$softwareag$xtools$common$xmlutil$gui$xmltree$XMLTreeModel;

    public XMLTreeModel(Node node) {
        this(node, null);
    }

    public XMLTreeModel(Node node, AttributeMap attributeMap) {
        this(node, attributeMap, false);
    }

    public XMLTreeModel(Node node, boolean bl) {
        this(node, null, bl);
    }

    public XMLTreeModel(Node node, AttributeMap attributeMap, boolean bl) {
        super(XMLTreeModel.createRootNode(node, attributeMap, bl));
        this.node = node;
    }

    public Node getRootNode() {
        if (POST_CHECK) {
            Postcondition.check((String)"Method getRootNode() must not return 'null'", (this.node != null ? 1 : 0) != 0);
        }
        return this.node;
    }

    public AttributeMap getAttributeMap() {
        return ((DocumentTreeNode)this.getRoot()).getAttributeMap();
    }

    public void setAttributeMap(AttributeMap attributeMap) {
        if (attributeMap == null) {
            attributeMap = new AttributeMap();
        }
        ((DocumentTreeNode)this.getRoot()).setAttributeMap(attributeMap);
    }

    protected static TreeNode createRootNode(Node node, AttributeMap attributeMap, boolean bl) {
        if (PRE_CHECK) {
            Precondition.check((String)"Parameter 'node' must not be null", (node != null ? 1 : 0) != 0);
        }
        if (attributeMap == null) {
            attributeMap = new AttributeMap();
        }
        return new DocumentTreeNode(XMLTreeModel.getAppropriateRoot(node).getOwnerDocument(), XMLTreeModel.getAppropriateRoot(node), attributeMap, bl);
    }

    public static Node getAppropriateRoot(Node node) {
        if (node instanceof Document) {
            return ((Document)node).getDocumentElement();
        }
        return node;
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        TreeNode treeNode = (TreeNode)treeExpansionEvent.getPath().getLastPathComponent();
        if (treeNode instanceof EndTagNodeSupport) {
            int n;
            MutableTreeNode mutableTreeNode;
            EndTagNodeSupport endTagNodeSupport = (EndTagNodeSupport)((Object)treeNode);
            endTagNodeSupport.nodeExpanded();
            this.nodeChanged(treeNode);
            FragmentedTextNode fragmentedTextNode = endTagNodeSupport.getEndTag();
            if (fragmentedTextNode != null && (mutableTreeNode = (MutableTreeNode)treeNode.getParent()) != null && (n = mutableTreeNode.getIndex(treeNode)) >= 0) {
                mutableTreeNode.insert(fragmentedTextNode, n + 1);
                this.nodesWereInserted(mutableTreeNode, new int[]{n + 1});
            }
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        TreeNode treeNode = (TreeNode)treeExpansionEvent.getPath().getLastPathComponent();
        if (treeNode instanceof EndTagNodeSupport) {
            int n;
            MutableTreeNode mutableTreeNode;
            EndTagNodeSupport endTagNodeSupport = (EndTagNodeSupport)((Object)treeNode);
            endTagNodeSupport.nodeCollapsed();
            this.nodeChanged(treeNode);
            FragmentedTextNode fragmentedTextNode = endTagNodeSupport.getEndTag();
            if (fragmentedTextNode != null && (mutableTreeNode = (MutableTreeNode)treeNode.getParent()) != null && (n = mutableTreeNode.getIndex(fragmentedTextNode)) >= 0) {
                mutableTreeNode.remove(n);
                this.nodesWereRemoved(mutableTreeNode, new int[]{n}, new Object[]{fragmentedTextNode});
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

