/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.common.xmlutil.gui.xmltree;

import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.FontMetricsProvider;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.Fragment;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.FragmentedText;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.FragmentedTextNode;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.Interval;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.StyledFragment;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.Utilities;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.XMLTree;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class XMLTreeCellRenderer
extends JComponent
implements Accessible,
TreeCellRenderer,
FontMetricsProvider {
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger((String)LOG_NAME);
    private static final int LEFT_INSET = 0;
    private static final int RIGHT_INSET = 0;
    private static final int TOP_INSET = 0;
    private static final int BOTTOM_INSET = 0;
    private static final int MAGIC_SPACE = 9;
    protected int iconGap = -1;
    protected Font plainFont = null;
    protected Font boldFont = null;
    protected Font italicFont = null;
    protected XMLTree tree = null;
    protected TreeNode currentNode = null;
    protected boolean isCurrentNodeSelected = false;
    protected int gap = 0;
    protected Font font = null;
    protected FontMetrics fontMetrics = null;
    protected boolean isPrinting = false;
    protected boolean gentleHighlighting = true;
    protected FragmentedText fragmentedText = new FragmentedText();
    protected boolean lineWrap = false;
    protected Color highlightColor = null;
    protected AccessibleContext accessibleContext = new AccessibleXMLTreeNode();

    public AccessibleContext getAccessibleContext() {
        return this.accessibleContext;
    }

    public boolean getLineWrap() {
        return this.lineWrap;
    }

    public void setLineWrap(boolean bl) {
        this.lineWrap = bl;
    }

    protected Color getHighlightColor() {
        return this.highlightColor;
    }

    protected void setHighlightColor(Color color) {
        this.highlightColor = color;
    }

    public void setGentleHighlighting(boolean bl) {
        this.gentleHighlighting = bl;
    }

    public boolean getGentleHighlighting() {
        return this.gentleHighlighting;
    }

    public void setFont(Font font) {
        if (font != this.getFont()) {
            this.plainFont = null;
            this.italicFont = null;
            this.boldFont = null;
        }
        super.setFont(font);
    }

    public Font getPlainFont() {
        if (this.plainFont == null) {
            this.plainFont = this.getFont();
        }
        return this.plainFont;
    }

    public Font getBoldFont() {
        if (this.boldFont == null) {
            this.boldFont = this.getPlainFont().deriveFont(1);
        }
        return this.boldFont;
    }

    public Font getItalicFont() {
        if (this.italicFont == null) {
            this.italicFont = this.getPlainFont().deriveFont(2);
        }
        return this.italicFont;
    }

    protected int getGap(XMLTree xMLTree, TreeNode treeNode) {
        return this.getGap(xMLTree, xMLTree.getPath(treeNode));
    }

    public int getGap(XMLTree xMLTree, TreePath treePath) {
        if (this.iconGap < 0) {
            this.iconGap = 0;
            int n = 0;
            if (((BasicTreeUI)xMLTree.getUI()).getCollapsedIcon() != null) {
                n = ((BasicTreeUI)xMLTree.getUI()).getCollapsedIcon().getIconWidth();
            }
            this.iconGap = n;
        }
        return treePath.getPathCount() * (this.iconGap + 9);
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.tree = (XMLTree)jTree;
        this.currentNode = (TreeNode)object;
        this.isCurrentNodeSelected = bl;
        this.fragmentedText.clear();
        if (object instanceof FragmentedTextNode) {
            FragmentedTextNode fragmentedTextNode = (FragmentedTextNode)object;
            fragmentedTextNode.render(this.fragmentedText);
            this.getAccessibleContext().setAccessibleName(fragmentedTextNode.getAccessibleName());
            this.getAccessibleContext().setAccessibleDescription(fragmentedTextNode.getAccessibleDescription());
        }
        this.setFont(jTree.getFont());
        this.setForeground(jTree.getForeground());
        this.setBackground(jTree.getBackground());
        this.setHighlightColor(this.tree.getHighlightColor());
        return this;
    }

    public boolean isPrintMode() {
        return this.isPrinting;
    }

    public void setPrintMode(boolean bl) {
        this.isPrinting = bl;
    }

    public Insets getInsets() {
        return this.getInsets(new Insets(0, 0, 0, 0));
    }

    public Insets getInsets(Insets insets) {
        insets.top = 0;
        insets.left = 0;
        insets.bottom = 0;
        insets.right = 0;
        return insets;
    }

    public Dimension getPreferredSize() {
        if (this.currentNode instanceof FragmentedTextNode) {
            if (this.getLineWrap()) {
                Utilities.adjustWidth(this.fragmentedText, this, this.getMaxWidth());
            }
            Dimension dimension = Utilities.getSize(this.fragmentedText, this);
            return dimension;
        }
        return super.getPreferredSize();
    }

    protected int getMaxWidth() {
        int n = -1;
        this.gap = this.getGap(this.tree, this.currentNode);
        if (this.isPrintMode()) {
            n = this.tree.getSize().width - this.gap;
        } else if (this.tree.getParent() != null) {
            n = this.tree.getParent() instanceof JViewport ? ((JViewport)this.tree.getParent()).getExtentSize().width - this.gap : this.tree.getParent().getSize().width - this.gap;
        }
        if (n < this.getMaxCharacterWidth()) {
            n = this.getMaxCharacterWidth();
        }
        return n;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.currentNode instanceof FragmentedTextNode) {
            if (this.getLineWrap()) {
                Utilities.adjustWidth(this.fragmentedText, this, this.getMaxWidth());
            }
            Dimension dimension = this.getSize();
            int n = dimension.width;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = this.getFontMetrics().getAscent();
            int n6 = 0;
            int n7 = 0;
            int n8 = Utilities.getLineEndIndex(n7, this.fragmentedText);
            Interval interval = null;
            while (n8 >= 0 && n8 < this.fragmentedText.length()) {
                interval = ((FragmentedTextNode)this.currentNode).getMarkInterval();
                n3 = n;
                n4 = n2;
                int n9 = 0;
                if (this.tree.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
                    n9 = dimension.width - Utilities.getLineSize((FragmentedText)this.fragmentedText, (int)n7, (int)n8, (FontMetricsProvider)this).width;
                }
                n = n9;
                n2 = this.drawLine(graphics, n9, n6 + n5, this.fragmentedText, n7, n8, interval) - n9;
                if (this.isCurrentNodeSelected) {
                    boolean bl = n8 == this.fragmentedText.length() - 1;
                    this.drawHighlight(graphics, n9, n6, n2 - 1, this.getLineHeight() - 1, n3, n4 - 1, bl);
                }
                n6 += this.getLineHeight();
                n7 = n8 + 1;
                n8 = n7 < this.fragmentedText.length() ? Utilities.getLineEndIndex(n7, this.fragmentedText) : -1;
            }
        }
    }

    protected int drawLine(Graphics graphics, int n, int n2, FragmentedText fragmentedText, int n3, int n4, Interval interval) {
        int n5 = n3;
        while (n5 <= n4) {
            Fragment fragment = fragmentedText.get(n5);
            if (fragment instanceof StyledFragment) {
                n = this.drawFragment(graphics, n, n2, (StyledFragment)fragment, Utilities.getIntervalForFragment(fragmentedText, n5, interval));
            }
            ++n5;
        }
        return n;
    }

    protected int drawFragment(Graphics graphics, int n, int n2, StyledFragment styledFragment, Interval interval) {
        AttributeSet attributeSet = styledFragment.getAttributeSet();
        if (attributeSet != null) {
            if (StyleConstants.isBold(attributeSet)) {
                graphics.setFont(this.getBoldFont());
            } else if (StyleConstants.isItalic(attributeSet)) {
                graphics.setFont(this.getItalicFont());
            } else {
                graphics.setFont(this.getPlainFont());
            }
            Color color = StyleConstants.getForeground(attributeSet);
            if (color == null) {
                color = this.getForeground();
            }
            if (interval != null) {
                String string = null;
                FontMetrics fontMetrics = graphics.getFontMetrics();
                if (interval.getBegin() > 0) {
                    graphics.setColor(color);
                    string = styledFragment.getText().substring(0, interval.getBegin());
                    graphics.drawString(string, n, n2);
                    n += fontMetrics.stringWidth(string);
                }
                string = styledFragment.getText().substring(interval.getBegin(), interval.getEnd() + 1);
                graphics.setColor(UIManager.getColor("TextArea.selectionBackground"));
                int n3 = fontMetrics.stringWidth(string);
                graphics.fillRect(n, n2 - fontMetrics.getAscent(), n3, fontMetrics.getHeight());
                graphics.setColor(UIManager.getColor("TextArea.selectionForeground"));
                graphics.drawString(string, n, n2);
                n += n3;
                if (interval.getEnd() < styledFragment.getText().length() - 1) {
                    graphics.setColor(color);
                    string = styledFragment.getText().substring(interval.getEnd() + 1);
                    graphics.drawString(string, n, n2);
                    n += fontMetrics.stringWidth(string);
                }
            } else {
                graphics.setColor(color);
                graphics.drawString(styledFragment.getText(), n, n2);
                n += styledFragment.getSize((FontMetricsProvider)this).width;
            }
        }
        return n;
    }

    protected void drawHighlight(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (n3 < 1) {
            n3 = 1;
        }
        graphics.setColor(this.getHighlightColor());
        int n7 = n + n3;
        int n8 = n2 + n4;
        graphics.drawLine(n, n2, n, n8);
        graphics.drawLine(n7, n2, n7, n8);
        int n9 = 0;
        int n10 = 0;
        if (this.tree.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
            n9 = Math.min(n, n5);
            n10 = Math.max(n, n5);
        } else {
            n9 = Math.min(n3, n6) + n;
            n10 = Math.max(n3, n6) + n;
        }
        graphics.drawLine(n9, n2, n10, n2);
        if (bl) {
            graphics.drawLine(n, n8, n7, n8);
        }
    }

    public int getLineHeight() {
        return this.getFontMetrics().getHeight() + 0 + 0;
    }

    protected int getMaxCharacterWidth() {
        return this.getFontMetrics().getMaxAdvance();
    }

    protected FontMetrics getFontMetrics() {
        if (this.font != this.getFont()) {
            this.font = this.getFont();
            this.fontMetrics = ((Component)this).getFontMetrics(this.font);
        }
        return this.fontMetrics;
    }

    public FontMetrics getFontMetrics(AttributeSet attributeSet) {
        Font font = this.getPlainFont();
        if (attributeSet != null) {
            font = StyleConstants.isBold(attributeSet) ? this.getBoldFont() : (StyleConstants.isItalic(attributeSet) ? this.getItalicFont() : this.getPlainFont());
        }
        return ((Component)this).getFontMetrics(font);
    }

    public class AccessibleXMLTreeNode
    extends JComponent.AccessibleJComponent {
        public AccessibleXMLTreeNode() {
            super(XMLTreeCellRenderer.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }
    }
}

