/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.common.xmlutil.gui.xmltree;

import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.AttributeMap;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.FragmentedText;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.FragmentedTextNode;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.XMLTreeCellRenderer;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.XMLTreeModel;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.XMLTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.plaf.metal.MetalTreeUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XMLTree
extends JTree {
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger((String)LOG_NAME);
    protected static final String INDENT = "   ";
    protected static final String COLLAPSED_INDENT = " + ";
    protected static final int GAP = 9;
    protected static final Color DEFAULT_BACKGROUND = Color.white;
    protected static final int ICON_PADDING = 2;
    protected Icon plusIcon = null;
    protected Icon minusIcon = null;
    protected Icon plusWithFocusIcon = null;
    protected Icon minusWithFocusIcon = null;
    protected BufferedImage plusWithFocusBuffer = null;
    protected BufferedImage minusWithFocusBuffer = null;
    protected static List copyKeyStrokes = null;
    protected AttributeMap attributeMap = null;
    protected static TreeModel defaultModel = null;
    protected BasicTreeUI treeUI = null;
    protected Dimension currentViewportSize = new Dimension();
    protected Dimension lastViewportSize = new Dimension();
    protected Color highlightColor = Color.gray;
    protected Color expandIconColor = new Color(200, 0, 0);

    public XMLTree() {
        this(null, null);
    }

    public XMLTree(Node node) {
        this(node, new AttributeMap());
    }

    public XMLTree(Node node, AttributeMap attributeMap) {
        this(node, attributeMap, false);
    }

    public XMLTree(Node node, boolean bl) {
        this(node, new AttributeMap(), bl);
    }

    public XMLTree(Node node, AttributeMap attributeMap, boolean bl) {
        this.createIcons();
        this.setAttributeMap(attributeMap);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setRootNode(node, attributeMap, bl);
        this.setCellRenderer(new XMLTreeCellRenderer());
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(2);
        this.setSelectionModel(defaultTreeSelectionModel);
        this.bindKeyStrokes();
    }

    protected void setBackground(AttributeMap attributeMap) {
        Color color = DEFAULT_BACKGROUND;
        AttributeSet attributeSet = attributeMap.getAttributeSet("Background");
        if (attributeSet != null) {
            color = StyleConstants.getForeground(attributeSet);
        }
        this.setBackground(color);
    }

    public void setRootNode(Node node) {
        this.setRootNode(node, this.getAttributeMap());
    }

    public void setRootNode(Node node, AttributeMap attributeMap) {
        this.setRootNode(node, attributeMap, false);
    }

    public void setRootNode(Node node, boolean bl) {
        this.setRootNode(node, this.getAttributeMap(), bl);
    }

    public void setRootNode(Node node, AttributeMap attributeMap, boolean bl) {
        XMLTreeModel xMLTreeModel = null;
        if (node != null) {
            if (attributeMap == null) {
                attributeMap = new AttributeMap();
            }
            this.attributeMap = attributeMap;
            xMLTreeModel = new XMLTreeModel(node, attributeMap, bl);
            this.setBackground(attributeMap);
        }
        this.setModel(xMLTreeModel);
    }

    public AttributeMap getAttributeMap() {
        TreeModel treeModel = this.getModel();
        if (treeModel instanceof XMLTreeModel) {
            return ((XMLTreeModel)treeModel).getAttributeMap();
        }
        return this.attributeMap;
    }

    public void setAttributeMap(AttributeMap attributeMap) {
        if (attributeMap == null) {
            attributeMap = new AttributeMap();
        }
        this.attributeMap = attributeMap;
        TreeModel treeModel = this.getModel();
        if (treeModel instanceof XMLTreeModel) {
            ((XMLTreeModel)treeModel).setAttributeMap(attributeMap);
            this.repaint();
        }
        this.setBackground(attributeMap);
    }

    public void setModel(TreeModel treeModel) {
        TreeModel treeModel2 = this.getModel();
        if (treeModel2 != null && treeModel2 instanceof XMLTreeModel) {
            this.removeTreeExpansionListener((XMLTreeModel)treeModel2);
        }
        if (treeModel != null) {
            super.setModel(treeModel);
            if (treeModel instanceof XMLTreeModel) {
                this.addTreeExpansionListener((XMLTreeModel)treeModel);
            }
        } else {
            this.setModel(XMLTree.getDefaultModel());
        }
    }

    public Node getRootNode() {
        Node node = null;
        if (this.getModel() instanceof XMLTreeModel) {
            node = ((XMLTreeModel)this.getModel()).getRootNode();
        }
        return node;
    }

    protected static TreeModel getDefaultModel() {
        if (defaultModel == null) {
            defaultModel = new DefaultTreeModel(new DefaultMutableTreeNode(""));
        }
        return defaultModel;
    }

    public TreePath getPath(TreeNode treeNode) {
        TreePath treePath = null;
        if (treeNode != null) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
            treePath = new TreePath(defaultTreeModel.getPathToRoot(treeNode));
        }
        return treePath;
    }

    public boolean getLineWrap() {
        return ((XMLTreeCellRenderer)this.getCellRenderer()).getLineWrap();
    }

    public void setLineWrap(boolean bl) {
        ((XMLTreeCellRenderer)this.getCellRenderer()).setLineWrap(bl);
        this.updatePreferredSize();
        this.revalidate();
    }

    public int getLineHeight() {
        return ((XMLTreeCellRenderer)this.getCellRenderer()).getLineHeight();
    }

    public void setFont(Font font) {
        Font font2 = this.getFont();
        if (font2 == null) {
            if (font != null) {
                super.setFont(font);
                this.createIcons();
                this.updatePreferredSize();
                this.revalidate();
            }
        } else if (font == null || !font2.equals(font)) {
            super.setFont(font);
            this.createIcons();
            this.updatePreferredSize();
            this.revalidate();
        }
    }

    public void updatePreferredSize() {
        XMLTreeUI xMLTreeUI = (XMLTreeUI)this.getUI();
        if (xMLTreeUI != null) {
            xMLTreeUI.updatePreferredSize();
        }
    }

    public Dimension getPreferredSize() {
        if (this.getLineWrap() && this.viewportSizeChanged()) {
            this.updatePreferredSize();
        }
        Dimension dimension = super.getPreferredSize();
        if (this.getLineWrap()) {
            dimension.width = Math.max(dimension.width, this.getMinimumWidth());
        }
        return dimension;
    }

    protected int getMinimumWidth() {
        int n = 0;
        if (this.getCellRenderer() instanceof XMLTreeCellRenderer) {
            XMLTreeCellRenderer xMLTreeCellRenderer = (XMLTreeCellRenderer)this.getCellRenderer();
            int n2 = 0;
            int n3 = this.getRowCount();
            int n4 = 0;
            while (n4 < n3) {
                n2 = xMLTreeCellRenderer.getGap(this, this.getPathForRow(n4)) + xMLTreeCellRenderer.getMaxCharacterWidth();
                n = Math.max(n, n2);
                ++n4;
            }
        }
        return n;
    }

    protected boolean viewportSizeChanged() {
        boolean bl = false;
        if (this.getParent() instanceof JViewport) {
            if (!this.getParent().getSize(this.currentViewportSize).equals(this.lastViewportSize)) {
                bl = true;
            }
            this.lastViewportSize.width = this.currentViewportSize.width;
            this.lastViewportSize.height = this.currentViewportSize.height;
        }
        return bl;
    }

    protected int findNextSelectableRow(int n) {
        boolean bl;
        int n2 = -1;
        boolean bl2 = bl = n - this.getLeadSelectionRow() > 0;
        n = bl ? ++n : --n;
        TreePath treePath = this.getPathForRow(n);
        while (n2 == -1 && treePath != null) {
            if (!((TreeNode)treePath.getLastPathComponent()).isLeaf()) {
                n2 = n;
            }
            n = bl ? ++n : --n;
            treePath = this.getPathForRow(n);
        }
        return n2;
    }

    public void expandAll() {
        TreeNode treeNode = (TreeNode)this.getModel().getRoot();
        if (treeNode != null) {
            this.expand(treeNode, true);
        }
    }

    public void expandRootChildren() {
        TreeNode treeNode = (TreeNode)this.getModel().getRoot();
        if (treeNode != null) {
            this.expand(treeNode, false);
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                this.expand(enumeration.nextElement(), false);
            }
        }
    }

    public void expand(TreeNode treeNode, boolean bl) {
        TreePath treePath = new TreePath(((DefaultTreeModel)this.getModel()).getPathToRoot(treeNode));
        this.expandPath(treePath);
        if (bl) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                this.expand(enumeration.nextElement(), bl);
            }
        }
    }

    protected void adjustPathBounds(Rectangle rectangle) {
        Icon icon;
        int n = 9;
        int n2 = 0;
        if (this.getUI() != null && (icon = ((XMLTreeUI)this.getUI()).getExpandedIcon()) != null) {
            n += icon.getIconWidth();
            n2 = icon.getIconHeight();
        }
        if (n > rectangle.x) {
            n = rectangle.x;
        }
        rectangle.x -= n;
        rectangle.width += n;
    }

    public void updateUI() {
        super.updateUI();
        this.setRowHeight(0);
    }

    public void setUI(TreeUI treeUI) {
        this.treeUI = treeUI instanceof XMLTreeUI ? (XMLTreeUI)treeUI : new XMLTreeUI();
        super.setUI(this.treeUI);
    }

    public void setHighlightColor(Color color) {
        this.highlightColor = color;
        this.updateExpandIconFocus();
        this.repaint();
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setExpandIconColor(Color color) {
        this.expandIconColor = color;
        this.createIcons();
        this.repaint();
    }

    public Color getExpandIconColor() {
        return this.expandIconColor;
    }

    protected void createIcons() {
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.getFont());
        Rectangle2D rectangle2D = fontMetrics.getStringBounds("+", null);
        Rectangle2D rectangle2D2 = fontMetrics.getStringBounds("-", null);
        int n = (int)Math.max(rectangle2D.getWidth(), rectangle2D2.getWidth()) + 4;
        int n2 = fontMetrics.getAscent() - fontMetrics.getDescent() / 2;
        int n3 = n2 - (fontMetrics.getHeight() - n2 - 1) / 2;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setFont(this.getFont());
        graphics2D.setColor(this.getExpandIconColor());
        int n4 = (int)Math.round(((double)n - rectangle2D.getWidth() - 4.0) / 2.0);
        ((Graphics)graphics2D).drawString("+", n4 + 2, n3);
        this.plusIcon = new ImageIcon(bufferedImage);
        bufferedImage = new BufferedImage(n, n2, 2);
        graphics2D = bufferedImage.createGraphics();
        graphics2D.setFont(this.getFont());
        graphics2D.setColor(this.getExpandIconColor());
        n4 = (int)Math.round(((double)n - rectangle2D2.getWidth() - 4.0) / 2.0);
        ((Graphics)graphics2D).drawString("-", n4 + 2, n3);
        this.minusIcon = new ImageIcon(bufferedImage);
        this.plusWithFocusBuffer = new BufferedImage(this.plusIcon.getIconWidth(), this.plusIcon.getIconHeight(), 2);
        this.plusIcon.paintIcon(this, this.plusWithFocusBuffer.getGraphics(), 0, 0);
        this.minusWithFocusBuffer = new BufferedImage(this.minusIcon.getIconWidth(), this.minusIcon.getIconHeight(), 2);
        this.minusIcon.paintIcon(this, this.minusWithFocusBuffer.getGraphics(), 0, 0);
        this.updateExpandIconFocus();
    }

    protected void updateExpandIconFocus() {
        Graphics graphics = this.plusWithFocusBuffer.getGraphics();
        graphics.setColor(this.getHighlightColor());
        graphics.drawRect(0, 0, this.plusWithFocusBuffer.getWidth() - 1, this.plusWithFocusBuffer.getHeight() - 1);
        this.plusWithFocusIcon = new ImageIcon(this.plusWithFocusBuffer);
        graphics = this.minusWithFocusBuffer.getGraphics();
        graphics.setColor(this.getHighlightColor());
        graphics.drawRect(0, 0, this.minusWithFocusBuffer.getWidth() - 1, this.minusWithFocusBuffer.getHeight() - 1);
        this.minusWithFocusIcon = new ImageIcon(this.minusWithFocusBuffer);
    }

    protected Icon getExpandedIcon(boolean bl) {
        if (this.minusIcon == null) {
            this.createIcons();
        }
        return bl ? this.minusWithFocusIcon : this.minusIcon;
    }

    protected Icon getCollapsedIcon(boolean bl) {
        if (this.plusIcon == null) {
            this.createIcons();
        }
        return bl ? this.plusWithFocusIcon : this.plusIcon;
    }

    public void setGentleHighlighting(boolean bl) {
        ((XMLTreeCellRenderer)this.getCellRenderer()).setGentleHighlighting(bl);
        this.repaint();
    }

    public boolean getGentleHighlighting() {
        return ((XMLTreeCellRenderer)this.getCellRenderer()).getGentleHighlighting();
    }

    protected String getSelectionAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        FragmentedText fragmentedText = new FragmentedText();
        String string = null;
        int n = this.getMinSelectionRow();
        int n2 = this.getMaxSelectionRow();
        if (n >= 0) {
            int n3 = n;
            while (n3 <= n2) {
                String string2 = null;
                TreePath treePath = this.getPathForRow(n3);
                TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
                if (treeNode instanceof FragmentedTextNode) {
                    fragmentedText.clear();
                    ((FragmentedTextNode)treeNode).render(fragmentedText);
                    string2 = fragmentedText.getText();
                } else {
                    string2 = treeNode.toString();
                }
                BufferedReader bufferedReader = new BufferedReader(new StringReader(string2));
                int n4 = treePath.getPathCount() - 2;
                while (n4 > 0) {
                    stringBuffer2.append(INDENT);
                    --n4;
                }
                if (treeNode.getChildCount() > 0 && this.isCollapsed(treePath)) {
                    stringBuffer2.append(COLLAPSED_INDENT);
                } else {
                    stringBuffer2.append(INDENT);
                }
                string = stringBuffer2.toString();
                stringBuffer2.setLength(0);
                try {
                    String string3 = bufferedReader.readLine();
                    while (string3 != null) {
                        stringBuffer.append(string);
                        stringBuffer.append(string3);
                        stringBuffer.append("\n");
                        string3 = bufferedReader.readLine();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ++n3;
            }
        }
        return stringBuffer.toString();
    }

    public void copy() {
        String string = this.getSelectionAsString();
        if (string != null && string.length() > 0) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(string);
            clipboard.setContents(stringSelection, stringSelection);
        }
    }

    protected void bindKeyStrokes() {
        InputMap inputMap = this.getInputMap(0);
        ActionMap actionMap = this.getActionMap();
        CopyAction copyAction = new CopyAction();
        List list = XMLTree.getCopyKeyStrokes();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            inputMap.put((KeyStroke)iterator.next(), copyAction.getValue("Name"));
            actionMap.put(copyAction.getValue("Name"), copyAction);
        }
    }

    protected static List getCopyKeyStrokes() {
        if (copyKeyStrokes == null) {
            copyKeyStrokes = new ArrayList();
            InputMap inputMap = (InputMap)UIManager.get("TextField.focusInputMap");
            KeyStroke[] keyStrokeArray = inputMap.allKeys();
            int n = 0;
            while (n < keyStrokeArray.length) {
                if (inputMap.get(keyStrokeArray[n]).equals("copy-to-clipboard")) {
                    copyKeyStrokes.add(keyStrokeArray[n]);
                }
                ++n;
            }
        }
        return copyKeyStrokes;
    }

    public static Font getMonospacedFont(Font font) {
        Font font2 = font;
        if (font != null && font.getName() != "Monospaced") {
            font2 = new Font("Monospaced", font.getStyle(), font.getSize());
        }
        return font2;
    }

    public static void main(String[] stringArray) {
        try {
            FileReader fileReader = new FileReader("request.xml");
            InputSource inputSource = new InputSource(fileReader);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            final JFrame jFrame = new JFrame();
            jFrame.setDefaultCloseOperation(3);
            XMLTree xMLTree = new XMLTree();
            xMLTree.setLineWrap(true);
            xMLTree.setRootNode(null);
            xMLTree.expandAll();
            JScrollPane jScrollPane = new JScrollPane(xMLTree);
            jFrame.getContentPane().add(jScrollPane);
            jFrame.pack();
            ((Component)jFrame).setVisible(true);
            XMLTreeModel xMLTreeModel = new XMLTreeModel((Node)document, true);
            xMLTree.setModel(xMLTreeModel);
            XMLTreeNode xMLTreeNode = (XMLTreeNode)xMLTreeModel.getRoot();
            xMLTreeNode = (XMLTreeNode)xMLTreeNode.getChildAt(1);
            xMLTree.repaint();
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println("setting windows Look&Feel");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                        SwingUtilities.updateComponentTreeUI(jFrame);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println("setting metal Look&Feel");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                        SwingUtilities.updateComponentTreeUI(jFrame);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected class CopyAction
    extends AbstractAction {
        public CopyAction() {
            this.putValue("Name", "CopyXMLTree");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XMLTree.this.copy();
        }
    }

    public class XMLTreeUI
    extends MetalTreeUI {
        public void updatePreferredSize() {
            if (this.treeState != null) {
                this.treeState.invalidateSizes();
                this.updateSize();
            }
        }

        protected void paintExpandControl(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
            Rectangle rectangle3 = new Rectangle(rectangle2);
            rectangle3.setBounds((int)rectangle3.getX(), (int)rectangle3.getY(), (int)rectangle3.getWidth(), XMLTree.this.getLineHeight());
            boolean bl4 = XMLTree.this.getLeadSelectionRow() == n;
            this.setUpIcons(bl4);
            super.paintExpandControl(graphics, rectangle, insets, rectangle3, treePath, n, bl, bl2, bl3);
        }

        protected void setUpIcons(boolean bl) {
            this.setExpandedIcon(XMLTree.this.getExpandedIcon(bl));
            this.setCollapsedIcon(XMLTree.this.getCollapsedIcon(bl));
        }

        protected void paintVerticalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, TreePath treePath) {
        }

        protected void paintHorizontalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        }

        protected void installDefaults() {
            super.installDefaults();
        }
    }
}

