/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.common.xmlutil.gui.xmltree;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.FontMetricsProvider;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.Fragment;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.FragmentedText;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.Interval;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.LineBreak;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.LineWrap;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.StyledFragment;
import java.awt.Dimension;
import java.awt.FontMetrics;

public class Utilities {
    private static final boolean PRE_CHECK = Precondition.isEnabled((Class)(class$com$softwareag$xtools$common$xmlutil$gui$xmltree$Utilities == null ? (class$com$softwareag$xtools$common$xmlutil$gui$xmltree$Utilities = Utilities.class$("com.softwareag.xtools.common.xmlutil.gui.xmltree.Utilities")) : class$com$softwareag$xtools$common$xmlutil$gui$xmltree$Utilities));
    private static final boolean POST_CHECK = Postcondition.isEnabled((Class)(class$com$softwareag$xtools$common$xmlutil$gui$xmltree$Utilities == null ? (class$com$softwareag$xtools$common$xmlutil$gui$xmltree$Utilities = Utilities.class$("com.softwareag.xtools.common.xmlutil.gui.xmltree.Utilities")) : class$com$softwareag$xtools$common$xmlutil$gui$xmltree$Utilities));
    static /* synthetic */ Class class$com$softwareag$xtools$common$xmlutil$gui$xmltree$Utilities;

    public static Interval getIntervalForFragment(FragmentedText fragmentedText, int n, Interval interval) {
        Interval interval2 = null;
        if (interval != null && n < fragmentedText.length()) {
            int n2 = fragmentedText.get(n).getText().length();
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                n3 += fragmentedText.get(n4).getText().length();
                ++n4;
            }
            int n5 = interval.getBegin() - n3;
            if (n5 < n2) {
                int n6;
                if (n5 < 0) {
                    n5 = 0;
                }
                if ((n6 = interval.getEnd() - n3) >= 0) {
                    if (n6 >= n2) {
                        n6 = n2 - 1;
                    }
                    interval2 = new Interval(n5, n6);
                }
            }
        }
        return interval2;
    }

    public static int getLineEndIndex(FragmentedText fragmentedText) {
        return Utilities.getLineEndIndex(0, fragmentedText);
    }

    public static int getLineEndIndex(int n, FragmentedText fragmentedText) {
        if (PRE_CHECK) {
            Precondition.check((String)"Parameter 'fragmentedText' must not be null", (fragmentedText != null ? 1 : 0) != 0);
        }
        int n2 = -1;
        while (n2 < 0 && n < fragmentedText.length()) {
            if (fragmentedText.get(n) instanceof LineBreak) {
                n2 = n;
            }
            ++n;
        }
        if (n2 < 0) {
            n2 = fragmentedText.length() - 1;
        }
        return n2;
    }

    public static Dimension getSize(FragmentedText fragmentedText, FontMetricsProvider fontMetricsProvider) {
        if (PRE_CHECK) {
            Precondition.check((String)"Parameter 'fragmentedText' must not be null", (fragmentedText != null ? 1 : 0) != 0);
        }
        if (PRE_CHECK) {
            Precondition.check((String)"Parameter 'fontMetricsProvider' must not be null", (fontMetricsProvider != null ? 1 : 0) != 0);
        }
        Dimension dimension = new Dimension();
        Object var3_3 = null;
        int n = 0;
        int n2 = Utilities.getLineEndIndex(n, fragmentedText);
        while (n2 >= 0 && n2 < fragmentedText.length()) {
            Utilities.addHeight(dimension, Utilities.getLineSize(fragmentedText, n, n2, fontMetricsProvider));
            n = n2 + 1;
            n2 = n < fragmentedText.length() ? Utilities.getLineEndIndex(n, fragmentedText) : -1;
        }
        return dimension;
    }

    public static void adjustWidth(FragmentedText fragmentedText, FontMetricsProvider fontMetricsProvider, int n) {
        if (PRE_CHECK) {
            Precondition.check((String)"Parameter 'fragmentedText' must not be null", (fragmentedText != null ? 1 : 0) != 0);
        }
        if (PRE_CHECK) {
            Precondition.check((String)"Parameter 'fontMetricsProvider' must not be null", (fontMetricsProvider != null ? 1 : 0) != 0);
        }
        Dimension dimension = null;
        Fragment fragment = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n3 < fragmentedText.length()) {
            fragment = fragmentedText.get(n3);
            if (fragment instanceof LineBreak) {
                n2 = 0;
                n4 = ++n3;
                continue;
            }
            dimension = fragment.getSize(fontMetricsProvider);
            if (n2 + dimension.width > n) {
                n4 = n3 = Utilities.splitFragmentedText(fragmentedText, n4, n3, fontMetricsProvider, n - n2);
                n2 = 0;
                continue;
            }
            n2 += dimension.width;
            ++n3;
        }
    }

    public static int splitFragmentedText(FragmentedText fragmentedText, int n, int n2, FontMetricsProvider fontMetricsProvider, int n3) {
        if (PRE_CHECK) {
            Precondition.check((String)"Parameter 'fragmentedText' must not be null", (fragmentedText != null ? 1 : 0) != 0);
        }
        if (PRE_CHECK) {
            Precondition.check((String)"Parameter 'fontMetricsProvider' must not be null", (fontMetricsProvider != null ? 1 : 0) != 0);
        }
        int n4 = n2 + 1;
        boolean bl = n == n2;
        Fragment fragment = fragmentedText.get(n2);
        if (fragment instanceof StyledFragment) {
            Object object;
            StyledFragment styledFragment = (StyledFragment)fragment;
            int n5 = Utilities.getClosestIndex(fragment, fontMetricsProvider.getFontMetrics(styledFragment.getAttributeSet()), n3);
            int n6 = n2;
            int n7 = n5;
            boolean bl2 = false;
            while (!bl2 && n2 >= n) {
                object = fragment.getText().toCharArray();
                int n8 = 0;
                if (n2 == n) {
                    n8 = 1;
                }
                int n9 = n7;
                while (n9 >= n8) {
                    char c = object[n9];
                    if (c == '>' && n9 < n7 || Character.isWhitespace(c)) {
                        n5 = n9 + 1;
                        n6 = n2;
                        bl2 = true;
                        break;
                    }
                    if (c == '=' && n9 < n7 && object[n9 + 1] == '\"') {
                        n5 = n9 + 1;
                        n6 = n2;
                        bl2 = true;
                        break;
                    }
                    if (c == '<') {
                        n5 = n9;
                        n6 = n2;
                        bl2 = true;
                        break;
                    }
                    if (c == '/' && n9 > n8 && object[n9 - 1] != '<') {
                        n5 = n9 + 1;
                        n6 = n2;
                        bl2 = true;
                        break;
                    }
                    if (c == '-') {
                        n5 = n9 + 1;
                        n6 = n2;
                        bl2 = true;
                        break;
                    }
                    --n9;
                }
                if (bl && fragment.getSize((FontMetricsProvider)fontMetricsProvider).width > n3) {
                    n6 = n2;
                    bl2 = true;
                }
                if (bl2 || --n2 < n) continue;
                fragment = fragmentedText.get(n2);
                n7 = fragment.getText().length() - 1;
            }
            fragment = fragmentedText.get(n6);
            if (fragment instanceof StyledFragment) {
                styledFragment = (StyledFragment)fragment;
                if (n5 <= 0) {
                    fragmentedText.add(n6, new LineWrap(styledFragment.getAttributeSet()));
                    n4 = n6 + 1;
                } else if (n5 >= styledFragment.getText().length() - 1) {
                    fragmentedText.add(n6 + 1, new LineWrap(styledFragment.getAttributeSet()));
                    n4 = n6 + 2;
                } else {
                    object = new StyledFragment(styledFragment.getText().substring(0, n5), styledFragment.getAttributeSet());
                    StyledFragment styledFragment2 = new StyledFragment(styledFragment.getText().substring(n5), styledFragment.getAttributeSet());
                    fragmentedText.remove(n6);
                    fragmentedText.add(n6, (Fragment)object);
                    fragmentedText.add(n6 + 1, new LineWrap(styledFragment.getAttributeSet()));
                    fragmentedText.add(n6 + 2, styledFragment2);
                    n4 = n6 + 2;
                }
            }
        }
        return n4;
    }

    public static int getClosestIndex(Fragment fragment, FontMetrics fontMetrics, int n) {
        if (PRE_CHECK) {
            Precondition.check((String)"Parameter 'fragment' must not be null", (fragment != null ? 1 : 0) != 0);
        }
        if (PRE_CHECK) {
            Precondition.check((String)"Parameter 'fontMetrics' must not be null", (fontMetrics != null ? 1 : 0) != 0);
        }
        int n2 = 0;
        char[] cArray = fragment.getText().toCharArray();
        int n3 = cArray.length - 1;
        int n4 = 0;
        while (n4 < cArray.length && n2 < n) {
            if ((n2 += fontMetrics.charWidth(cArray[n4])) >= n) {
                n3 = n4;
            }
            ++n4;
        }
        return n3;
    }

    public static Dimension getLineSize(FragmentedText fragmentedText, int n, int n2, FontMetricsProvider fontMetricsProvider) {
        Dimension dimension = new Dimension();
        int n3 = n;
        while (n3 <= n2) {
            Utilities.addWidth(dimension, fragmentedText.get(n3).getSize(fontMetricsProvider));
            ++n3;
        }
        return dimension;
    }

    protected static void addHeight(Dimension dimension, Dimension dimension2) {
        dimension.height += dimension2.height;
        if (dimension2.width > dimension.width) {
            dimension.width = dimension2.width;
        }
    }

    protected static void addWidth(Dimension dimension, Dimension dimension2) {
        dimension.width += dimension2.width;
        if (dimension2.height > dimension.height) {
            dimension.height = dimension2.height;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

