/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.common.xmlutil.gui.xmltree;

import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.AbstractEndTagNodeSupportingNode;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.AttributeMap;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.FragmentedText;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.InlineTreeNode;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.StyledFragment;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.TextTreeNode;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.TreeNodeFactory;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.XMLTreeNode;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElementTreeNode
extends AbstractEndTagNodeSupportingNode {
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger((String)LOG_NAME);
    protected boolean initialized = false;
    protected InlineTreeNode inlineTreeNode = null;
    protected boolean lazyChildInstantiation = false;

    public ElementTreeNode(Element element, AttributeMap attributeMap, boolean bl) {
        super(element, attributeMap);
        this.lazyChildInstantiation = bl;
        if (!bl) {
            this.updateChildren();
        }
    }

    protected void updateChildren() {
        if (!this.initialized) {
            this.initialized = true;
            Element element = (Element)this.getDOMNode();
            NodeList nodeList = element.getChildNodes();
            XMLTreeNode xMLTreeNode = null;
            int n = 0;
            while (n < nodeList.getLength()) {
                xMLTreeNode = TreeNodeFactory.createNode(nodeList.item(n), this.attributeMap, this.lazyChildInstantiation);
                if (xMLTreeNode != null) {
                    this.add(xMLTreeNode);
                }
                ++n;
            }
            if (this.getChildCount() == 1 && this.getChildAt(0) instanceof InlineTreeNode && ((InlineTreeNode)this.getChildAt(0)).shouldBeRenderedInline()) {
                this.inlineTreeNode = (InlineTreeNode)this.getChildAt(0);
                this.remove(this.inlineTreeNode);
            }
            XMLTreeNode xMLTreeNode2 = null;
            int n2 = 0;
            while (n2 < this.getChildCount()) {
                xMLTreeNode2 = (XMLTreeNode)this.getChildAt(n2);
                if (xMLTreeNode2 instanceof TextTreeNode && ((TextTreeNode)xMLTreeNode2).isWhitspaceOnly()) {
                    this.remove(xMLTreeNode2);
                    continue;
                }
                ++n2;
            }
        }
    }

    protected void setAttributeMapOnChildren(AttributeMap attributeMap) {
        super.setAttributeMapOnChildren(attributeMap);
        if (this.inlineTreeNode != null) {
            this.inlineTreeNode.setAttributeMap(attributeMap);
        }
    }

    public void renderEndTag(FragmentedText fragmentedText) {
        fragmentedText.add(new StyledFragment("</", this.attributeMap.getAttributeSet("Operator")));
        fragmentedText.add(new StyledFragment(((Element)this.getDOMNode()).getTagName(), this.attributeMap.getAttributeSet("ElementName")));
        fragmentedText.add(new StyledFragment(">", this.attributeMap.getAttributeSet("Operator")));
    }

    public void render(FragmentedText fragmentedText) {
        this.insertTagStart(fragmentedText);
        this.insertTagName(fragmentedText);
        this.insertAttributes(fragmentedText);
        this.insertTagEnd(fragmentedText);
        if (this.inlineTreeNode != null) {
            this.inlineTreeNode.render(fragmentedText);
            if (this.getChildCount() == 0) {
                this.getEndTag().render(fragmentedText);
            }
        }
    }

    protected void insertTagStart(FragmentedText fragmentedText) {
        fragmentedText.add(new StyledFragment("<", this.attributeMap.getAttributeSet("Operator")));
    }

    protected void insertTagName(FragmentedText fragmentedText) {
        fragmentedText.add(new StyledFragment(((Element)this.getDOMNode()).getTagName(), this.attributeMap.getAttributeSet("ElementName")));
    }

    protected void insertAttributes(FragmentedText fragmentedText) {
        NamedNodeMap namedNodeMap = this.getDOMNode().getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Node node = namedNodeMap.item(n);
            if (node.getNodeName().equals("xmlns") || node.getNodeName().startsWith("xmlns:")) {
                this.renderNamespaceDeclaration(fragmentedText, node);
            } else {
                this.renderAttribute(fragmentedText, node);
            }
            ++n;
        }
    }

    protected void renderAttribute(FragmentedText fragmentedText, Node node) {
        fragmentedText.add(new StyledFragment(" ", this.attributeMap.getAttributeSet("Operator")));
        fragmentedText.add(new StyledFragment(node.getNodeName(), this.attributeMap.getAttributeSet("AttributeName")));
        fragmentedText.add(new StyledFragment("=\"", this.attributeMap.getAttributeSet("Operator")));
        fragmentedText.add(new StyledFragment(node.getNodeValue(), this.attributeMap.getAttributeSet("AttributeValue")));
        fragmentedText.add(new StyledFragment("\"", this.attributeMap.getAttributeSet("Operator")));
    }

    protected void renderNamespaceDeclaration(FragmentedText fragmentedText, Node node) {
        fragmentedText.add(new StyledFragment(" ", this.attributeMap.getAttributeSet("Operator")));
        fragmentedText.add(new StyledFragment(node.getNodeName(), this.attributeMap.getAttributeSet("NamespaceDeclarationName")));
        fragmentedText.add(new StyledFragment("=\"", this.attributeMap.getAttributeSet("Operator")));
        fragmentedText.add(new StyledFragment(node.getNodeValue(), this.attributeMap.getAttributeSet("NamespaceDeclarationValue")));
        fragmentedText.add(new StyledFragment("\"", this.attributeMap.getAttributeSet("Operator")));
    }

    protected void insertTagEnd(FragmentedText fragmentedText) {
        if (this.getChildCount() == 0 & this.inlineTreeNode == null) {
            fragmentedText.add(new StyledFragment("/", this.attributeMap.getAttributeSet("Operator")));
        }
        fragmentedText.add(new StyledFragment(">", this.attributeMap.getAttributeSet("Operator")));
    }
}

