/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.common.xmlutil.gui.xmltree;

import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.AttributeMap;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.LazyXMLTreeNode;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.ProcessingInstructionTreeNode;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.TreeNodeFactory;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.XMLTreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentTreeNode
extends LazyXMLTreeNode {
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger((String)LOG_NAME);
    protected boolean initialized = false;
    protected Node rootNode = null;
    protected boolean lazyChildInstantiation = false;

    public DocumentTreeNode(Document document, Node node, AttributeMap attributeMap, boolean bl) {
        super(document, attributeMap);
        this.rootNode = node;
        this.lazyChildInstantiation = bl;
        if (!bl) {
            this.updateChildren();
        }
    }

    protected void updateChildren() {
        if (!this.initialized) {
            this.initialized = true;
            Document document = (Document)this.getDOMNode();
            NodeList nodeList = document.getChildNodes();
            XMLTreeNode xMLTreeNode = null;
            this.add(new ProcessingInstructionTreeNode("xml", "version=\"1.0\"", this.attributeMap));
            if (document.getDocumentElement() == this.rootNode) {
                int n = 0;
                while (n < nodeList.getLength()) {
                    xMLTreeNode = TreeNodeFactory.createNode(nodeList.item(n), this.attributeMap, this.lazyChildInstantiation);
                    if (xMLTreeNode != null) {
                        this.add(xMLTreeNode);
                    }
                    ++n;
                }
            } else if (this.rootNode != null && (xMLTreeNode = TreeNodeFactory.createNode(this.rootNode, this.attributeMap, this.lazyChildInstantiation)) != null) {
                this.add(xMLTreeNode);
            }
        }
    }

    protected void setAttributeMapOnChildren(AttributeMap attributeMap) {
        if (this.initialized) {
            super.setAttributeMapOnChildren(attributeMap);
        }
    }
}

