/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.common.xmlutil.gui.xmltree;

import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.AttributeMap;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.FragmentedText;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.FragmentedTextNode;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.Interval;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class DefaultFragmentedTextNode
extends DefaultMutableTreeNode
implements FragmentedTextNode {
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger((String)LOG_NAME);
    protected FragmentedText fragmentedText = null;
    protected AttributeMap attributeMap = null;
    protected boolean isCleared = true;
    protected Interval markInterval = null;

    public DefaultFragmentedTextNode(AttributeMap attributeMap) {
        this.attributeMap = attributeMap;
    }

    protected void clear() {
        this.getFragmentedText().clear();
        this.isCleared = true;
    }

    public FragmentedText getFragmentedText() {
        if (this.fragmentedText == null) {
            this.fragmentedText = new FragmentedText();
        }
        if (this.isCleared) {
            this.render(this.fragmentedText);
            this.isCleared = false;
        }
        return this.fragmentedText;
    }

    public void render(FragmentedText fragmentedText) {
    }

    public void setAttributeMap(AttributeMap attributeMap) {
        this.attributeMap = attributeMap;
        this.clear();
        this.setAttributeMapOnChildren(attributeMap);
    }

    protected void setAttributeMapOnChildren(AttributeMap attributeMap) {
        Enumeration<TreeNode> enumeration = this.children();
        TreeNode treeNode = null;
        while (enumeration.hasMoreElements()) {
            treeNode = enumeration.nextElement();
            if (!(treeNode instanceof FragmentedTextNode)) continue;
            ((FragmentedTextNode)treeNode).setAttributeMap(attributeMap);
        }
    }

    public AttributeMap getAttributeMap() {
        return this.attributeMap;
    }

    public Interval getMarkInterval() {
        return this.markInterval;
    }

    public void setMarkInterval(Interval interval) {
        this.markInterval = interval;
    }

    public String getAccessibleName() {
        return this.getFragmentedText().getText();
    }

    public String getAccessibleDescription() {
        return null;
    }
}

