/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.common.xmlutil.gui.xmltree;

import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.AttributeMap;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.DefaultXMLTreeNode;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.FragmentedText;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.InlineTreeNode;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.LineEnd;
import com.softwareag.xtools.common.xmlutil.gui.xmltree.StyledFragment;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.CharacterData;

public class CharacterDataTreeNode
extends DefaultXMLTreeNode
implements InlineTreeNode {
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger((String)LOG_NAME);
    protected boolean renderInline = false;
    protected List textLines = new ArrayList();
    protected String attributeSetKey = null;

    public CharacterDataTreeNode(CharacterData characterData, AttributeMap attributeMap, String string) {
        super(characterData, attributeMap);
        this.attributeSetKey = string;
        try {
            String string2 = ((CharacterData)this.getDOMNode()).getData();
            if (string2 != null) {
                BufferedReader bufferedReader = new BufferedReader(new StringReader(string2));
                String string3 = bufferedReader.readLine();
                while (string3 != null) {
                    this.textLines.add(string3.trim());
                    string3 = bufferedReader.readLine();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean bl = this.renderInline = this.textLines.size() <= 1;
        if (this.textLines.size() > 1 && ((String)this.textLines.get(0)).length() == 0) {
            this.textLines.remove(0);
        }
        if (this.textLines.size() > 1 && ((String)this.textLines.get(this.textLines.size() - 1)).length() == 0) {
            this.textLines.remove(this.textLines.size() - 1);
        }
    }

    public boolean isWhitspaceOnly() {
        CharacterData characterData = (CharacterData)this.getDOMNode();
        boolean bl = true;
        if (characterData.getData() != null) {
            bl = characterData.getData().trim().length() == 0;
        }
        return bl;
    }

    public boolean shouldBeRenderedInline() {
        return this.renderInline;
    }

    public void render(FragmentedText fragmentedText) {
        int n = 0;
        while (n < this.textLines.size()) {
            fragmentedText.add(new StyledFragment((String)this.textLines.get(n), this.attributeMap.getAttributeSet(this.attributeSetKey)));
            if (n < this.textLines.size() - 1) {
                fragmentedText.add(new LineEnd(this.attributeMap.getAttributeSet(this.attributeSetKey)));
            }
            ++n;
        }
    }
}

