/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.common.xmlutil.gui.xmltree;

import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class AttributeMap {
    public static final String BACKGROUND = "Background";
    public static final String OPERATOR = "Operator";
    public static final String ELEMENT_NAME = "ElementName";
    public static final String ATTRIBUTE_NAME = "AttributeName";
    public static final String ATTRIBUTE_VALUE = "AttributeValue";
    public static final String NAMESPACE_DECLARATION_NAME = "NamespaceDeclarationName";
    public static final String NAMESPACE_DECLARATION_VALUE = "NamespaceDeclarationValue";
    public static final String COMMENT = "Comment";
    public static final String CDATA_SECTION = "CDATASection";
    public static final String TEXT = "Text";
    public static final String PROCESSING_INSTRUCTION_NAME = "ProcessingInstructionName";
    public static final String PROCESSING_INSTRUCTION_VALUE = "ProcessingInstructionValue";
    public static final String DOCTYPE_NAME = "DoctypeName";
    public static final String DOCTYPE_ID_NAME = "DoctypeIDName";
    public static final String DOCTYPE_ID_VALUE = "DoctypeIDValue";
    public static final String ENTITY_REFERENCE = "EntityReference";
    public static final String ATTRIBUTE_MAP_ELEMENT = "attribute-map";
    public static final String ATTRIBUTE_SET_ELEMENT = "attribute-set";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String FONT_ELEMENT = "font";
    public static final String STYLE_ELEMENT = "style";
    public static final String COLOR_ELEMENT = "color";
    public static final String RED_ELEMENT = "red";
    public static final String GREEN_ELEMENT = "green";
    public static final String BLUE_ELEMENT = "blue";
    public static final String PLAIN_ELEMENT = "plain";
    public static final String BOLD_ELEMENT = "bold";
    public static final String ITALIC_ELEMENT = "italic";
    public static final String ROOT_ELEMENT_MUST_BE_ATTRIBUTE_MAP = "Root Element must be <attribute-map>";
    public static final String ATTRIBUTE_SET_MUST_BE_NAMED = "The <attribute-set> must have a 'name' attribute";
    public static final String NAME_ATTRIBUTE_MUST_BE_UNIQUE = "The 'name' attribute of the <attribute-set> must be unique";
    public static final String EXPECTED_INT_VALUE_FOR_ELEMENT = "Expected integer value for element ";
    protected static DocumentBuilder documentBuilder = null;
    protected Map attributes = new HashMap();

    public AttributeMap() {
        this.reset();
    }

    public AttributeMap(Document document) throws SAXException {
        this.parse(document.getDocumentElement());
    }

    public AttributeMap(Element element) throws SAXException {
        this.parse(element);
    }

    protected void parse(Element element) throws SAXException {
        if (!ATTRIBUTE_MAP_ELEMENT.equals(element.getNodeName())) {
            throw new SAXException(ROOT_ELEMENT_MUST_BE_ATTRIBUTE_MAP);
        }
        NodeList nodeList = element.getElementsByTagName(ATTRIBUTE_SET_ELEMENT);
        Object var3_3 = null;
        int n = 0;
        while (n < nodeList.getLength()) {
            this.parseAttributeSet((Element)nodeList.item(n));
            ++n;
        }
    }

    protected void parseAttributeSet(Element element) throws SAXException {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        Attr attr = element.getAttributeNode(NAME_ATTRIBUTE);
        if (attr == null) {
            throw new SAXException(ATTRIBUTE_SET_MUST_BE_NAMED);
        }
        String string = attr.getNodeValue();
        if (this.getAttributeSet(string) != null) {
            throw new SAXException(NAME_ATTRIBUTE_MUST_BE_UNIQUE);
        }
        NodeList nodeList = element.getElementsByTagName(COLOR_ELEMENT);
        if (nodeList.getLength() > 0) {
            this.parseColor((Element)nodeList.item(0), simpleAttributeSet);
        }
        if ((nodeList = element.getElementsByTagName(FONT_ELEMENT)).getLength() > 0) {
            this.parseFont((Element)nodeList.item(0), simpleAttributeSet);
        }
        this.attributes.put(string, simpleAttributeSet);
    }

    protected void parseColor(Element element, SimpleAttributeSet simpleAttributeSet) throws SAXException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        NodeList nodeList = element.getElementsByTagName(RED_ELEMENT);
        if (nodeList.getLength() > 0) {
            n = AttributeMap.getIntValue((Element)nodeList.item(0));
        }
        if ((nodeList = element.getElementsByTagName(GREEN_ELEMENT)).getLength() > 0) {
            n2 = AttributeMap.getIntValue((Element)nodeList.item(0));
        }
        if ((nodeList = element.getElementsByTagName(BLUE_ELEMENT)).getLength() > 0) {
            n3 = AttributeMap.getIntValue((Element)nodeList.item(0));
        }
        StyleConstants.setForeground(simpleAttributeSet, new Color(n, n2, n3));
    }

    protected void parseFont(Element element, SimpleAttributeSet simpleAttributeSet) throws SAXException {
        boolean bl = false;
        boolean bl2 = false;
        NodeList nodeList = element.getElementsByTagName(STYLE_ELEMENT);
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            if ((nodeList = element2.getElementsByTagName(ITALIC_ELEMENT)).getLength() > 0) {
                bl2 = true;
            }
            if ((nodeList = element2.getElementsByTagName(BOLD_ELEMENT)).getLength() > 0) {
                bl = true;
                bl2 = false;
            }
        }
        StyleConstants.setBold(simpleAttributeSet, bl);
        StyleConstants.setItalic(simpleAttributeSet, bl2);
    }

    protected static int getIntValue(Element element) throws SAXException {
        int n = 0;
        try {
            n = Integer.parseInt(AttributeMap.getTextValue(element));
        }
        catch (NumberFormatException numberFormatException) {
            throw new SAXException(EXPECTED_INT_VALUE_FOR_ELEMENT + element.getNodeName());
        }
        return n;
    }

    protected static String getTextValue(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n) instanceof Text) {
                stringBuffer.append(nodeList.item(n).getNodeValue());
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public Object clone() {
        AttributeMap attributeMap = new AttributeMap();
        Iterator iterator = this.getAttributeSetKeys();
        String string = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            attributeMap.putAttributeSet(string, new SimpleAttributeSet(this.getAttributeSet(string)));
        }
        return attributeMap;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AttributeMap)) {
            return false;
        }
        AttributeMap attributeMap = (AttributeMap)object;
        return this.attributes.equals(attributeMap.attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public Iterator getAttributeSetKeys() {
        return this.attributes.keySet().iterator();
    }

    public AttributeSet getAttributeSet(String string) {
        return (AttributeSet)this.attributes.get(string);
    }

    public void putAttributeSet(String string, AttributeSet attributeSet) {
        this.attributes.put(string, attributeSet);
    }

    public void reset() {
        this.attributes.clear();
        this.attributes.put(BACKGROUND, this.getBackgroundAttributes());
        this.attributes.put(OPERATOR, this.getOperatorAttributes());
        this.attributes.put(ELEMENT_NAME, this.getElementNameAttributes());
        this.attributes.put(ATTRIBUTE_NAME, this.getAttributeNameAttributes());
        this.attributes.put(ATTRIBUTE_VALUE, this.getAttributeValueAttributes());
        this.attributes.put(NAMESPACE_DECLARATION_NAME, this.getNamespaceDeclarationNameAttributes());
        this.attributes.put(NAMESPACE_DECLARATION_VALUE, this.getNamespaceDeclarationValueAttributes());
        this.attributes.put(COMMENT, this.getCommentAttributes());
        this.attributes.put(CDATA_SECTION, this.getCDATASectionAttributes());
        this.attributes.put(TEXT, this.getTextAttributes());
        this.attributes.put(PROCESSING_INSTRUCTION_NAME, this.getProcessingInstructionNameAttributes());
        this.attributes.put(PROCESSING_INSTRUCTION_VALUE, this.getProcessingInstructionValueAttributes());
        this.attributes.put(DOCTYPE_NAME, this.getDoctypeNameAttributes());
        this.attributes.put(DOCTYPE_ID_NAME, this.getDoctypeIDNameAttributes());
        this.attributes.put(DOCTYPE_ID_VALUE, this.getDoctypeIDValueAttributes());
        this.attributes.put(ENTITY_REFERENCE, this.getEntityReferenceAttributes());
    }

    protected AttributeSet getBackgroundAttributes() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.white);
        return simpleAttributeSet;
    }

    protected AttributeSet getOperatorAttributes() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.blue);
        return simpleAttributeSet;
    }

    protected AttributeSet getElementNameAttributes() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, new Color(150, 0, 0));
        return simpleAttributeSet;
    }

    protected AttributeSet getAttributeNameAttributes() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, new Color(150, 0, 0));
        return simpleAttributeSet;
    }

    protected AttributeSet getAttributeValueAttributes() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.black);
        StyleConstants.setBold(simpleAttributeSet, true);
        return simpleAttributeSet;
    }

    protected AttributeSet getNamespaceDeclarationNameAttributes() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.red);
        return simpleAttributeSet;
    }

    protected AttributeSet getNamespaceDeclarationValueAttributes() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.red);
        StyleConstants.setBold(simpleAttributeSet, true);
        return simpleAttributeSet;
    }

    protected AttributeSet getCommentAttributes() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.gray);
        return simpleAttributeSet;
    }

    protected AttributeSet getCDATASectionAttributes() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.black);
        return simpleAttributeSet;
    }

    protected AttributeSet getTextAttributes() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.black);
        StyleConstants.setBold(simpleAttributeSet, true);
        return simpleAttributeSet;
    }

    protected AttributeSet getProcessingInstructionNameAttributes() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.blue);
        return simpleAttributeSet;
    }

    protected AttributeSet getProcessingInstructionValueAttributes() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.blue);
        return simpleAttributeSet;
    }

    protected AttributeSet getDoctypeNameAttributes() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.blue);
        return simpleAttributeSet;
    }

    protected AttributeSet getDoctypeIDNameAttributes() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.blue);
        return simpleAttributeSet;
    }

    protected AttributeSet getDoctypeIDValueAttributes() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.blue);
        return simpleAttributeSet;
    }

    protected AttributeSet getEntityReferenceAttributes() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.blue);
        return simpleAttributeSet;
    }

    public Document toXML() throws ParserConfigurationException {
        Document document = AttributeMap.getDocumentBuilder().newDocument();
        this.toXML(document);
        return document;
    }

    public void toXML(Node node) {
        Document document = null;
        document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        Element element = document.createElement(ATTRIBUTE_MAP_ELEMENT);
        node.appendChild(element);
        Iterator iterator = this.getAttributeSetKeys();
        while (iterator.hasNext()) {
            element.appendChild(this.createAttributeSetElement((String)iterator.next(), document));
        }
    }

    protected Element createAttributeSetElement(String string, Document document) {
        AttributeSet attributeSet = this.getAttributeSet(string);
        Element element = document.createElement(ATTRIBUTE_SET_ELEMENT);
        element.setAttribute(NAME_ATTRIBUTE, string);
        element.appendChild(this.createColorElement(attributeSet, document));
        element.appendChild(this.createFontElement(attributeSet, document));
        return element;
    }

    private Element createFontElement(AttributeSet attributeSet, Document document) {
        Element element = document.createElement(FONT_ELEMENT);
        Element element2 = document.createElement(STYLE_ELEMENT);
        element.appendChild(element2);
        if (StyleConstants.isBold(attributeSet)) {
            element2.appendChild(document.createElement(BOLD_ELEMENT));
        } else if (StyleConstants.isItalic(attributeSet)) {
            element2.appendChild(document.createElement(ITALIC_ELEMENT));
        } else {
            element2.appendChild(document.createElement(PLAIN_ELEMENT));
        }
        return element;
    }

    private Element createColorElement(AttributeSet attributeSet, Document document) {
        Color color = StyleConstants.getForeground(attributeSet);
        Element element = document.createElement(COLOR_ELEMENT);
        Element element2 = document.createElement(RED_ELEMENT);
        element2.appendChild(document.createTextNode(Integer.toString(color.getRed())));
        element.appendChild(element2);
        Element element3 = document.createElement(BLUE_ELEMENT);
        element3.appendChild(document.createTextNode(Integer.toString(color.getBlue())));
        element.appendChild(element3);
        Element element4 = document.createElement(GREEN_ELEMENT);
        element4.appendChild(document.createTextNode(Integer.toString(color.getGreen())));
        element.appendChild(element4);
        return element;
    }

    protected static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (documentBuilder == null) {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        return documentBuilder;
    }
}

