/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.common.xmlutil.gui.search;

import com.softwareag.common.resourceutilities.DefaultXMLResourceBundleFailureHandler;
import com.softwareag.common.resourceutilities.XMLResourceBundle;
import com.softwareag.common.resourceutilities.XMLResourceBundleFailureHandler;
import com.softwareag.xtools.common.xmlutil.gui.search.DefaultTextMatcher;
import com.softwareag.xtools.common.xmlutil.gui.search.JTextComponentTextSearcher;
import com.softwareag.xtools.common.xmlutil.gui.search.TextSearchable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class SearchDialog
extends JDialog {
    protected static final String MESSAGES = "com.softwareag.xtools.common.xmlutil.gui.search.resources.messages";
    protected static final String EXCEPTION_OCCURRED = "ExceptionOccurred";
    protected static final String SEARCH_STRING_NOT_FOUND = "searchStringNotFound";
    protected static final String END_OF_FILE = "endOfFilePassed";
    protected static final String BEGIN_OF_FILE = "beginOfFilePassed";
    protected static final String RESOURCE = "com.softwareag.xtools.common.xmlutil.gui.search.resources.searchdialog";
    protected static final String SEARCH_DIALOG = "searchDialog";
    protected static final String SEARCH_DIALOG_TITLE = "searchDialogTitle";
    protected static final String SEARCH_FOR = "searchFor";
    protected static final String OPTIONS = "options";
    protected static final String CASE_SENSITIVE = "caseSensitive";
    protected static final String FIND_NEXT = "findNext";
    protected static final String FIND_PREVIOUS = "findPrevious";
    protected static final String CLOSE = "close";
    public static final String ACCESSIBLE_NAME_SUFFIX = "_accessibleName";
    public static final String ACCESSIBLE_DESCRIPTION_SUFFIX = "_accessibleDescription";
    public static final String MNEMONIC_SUFFIX = "_mnemonic";
    protected static final int INSETS = 5;
    protected static final DefaultXMLResourceBundleFailureHandler FAILURE_HANDLER = new DefaultXMLResourceBundleFailureHandler();
    protected TextSearchable textSearchable = null;
    protected DefaultTextMatcher textMatcher = null;
    protected JCheckBox caseSensitiveCheckbox = null;
    protected JTextField searchTextField = null;

    public SearchDialog(Dialog dialog) {
        this(dialog, SearchDialog.getStringResource(RESOURCE, SEARCH_DIALOG_TITLE));
    }

    public SearchDialog(Dialog dialog, String string) {
        super(dialog, string, false);
        this.initGui();
    }

    public SearchDialog(Frame frame) {
        this(frame, SearchDialog.getStringResource(RESOURCE, SEARCH_DIALOG_TITLE));
    }

    public SearchDialog(Frame frame, String string) {
        super(frame, string, false);
        this.initGui();
    }

    public TextSearchable getTextSearchable() {
        return this.textSearchable;
    }

    public void setTextSearchable(TextSearchable textSearchable) {
        this.textSearchable = textSearchable;
    }

    protected void initGui() {
        this.getAccessibleContext().setAccessibleDescription(SearchDialog.getAccessibleDescription(SEARCH_DIALOG));
        this.textMatcher = new DefaultTextMatcher();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout(5, 0));
        jPanel3.setBorder(new EmptyBorder(0, 5, 0, 5));
        jPanel2.add((Component)jPanel3, "North");
        JLabel jLabel = new JLabel(SearchDialog.getStringResource(SEARCH_FOR));
        jLabel.setDisplayedMnemonic(SearchDialog.getMnemonic(SEARCH_FOR));
        jLabel.getAccessibleContext().setAccessibleDescription(SearchDialog.getAccessibleDescription(SEARCH_FOR));
        jPanel3.add((Component)jLabel, "West");
        this.searchTextField = new JTextField(15);
        this.searchTextField.setToolTipText(SearchDialog.getAccessibleDescription(SEARCH_FOR));
        jLabel.setLabelFor(this.searchTextField);
        jPanel3.add((Component)this.searchTextField, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel4, "Center");
        jPanel4.setBorder(new EmptyBorder(0, 0, 0, 5));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel4.add((Component)jPanel5, "Center");
        jPanel5.setBorder(new TitledBorder(SearchDialog.getStringResource(OPTIONS)));
        this.caseSensitiveCheckbox = new JCheckBox(SearchDialog.getStringResource(CASE_SENSITIVE));
        this.caseSensitiveCheckbox.setMnemonic(SearchDialog.getMnemonic(CASE_SENSITIVE));
        this.caseSensitiveCheckbox.getAccessibleContext().setAccessibleDescription(SearchDialog.getAccessibleDescription(CASE_SENSITIVE));
        this.caseSensitiveCheckbox.setSelected(this.textMatcher.isCaseSensitive());
        this.caseSensitiveCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchDialog.this.textMatcher.setCaseSensitive(SearchDialog.this.caseSensitiveCheckbox.isSelected());
            }
        });
        jPanel5.add(this.caseSensitiveCheckbox);
        JPanel jPanel6 = new JPanel(new GridLayout(3, 0, 0, 5));
        jPanel6.setBorder(new EmptyBorder(0, 5, 0, 0));
        jPanel.add((Component)jPanel6, "East");
        JButton jButton = new JButton(SearchDialog.getStringResource(FIND_NEXT));
        jButton.setMnemonic(SearchDialog.getMnemonic(FIND_NEXT));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchDialog.this.findNext();
            }
        });
        jPanel6.add(jButton);
        JButton jButton2 = new JButton(SearchDialog.getStringResource(FIND_PREVIOUS));
        jButton2.setMnemonic(SearchDialog.getMnemonic(FIND_PREVIOUS));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchDialog.this.findPrevious();
            }
        });
        jPanel6.add(jButton2);
        JButton jButton3 = new JButton(SearchDialog.getStringResource(CLOSE));
        jButton3.setMnemonic(SearchDialog.getMnemonic(CLOSE));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)SearchDialog.this).setVisible(false);
            }
        });
        jPanel6.add(jButton3);
        this.pack();
    }

    protected void findNext() {
        boolean bl;
        if (this.textSearchable != null && !(bl = this.textSearchable.searchNext(this.searchTextField.getText(), this.textMatcher))) {
            this.displayMessage(END_OF_FILE);
            this.textSearchable.resetPosition(true);
            bl = this.textSearchable.searchNext(this.searchTextField.getText(), this.textMatcher);
            if (!bl) {
                this.displayMessage(SEARCH_STRING_NOT_FOUND, this.searchTextField.getText());
            }
        }
    }

    protected void findPrevious() {
        boolean bl;
        if (this.textSearchable != null && !(bl = this.textSearchable.searchPrevious(this.searchTextField.getText(), this.textMatcher))) {
            this.displayMessage(BEGIN_OF_FILE);
            this.textSearchable.resetPosition(false);
            bl = this.textSearchable.searchPrevious(this.searchTextField.getText(), this.textMatcher);
            if (!bl) {
                this.displayMessage(SEARCH_STRING_NOT_FOUND, this.searchTextField.getText());
            }
        }
    }

    protected void displayMessage(String string) {
        this.displayMessage(string, (String[])null);
    }

    protected void displayMessage(String string, String string2) {
        this.displayText(SearchDialog.getStringResource(MESSAGES, string), string2);
    }

    protected void displayMessage(String string, String[] stringArray) {
        this.displayText(SearchDialog.getStringResource(MESSAGES, string), stringArray);
    }

    protected void displayText(String string) {
        this.displayText(string, (String[])null);
    }

    protected void displayText(String string, String string2) {
        if (string2 != null) {
            this.displayText(string, new String[]{string2});
        } else {
            this.displayText(string, (String[])null);
        }
    }

    protected void displayText(String string, String[] stringArray) {
        if (stringArray != null) {
            string = MessageFormat.format(string, stringArray);
        }
        JOptionPane.showMessageDialog(this, string, "", 1);
    }

    public static String getStringResource(String string, String string2) {
        Object var2_2 = null;
        ResourceBundle resourceBundle = XMLResourceBundle.getBundle((String)string, null, null, (XMLResourceBundleFailureHandler)FAILURE_HANDLER);
        return resourceBundle.getString(string2);
    }

    public static String getStringResource(String string) {
        return SearchDialog.getStringResource(RESOURCE, string);
    }

    public static String getAccessibleName(String string) {
        return SearchDialog.getStringResource(string + ACCESSIBLE_NAME_SUFFIX);
    }

    public static String getAccessibleDescription(String string) {
        return SearchDialog.getStringResource(string + ACCESSIBLE_DESCRIPTION_SUFFIX);
    }

    public static char getMnemonic(String string) {
        return SearchDialog.getStringResource(string + MNEMONIC_SUFFIX).charAt(0);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        JTextArea jTextArea = new JTextArea();
        jFrame.getContentPane().add(jTextArea);
        ((Component)jFrame).setSize(200, 300);
        ((Component)jFrame).setVisible(true);
        SearchDialog searchDialog = new SearchDialog(jFrame);
        searchDialog.setTextSearchable(new JTextComponentTextSearcher(jTextArea));
        ((Component)searchDialog).setVisible(true);
    }
}

