/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.common.xmlutil.gui.search;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.xtools.common.xmlutil.gui.search.TextMatcher;
import com.softwareag.xtools.common.xmlutil.gui.search.TextSearchable;
import com.softwareag.xtools.common.xmlutil.gui.search.TextSegment;
import javax.swing.text.JTextComponent;

public class JTextComponentTextSearcher
implements TextSearchable {
    private static final boolean PRE_CHECK = Precondition.isEnabled((Class)(class$com$softwareag$xtools$common$xmlutil$gui$search$JTextComponentTextSearcher == null ? (class$com$softwareag$xtools$common$xmlutil$gui$search$JTextComponentTextSearcher = JTextComponentTextSearcher.class$("com.softwareag.xtools.common.xmlutil.gui.search.JTextComponentTextSearcher")) : class$com$softwareag$xtools$common$xmlutil$gui$search$JTextComponentTextSearcher));
    private static final boolean POST_CHECK = Postcondition.isEnabled((Class)(class$com$softwareag$xtools$common$xmlutil$gui$search$JTextComponentTextSearcher == null ? (class$com$softwareag$xtools$common$xmlutil$gui$search$JTextComponentTextSearcher = JTextComponentTextSearcher.class$("com.softwareag.xtools.common.xmlutil.gui.search.JTextComponentTextSearcher")) : class$com$softwareag$xtools$common$xmlutil$gui$search$JTextComponentTextSearcher));
    protected JTextComponent textComponent = null;
    static /* synthetic */ Class class$com$softwareag$xtools$common$xmlutil$gui$search$JTextComponentTextSearcher;

    public JTextComponentTextSearcher(JTextComponent jTextComponent) {
        if (PRE_CHECK) {
            Precondition.check((String)"Parameter 'textComponent' must not be null", (jTextComponent != null ? 1 : 0) != 0);
        }
        this.textComponent = jTextComponent;
    }

    public boolean searchNext(String string, TextMatcher textMatcher) {
        String string2;
        TextSegment textSegment;
        if (PRE_CHECK) {
            Precondition.check((String)"Parameter 'searchString' must not be null", (string != null ? 1 : 0) != 0);
        }
        if (PRE_CHECK) {
            Precondition.check((String)"Parameter 'matcher' must not be null", (textMatcher != null ? 1 : 0) != 0);
        }
        if ((textSegment = textMatcher.indexOf(string2 = this.textComponent.getText(), string, this.textComponent.getCaret().getDot())) != null) {
            this.textComponent.setSelectionStart(textSegment.getStartIndex());
            this.textComponent.setSelectionEnd(textSegment.getEndIndex() + 1);
        } else {
            this.textComponent.setSelectionStart(string2.length());
            this.textComponent.setSelectionEnd(string2.length());
        }
        return textSegment != null;
    }

    public boolean searchPrevious(String string, TextMatcher textMatcher) {
        TextSegment textSegment;
        if (PRE_CHECK) {
            Precondition.check((String)"Parameter 'searchString' must not be null", (string != null ? 1 : 0) != 0);
        }
        if (PRE_CHECK) {
            Precondition.check((String)"Parameter 'matcher' must not be null", (textMatcher != null ? 1 : 0) != 0);
        }
        String string2 = this.textComponent.getText();
        int n = this.textComponent.getCaret().getDot();
        if (this.textComponent.getSelectionEnd() - this.textComponent.getSelectionStart() > 0 && n > 0) {
            --n;
        }
        if ((textSegment = textMatcher.lastIndexOf(string2, string, n)) != null) {
            this.textComponent.setSelectionStart(textSegment.getStartIndex());
            this.textComponent.setSelectionEnd(textSegment.getEndIndex() + 1);
        } else {
            this.textComponent.setSelectionStart(string2.length());
            this.textComponent.setSelectionEnd(string2.length());
        }
        return textSegment != null;
    }

    public void resetPosition(boolean bl) {
        if (bl) {
            this.textComponent.setSelectionStart(0);
            this.textComponent.setSelectionEnd(0);
        } else {
            String string = this.textComponent.getText();
            this.textComponent.setSelectionStart(string.length());
            this.textComponent.setSelectionEnd(string.length());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

