/*
 * Decompiled with CFR 0.152.
 */
package com.birdstep.jni;

import com.birdstep.util.WeakEntry;

public abstract class JNIObject {
    public long cObjectID;
    public WeakEntry weakentry = null;

    public boolean equals(Object anObject) {
        if (!(anObject instanceof JNIObject)) {
            return false;
        }
        return this.cObjectID == ((JNIObject)anObject).cObjectID;
    }

    protected void finalize() throws Throwable {
        if (this.cObjectID != 0L) {
            this.release();
        }
    }

    public synchronized void release() {
        if (this.cObjectID == 0L) {
            throw new RuntimeException("Attempted to release object that has already been deleted");
        }
        int refcount = this.nativeRelease();
        if (refcount != 0) {
            // empty if block
        }
        this.cObjectID = 0L;
    }

    protected JNIObject(long cID) {
        this.cObjectID = cID;
    }

    public void checkNotReleased() {
        if (this.cObjectID == 0L) {
            throw new RuntimeException("Attempted to use object that has already been released");
        }
    }

    public abstract int nativeRelease();
}

