/*
 * Decompiled with CFR 0.152.
 */
package com.birdstep.bdbe.jni;

import com.birdstep.bdbe.BdbeAttrFlags;
import com.birdstep.bdbe.BdbeClass;
import com.birdstep.bdbe.BdbeDB;
import com.birdstep.bdbe.BdbeErrorCodes;
import com.birdstep.bdbe.BdbeException;
import com.birdstep.bdbe.BdbeIndex;
import com.birdstep.bdbe.BdbeIndexSegment;
import com.birdstep.bdbe.BdbeObjectId;
import com.birdstep.bdbe.BdbeSchema;
import com.birdstep.bdbe.BdbeType;
import com.birdstep.bdbe.jni.BdbeClassImpl;
import com.birdstep.bdbe.jni.BdbeImpl;
import com.birdstep.bdbe.jni.BdbeIndexImpl;
import com.birdstep.bdbe.jni.BdbeIndexSegmentNative;
import com.birdstep.bdbe.jni.BdbeNative;
import com.birdstep.bdbe.jni.BdbeObjectIdNative;
import com.birdstep.bdbe.jni.BdbeSchemaNative;
import com.birdstep.bdbe.jni.BirdstepUnknownImpl;
import com.birdstep.bdbe.jni.FloatingPointUtil;

class BdbeSchemaImpl
extends BirdstepUnknownImpl
implements BdbeSchema {
    BdbeDB db = null;
    boolean released = false;

    public BdbeSchemaImpl(long cID) {
        super(cID);
    }

    public synchronized Object clone() {
        this.checkNotReleased();
        return new BdbeSchemaImpl(BdbeSchemaNative.clone(this.cObjectID));
    }

    public void defineAttribute(BdbeClass typeClass, String szAttributeName, int base, short uAttributeId) throws BdbeException {
        this.defineAttribute(typeClass, szAttributeName, base, uAttributeId, 0, null);
    }

    public void defineAttribute(BdbeClass typeClass, String szAttributeName, int base, short uAttributeId, int flags) throws BdbeException {
        this.defineAttribute(typeClass, szAttributeName, base, uAttributeId, flags, null);
    }

    public void defineAttribute(BdbeClass typeClass, String szAttributeName, int base, short uAttributeId, int flags, Object defaultValue) throws BdbeException {
        if ((flags & BdbeAttrFlags.BDBE_AF_MANDATORY) == BdbeAttrFlags.BDBE_AF_MANDATORY) {
            this.defineMandatoryAttribute(typeClass, szAttributeName, base, uAttributeId, flags, defaultValue);
        } else {
            this.defineOptionalAttribute(typeClass, szAttributeName, base, uAttributeId, flags, defaultValue);
        }
    }

    public synchronized BdbeClass defineClass(BdbeClass typeParentClass, String szClassName, int classFlags) throws BdbeException {
        this.checkNotReleased();
        if (szClassName == null) {
            throw new NullPointerException();
        }
        long id = 0L;
        if (typeParentClass != null) {
            id = ((BdbeClassImpl)typeParentClass).cObjectID;
        }
        return new BdbeClassImpl(BdbeSchemaNative.defineClass(this.cObjectID, id, szClassName, classFlags));
    }

    public synchronized BdbeIndex defineIndex(BdbeClass typeClass, String szIndexName, int indexFlags, BdbeIndexSegment[] nde) throws BdbeException {
        long segments;
        this.checkNotReleased();
        if (szIndexName == null) {
            throw new NullPointerException();
        }
        int length = nde.length;
        long next = segments = BdbeSchemaNative.allocateIndexSegmentArray(length);
        int i = 0;
        while (i < length) {
            BdbeIndexSegmentNative.setSegment(next, nde[i]);
            next = BdbeSchemaNative.nextIndexSegmentArray(next);
            ++i;
        }
        return new BdbeIndexImpl(BdbeSchemaNative.defineIndex(this.cObjectID, ((BdbeClassImpl)typeClass).cObjectID, szIndexName, indexFlags, length, segments));
    }

    public void defineMandatoryAttribute(BdbeClass typeClass, String szAttributeName, int base, short uAttributeId) throws BdbeException {
        this.defineMandatoryAttribute(typeClass, szAttributeName, base, uAttributeId, 0, null);
    }

    public void defineMandatoryAttribute(BdbeClass typeClass, String szAttributeName, int base, short uAttributeId, int flags) throws BdbeException {
        this.defineMandatoryAttribute(typeClass, szAttributeName, base, uAttributeId, flags, null);
    }

    public synchronized void defineMandatoryAttribute(BdbeClass typeClass, String szAttributeName, int base, short uAttributeId, int flags, Object defaultValue) throws BdbeException {
        this.checkNotReleased();
        if (szAttributeName == null) {
            throw new NullPointerException();
        }
        BdbeImpl.checkType(defaultValue, base);
        long val = BdbeImpl.allocate(defaultValue);
        short size = BdbeImpl.sizeof(defaultValue);
        BdbeSchemaNative.defineMandatoryAttribute(this.cObjectID, ((BdbeClassImpl)typeClass).cObjectID, szAttributeName, base, uAttributeId, flags, val, size);
    }

    public void defineOptionalAttribute(BdbeClass typeClass, String szAttributeName, int base, short uAttributeId) throws BdbeException {
        this.defineOptionalAttribute(typeClass, szAttributeName, base, uAttributeId, 0, null);
    }

    public void defineOptionalAttribute(BdbeClass typeClass, String szAttributeName, int base, short uAttributeId, int flags) throws BdbeException {
        this.defineOptionalAttribute(typeClass, szAttributeName, base, uAttributeId, flags, null);
    }

    public synchronized void defineOptionalAttribute(BdbeClass typeClass, String szAttributeName, int base, short uAttributeId, int flags, Object defaultValue) throws BdbeException {
        this.checkNotReleased();
        if (szAttributeName == null) {
            throw new NullPointerException();
        }
        BdbeImpl.checkType(defaultValue, base);
        long val = BdbeImpl.allocate(defaultValue);
        short size = BdbeImpl.sizeof(defaultValue);
        BdbeSchemaNative.defineOptionalAttribute(this.cObjectID, ((BdbeClassImpl)typeClass).cObjectID, szAttributeName, base, uAttributeId, flags, val, size);
    }

    public synchronized void dropAttribute(BdbeClass clazz, short id) throws BdbeException {
        this.checkNotReleased();
        BdbeSchemaNative.dropAttribute(this.cObjectID, ((BdbeClassImpl)clazz).cObjectID, id);
    }

    public synchronized void dropClass(BdbeClass clazz) throws BdbeException {
        this.checkNotReleased();
        BdbeSchemaNative.dropClass(this.cObjectID, ((BdbeClassImpl)clazz).cObjectID);
    }

    public synchronized void dropIndex(BdbeIndex ndx) throws BdbeException {
        this.checkNotReleased();
        BdbeSchemaNative.dropIndex(this.cObjectID, ((BdbeIndexImpl)ndx).cObjectID);
    }

    public synchronized short getApplicationTypeOfAttribute(BdbeClass clazz, short attrid) throws BdbeException {
        this.checkNotReleased();
        return BdbeSchemaNative.getApplicationTypeOfAttribute(this.cObjectID, ((BdbeClassImpl)clazz).cObjectID, attrid);
    }

    public synchronized short getAttribute(BdbeClass typeClass, String szAttributeName) {
        this.checkNotReleased();
        if (szAttributeName == null) {
            throw new NullPointerException();
        }
        return BdbeSchemaNative.getAttribute(this.cObjectID, ((BdbeClassImpl)typeClass).cObjectID, szAttributeName);
    }

    public synchronized int getAttributeFlags(BdbeClass clazz, short attrId) {
        this.checkNotReleased();
        return BdbeSchemaNative.getAttributeFlags(this.cObjectID, ((BdbeClassImpl)clazz).cObjectID, attrId);
    }

    public synchronized String getAttributeName(BdbeClass typeClass, short uAttributeID) throws BdbeException {
        this.checkNotReleased();
        return BdbeSchemaNative.getAttributeName(this.cObjectID, ((BdbeClassImpl)typeClass).cObjectID, uAttributeID);
    }

    public synchronized int getAttributeType(BdbeClass typeClass, short uAttributeID) {
        this.checkNotReleased();
        return BdbeSchemaNative.getAttributeType(this.cObjectID, ((BdbeClassImpl)typeClass).cObjectID, uAttributeID);
    }

    public synchronized BdbeClass getClass(String szClassName) {
        this.checkNotReleased();
        if (szClassName == null) {
            throw new NullPointerException();
        }
        long id = BdbeSchemaNative.getClass(this.cObjectID, szClassName);
        if (id == 0L) {
            return null;
        }
        return new BdbeClassImpl(id);
    }

    public synchronized int getClassFlags(BdbeClass typeClass) {
        this.checkNotReleased();
        return BdbeSchemaNative.getClassFlags(this.cObjectID, ((BdbeClassImpl)typeClass).cObjectID);
    }

    public synchronized String getClassName(BdbeClass type) {
        this.checkNotReleased();
        return BdbeSchemaNative.getClassName(this.cObjectID, ((BdbeClassImpl)type).cObjectID);
    }

    public synchronized Object getDefaultValue(BdbeClass clazz, short uAttributeID) throws BdbeException {
        int attrType = this.getAttributeType(clazz, uAttributeID);
        if (attrType == BdbeType.BDBE_TYPE_NONE) {
            BdbeNative.throwBdbeException(BdbeErrorCodes.ERROR_BDBE_NO_ATTRIBUTE);
            return null;
        }
        if (attrType == BdbeType.BDBE_TYPE_CHAR || attrType == BdbeType.BDBE_TYPE_UCHAR) {
            return new Byte(BdbeSchemaNative.getDefaultValueByte(this.cObjectID, ((BdbeClassImpl)clazz).cObjectID, uAttributeID));
        }
        if (attrType == BdbeType.BDBE_TYPE_SHORT || attrType == BdbeType.BDBE_TYPE_USHORT) {
            return new Short(BdbeSchemaNative.getDefaultValueShort(this.cObjectID, ((BdbeClassImpl)clazz).cObjectID, uAttributeID));
        }
        if (attrType == BdbeType.BDBE_TYPE_LONG || attrType == BdbeType.BDBE_TYPE_ULONG) {
            return new Integer(BdbeSchemaNative.getDefaultValueInt(this.cObjectID, ((BdbeClassImpl)clazz).cObjectID, uAttributeID));
        }
        if (attrType == BdbeType.BDBE_TYPE_FLOAT) {
            return FloatingPointUtil.getDefaultValueFloat(this.cObjectID, ((BdbeClassImpl)clazz).cObjectID, uAttributeID);
        }
        if (attrType == BdbeType.BDBE_TYPE_DOUBLE) {
            return FloatingPointUtil.getDefaultValueDouble(this.cObjectID, ((BdbeClassImpl)clazz).cObjectID, uAttributeID);
        }
        if (attrType == BdbeType.BDBE_TYPE_OID) {
            return this.getDefaultValueObjectId(clazz, uAttributeID);
        }
        if (attrType == BdbeType.BDBE_TYPE_TEXT) {
            return BdbeSchemaNative.getDefaultValueString(this.cObjectID, ((BdbeClassImpl)clazz).cObjectID, uAttributeID);
        }
        throw new RuntimeException("Illegal attribute type in database: " + attrType);
    }

    private BdbeObjectId getDefaultValueObjectId(BdbeClass clazz, short attrId) throws BdbeException {
        long id = BdbeSchemaNative.getDefaultValueObjectId(this.cObjectID, ((BdbeClassImpl)clazz).cObjectID, attrId);
        if (id == 0L) {
            return null;
        }
        return BdbeObjectIdNative.getObjectId(id);
    }

    public synchronized short getFirstAttribute(BdbeClass typeClass) {
        this.checkNotReleased();
        return BdbeSchemaNative.getFirstAttribute(this.cObjectID, ((BdbeClassImpl)typeClass).cObjectID);
    }

    public synchronized BdbeClass getFirstClass() {
        this.checkNotReleased();
        long id = BdbeSchemaNative.getFirstClass(this.cObjectID);
        if (id == 0L) {
            return null;
        }
        return new BdbeClassImpl(id);
    }

    public synchronized BdbeIndex getFirstIndex(BdbeClass clazz) {
        this.checkNotReleased();
        long index = BdbeSchemaNative.getFirstIndex(this.cObjectID, ((BdbeClassImpl)clazz).cObjectID);
        if (index == 0L) {
            return null;
        }
        return new BdbeIndexImpl(index);
    }

    public synchronized BdbeIndex getIndex(BdbeClass clazz, String szName) {
        this.checkNotReleased();
        if (szName == null) {
            throw new NullPointerException();
        }
        long id = BdbeSchemaNative.getIndex(this.cObjectID, ((BdbeClassImpl)clazz).cObjectID, szName);
        if (id == 0L) {
            return null;
        }
        return new BdbeIndexImpl(id);
    }

    public synchronized BdbeClass getIndexedClass(BdbeIndex ndx) {
        this.checkNotReleased();
        return new BdbeClassImpl(BdbeSchemaNative.getIndexedClass(this.cObjectID, ((BdbeIndexImpl)ndx).cObjectID));
    }

    public synchronized int getIndexFlags(BdbeIndex index) {
        this.checkNotReleased();
        return BdbeSchemaNative.getIndexFlags(this.cObjectID, ((BdbeIndexImpl)index).cObjectID);
    }

    public synchronized String getIndexName(BdbeIndex ndx) {
        this.checkNotReleased();
        return BdbeSchemaNative.getIndexName(this.cObjectID, ((BdbeIndexImpl)ndx).cObjectID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized BdbeIndexSegment[] getIndexSegments(BdbeIndex ndx) {
        BdbeIndexSegment[] bdbeIndexSegmentArray;
        this.checkNotReleased();
        int numsegments = this.getNumberOfIndexSegments(ndx);
        BdbeIndexSegment[] toReturn = new BdbeIndexSegment[numsegments];
        long cID = BdbeSchemaNative.allocateIndexSegmentArray(numsegments);
        try {
            BdbeSchemaNative.getIndexSegments(this.cObjectID, ((BdbeIndexImpl)ndx).cObjectID, cID);
            long next = cID;
            int i = 0;
            while (i < numsegments) {
                toReturn[i] = BdbeIndexSegmentNative.getSegment(next);
                next = BdbeSchemaNative.nextIndexSegmentArray(next);
                ++i;
            }
            bdbeIndexSegmentArray = toReturn;
            Object var11_8 = null;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            BdbeIndexSegmentNative.release(cID);
            throw throwable;
        }
        BdbeIndexSegmentNative.release(cID);
        return bdbeIndexSegmentArray;
    }

    public synchronized short getMaxSizeOfAttribute(BdbeClass clazz, short attrid) throws BdbeException {
        this.checkNotReleased();
        return BdbeSchemaNative.getMaxSizeOfAttribute(this.cObjectID, ((BdbeClassImpl)clazz).cObjectID, attrid);
    }

    public synchronized short getNextAttribute(BdbeClass typeClass, short uPrevAttributeID) {
        this.checkNotReleased();
        return BdbeSchemaNative.getNextAttribute(this.cObjectID, ((BdbeClassImpl)typeClass).cObjectID, uPrevAttributeID);
    }

    public synchronized BdbeClass getNextClass(BdbeClass typePrevious) {
        this.checkNotReleased();
        long id = BdbeSchemaNative.getNextClass(this.cObjectID, ((BdbeClassImpl)typePrevious).cObjectID);
        if (id == 0L) {
            return null;
        }
        return new BdbeClassImpl(id);
    }

    public synchronized BdbeIndex getNextIndex(BdbeIndex ndxPrevious) {
        this.checkNotReleased();
        long id = BdbeSchemaNative.getNextIndex(this.cObjectID, ((BdbeIndexImpl)ndxPrevious).cObjectID);
        if (id == 0L) {
            return null;
        }
        return new BdbeIndexImpl(id);
    }

    public synchronized int getNumberOfAttributes(BdbeClass typeClass) {
        this.checkNotReleased();
        return BdbeSchemaNative.getNumberOfAttributes(this.cObjectID, ((BdbeClassImpl)typeClass).cObjectID);
    }

    public synchronized int getNumberOfIndexSegments(BdbeIndex ndx) {
        this.checkNotReleased();
        return BdbeSchemaNative.getNumberOfIndexSegments(this.cObjectID, ((BdbeIndexImpl)ndx).cObjectID);
    }

    public synchronized BdbeClass getParentClass(BdbeClass typeClass) {
        this.checkNotReleased();
        long id = BdbeSchemaNative.getParentClass(this.cObjectID, ((BdbeClassImpl)typeClass).cObjectID);
        if (id == 0L) {
            return null;
        }
        return new BdbeClassImpl(id);
    }

    public synchronized int getVersion() {
        this.checkNotReleased();
        return BdbeSchemaNative.getVersion(this.cObjectID);
    }

    public void release() {
        if (this.db != null) {
            this.db.release();
        } else {
            if (this.released) {
                throw new RuntimeException("Attempted to release object that has already been released");
            }
            super.release();
        }
        this.released = true;
    }

    public synchronized void setVersion(int version) throws BdbeException {
        this.checkNotReleased();
        BdbeSchemaNative.setVersion(this.cObjectID, version);
    }

    protected void finalize() throws Throwable {
        if (!this.released) {
            this.release();
        }
    }
}

