/*
 * Decompiled with CFR 0.152.
 */
package com.birdstep.bdbe.jni;

import com.birdstep.BirdstepIf;
import com.birdstep.BirdstepUnknown;
import com.birdstep.bdbe.Bdbe;
import com.birdstep.bdbe.BdbeConstants;
import com.birdstep.bdbe.BdbeCursor;
import com.birdstep.bdbe.BdbeDB;
import com.birdstep.bdbe.BdbeException;
import com.birdstep.bdbe.BdbeObject;
import com.birdstep.bdbe.BdbeObjectId;
import com.birdstep.bdbe.BdbeOpenFlags;
import com.birdstep.bdbe.BdbeSchema;
import com.birdstep.bdbe.BdbeType;
import com.birdstep.bdbe.jni.BdbeCursorImpl;
import com.birdstep.bdbe.jni.BdbeDBImpl;
import com.birdstep.bdbe.jni.BdbeNative;
import com.birdstep.bdbe.jni.BdbeSchemaImpl;
import com.birdstep.bdbe.jni.FloatingPointUtil;
import com.birdstep.jni.JNIObject;
import com.birdstep.util.Reporter;

public class BdbeImpl
implements Bdbe {
    public BdbeSchema createSchema() throws BdbeException {
        return new BdbeSchemaImpl(BdbeNative.createSchema());
    }

    public short getRevision() throws BdbeException {
        return BdbeNative.getRevision();
    }

    public short getVersion() throws BdbeException {
        return BdbeNative.getVersion();
    }

    static long allocate(Object value) throws BdbeException {
        long val = 0L;
        if (value instanceof Byte || value == null) {
            if (value != null) {
                val = BdbeNative.allocateByte((Byte)value);
            }
        } else if (value instanceof Short) {
            val = BdbeNative.allocateShort((Short)value);
        } else if (value instanceof Integer) {
            val = BdbeNative.allocateInt((Integer)value);
        } else if (FloatingPointUtil.instanceOfFloat(value)) {
            val = FloatingPointUtil.allocateFloat(value);
        } else if (FloatingPointUtil.instanceOfDouble(value)) {
            val = FloatingPointUtil.allocateDouble(value);
        } else if (value instanceof BdbeObjectId) {
            val = BdbeNative.allocateObjectId(((BdbeObjectId)value).dbid, ((BdbeObjectId)value).loid);
        } else if (value instanceof BdbeObject) {
            val = BdbeNative.allocateObjectId(((BdbeObject)value).getObjectId().dbid, ((BdbeObject)value).getObjectId().loid);
        } else if (value instanceof String) {
            val = BdbeNative.allocateString((String)value);
        } else {
            throw new RuntimeException("Illegal attribute type in database: ");
        }
        return val;
    }

    static void checkType(Object value, int bdbeType) {
        boolean okType = true;
        if (value != null) {
            if (value instanceof Byte) {
                okType = bdbeType == BdbeType.BDBE_TYPE_CHAR || bdbeType == BdbeType.BDBE_TYPE_UCHAR;
            } else if (value instanceof Short) {
                okType = bdbeType == BdbeType.BDBE_TYPE_SHORT || bdbeType == BdbeType.BDBE_TYPE_USHORT;
            } else if (value instanceof Integer) {
                okType = bdbeType == BdbeType.BDBE_TYPE_LONG || bdbeType == BdbeType.BDBE_TYPE_ULONG;
            } else if (FloatingPointUtil.instanceOfFloat(value)) {
                okType = bdbeType == BdbeType.BDBE_TYPE_FLOAT;
            } else if (FloatingPointUtil.instanceOfDouble(value)) {
                okType = bdbeType == BdbeType.BDBE_TYPE_DOUBLE;
            } else if (value instanceof BdbeObjectId || value instanceof BdbeObject) {
                okType = bdbeType == BdbeType.BDBE_TYPE_OID;
            } else if (value instanceof String) {
                okType = bdbeType == BdbeType.BDBE_TYPE_TEXT;
            } else {
                throw new RuntimeException("Illegal attribute type in database: ");
            }
        }
        if (!okType) {
            throw new RuntimeException("Attributetype and actual type does not match");
        }
    }

    static long getArrayLengths(Object[] objects) {
        long toReturn;
        if (objects == null) {
            return 0L;
        }
        long toAdd = toReturn = BdbeNative.allocateUnsigned32Array(objects.length);
        int i = 0;
        while (i < objects.length) {
            Object next = objects[i];
            if (next instanceof Byte) {
                toAdd = BdbeNative.addIntToUnsigned32Array(toAdd, BdbeNative.sizeof(BdbeType.BDBE_TYPE_CHAR));
            } else if (next instanceof Short) {
                toAdd = BdbeNative.addIntToUnsigned32Array(toAdd, BdbeNative.sizeof(BdbeType.BDBE_TYPE_SHORT));
            } else if (next instanceof Integer) {
                toAdd = BdbeNative.addIntToUnsigned32Array(toAdd, BdbeNative.sizeof(BdbeType.BDBE_TYPE_LONG));
            } else if (FloatingPointUtil.instanceOfFloat(next)) {
                toAdd = BdbeNative.addIntToUnsigned32Array(toAdd, BdbeNative.sizeof(BdbeType.BDBE_TYPE_FLOAT));
            } else if (FloatingPointUtil.instanceOfDouble(next)) {
                toAdd = BdbeNative.addIntToUnsigned32Array(toAdd, BdbeNative.sizeof(BdbeType.BDBE_TYPE_DOUBLE));
            } else if (next instanceof String) {
                toAdd = BdbeNative.addStringSizeToUnsigned32Array(toAdd, (String)next);
            } else if (next instanceof BdbeObjectId) {
                toAdd = BdbeNative.addIntToUnsigned32Array(toAdd, BdbeNative.sizeof(BdbeType.BDBE_TYPE_OID));
            } else {
                throw new RuntimeException("Could not find type for " + next);
            }
            ++i;
        }
        return toReturn;
    }

    public static BdbeDB getDatabase(long cID) {
        return new BdbeDBImpl(cID);
    }

    static long getUnsigned32Array(int[] ints) {
        long toReturn;
        if (ints == null) {
            return 0L;
        }
        long toAdd = toReturn = BdbeNative.allocateUnsigned32Array(ints.length);
        int i = 0;
        while (i < ints.length) {
            toAdd = BdbeNative.addIntToUnsigned32Array(toAdd, ints[i]);
            ++i;
        }
        return toReturn;
    }

    static long getVoidVoidArray(Object[] objects) throws BdbeException {
        long toReturn;
        if (objects == null) {
            return 0L;
        }
        long toAdd = toReturn = BdbeNative.allocateVoidVoidArray(objects.length);
        int i = 0;
        while (i < objects.length) {
            long add = 0L;
            Object next = objects[i];
            if (next instanceof Byte) {
                add = BdbeNative.allocateByte((Byte)next);
            } else if (next instanceof Short) {
                add = BdbeNative.allocateShort((Short)next);
            } else if (next instanceof Integer) {
                add = BdbeNative.allocateInt((Integer)next);
            } else if (FloatingPointUtil.instanceOfFloat(next)) {
                add = FloatingPointUtil.allocateFloat(next);
            } else if (FloatingPointUtil.instanceOfDouble(next)) {
                add = FloatingPointUtil.allocateDouble(next);
            } else if (next instanceof String) {
                add = BdbeNative.allocateString((String)next);
            } else if (next instanceof BdbeObjectId) {
                add = BdbeNative.allocateObjectId(((BdbeObjectId)next).dbid, ((BdbeObjectId)next).loid);
            } else if (next instanceof BdbeObject) {
                toAdd = BdbeNative.allocateObjectId(((BdbeObject)next).getObjectId().dbid, ((BdbeObject)next).getObjectId().loid);
            } else {
                throw new RuntimeException("Could not find type for " + next);
            }
            toAdd = BdbeNative.addVoidToArray(toAdd, add);
            ++i;
        }
        return toReturn;
    }

    public BdbeDB openDatabase(String szName, int flags) throws BdbeException {
        if (szName == null) {
            throw new NullPointerException();
        }
        FloatingPointUtil.securityCheckRead(szName);
        if ((flags & BdbeOpenFlags.BDBE_OF_READONLY) != BdbeOpenFlags.BDBE_OF_READONLY) {
            FloatingPointUtil.securityCheckWrite(szName);
        }
        return new BdbeDBImpl(BdbeNative.openDatabase(szName, flags));
    }

    static short sizeof(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Short) {
            return BdbeNative.sizeof(BdbeType.BDBE_TYPE_SHORT);
        }
        if (obj instanceof Byte) {
            return BdbeNative.sizeof(BdbeType.BDBE_TYPE_CHAR);
        }
        if (obj instanceof Integer) {
            return BdbeNative.sizeof(BdbeType.BDBE_TYPE_LONG);
        }
        if (obj instanceof BdbeObjectId) {
            return BdbeNative.sizeof(BdbeType.BDBE_TYPE_OID);
        }
        if (obj instanceof BdbeObject) {
            return BdbeNative.sizeof(BdbeType.BDBE_TYPE_OID);
        }
        if (FloatingPointUtil.instanceOfFloat(obj)) {
            return BdbeNative.sizeof(BdbeType.BDBE_TYPE_FLOAT);
        }
        if (FloatingPointUtil.instanceOfDouble(obj)) {
            return BdbeNative.sizeof(BdbeType.BDBE_TYPE_DOUBLE);
        }
        if (obj instanceof String) {
            return BdbeNative.sizeofString((String)obj);
        }
        throw new RuntimeException("Illegal attributetype in database");
    }

    public synchronized BdbeDB createDatabase(BdbeSchema schema, String name, int flags, long dbId) throws BdbeException {
        if (name == null) {
            throw new NullPointerException();
        }
        FloatingPointUtil.securityCheckRead(name);
        FloatingPointUtil.securityCheckWrite(name);
        long id = 0L;
        if (schema != null) {
            ((JNIObject)((Object)schema)).checkNotReleased();
            id = ((BdbeSchemaImpl)schema).cObjectID;
        }
        long dbid = BdbeNative.createDatabase(id, name, flags, dbId);
        BdbeDBImpl db = new BdbeDBImpl(dbid, (BdbeSchemaImpl)schema);
        if (schema != null) {
            ((BdbeSchemaImpl)schema).db = db;
        }
        return db;
    }

    public static boolean everyThingReleased(BdbeDB db) {
        return ((BdbeDBImpl)db).unreleased.isEmpty();
    }

    static BirdstepUnknown getBdbeUnknownObject(int interfaceId, long cID, BdbeDBImpl db) {
        if (interfaceId == BirdstepIf.BIRDSTEP_IF_BDBE_CURSOR) {
            return new BdbeCursorImpl(cID, db);
        }
        if (interfaceId == BirdstepIf.BIRDSTEP_IF_BDBE_DB) {
            return db;
        }
        if (interfaceId == BirdstepIf.BIRDSTEP_IF_BDBE_SCHEMA) {
            return new BdbeSchemaImpl(cID);
        }
        throw new RuntimeException("Unsupported interface");
    }

    public static BdbeCursor getCursor(long cID, BdbeDB db) {
        return new BdbeCursorImpl(cID, (BdbeDBImpl)db);
    }

    public static JNIObject getOwner(BdbeDB db) {
        return ((BdbeDBImpl)db).owner;
    }

    public static void privateClose(BdbeDB db) {
        ((BdbeDBImpl)db).privateClose();
    }

    public static void release(BdbeDB db, JNIObject obj) {
        ((BdbeDBImpl)db).release(obj);
    }

    public static void setOwner(BdbeDB db, JNIObject owner) {
        ((BdbeDBImpl)db).owner = owner;
    }

    public void throwBdbeException(int code) throws BdbeException {
        BdbeNative.throwBdbeException(code);
    }

    static {
        try {
            FloatingPointUtil.loadLibrary("bdjapi");
            BdbeNative.checkVersion(BdbeConstants.BDBE_VERSION);
            Reporter.report("bdjapi library loaded");
        }
        catch (Error x) {
            System.out.println("Problem loading bdjapi JNI library");
            throw x;
        }
    }
}

