/*
 * Decompiled with CFR 0.152.
 */
package com.birdstep.bdbe.jni;

import com.birdstep.BirdstepIf;
import com.birdstep.BirdstepUnknown;
import com.birdstep.bdbe.BdbeAttributeValue;
import com.birdstep.bdbe.BdbeClass;
import com.birdstep.bdbe.BdbeCursor;
import com.birdstep.bdbe.BdbeDB;
import com.birdstep.bdbe.BdbeException;
import com.birdstep.bdbe.BdbeIndex;
import com.birdstep.bdbe.BdbeIndexSegment;
import com.birdstep.bdbe.BdbeObject;
import com.birdstep.bdbe.BdbeObjectId;
import com.birdstep.bdbe.BdbeSelection;
import com.birdstep.bdbe.jni.BdbeAttributeValueNative;
import com.birdstep.bdbe.jni.BdbeClassImpl;
import com.birdstep.bdbe.jni.BdbeCursorImpl;
import com.birdstep.bdbe.jni.BdbeDBNative;
import com.birdstep.bdbe.jni.BdbeImpl;
import com.birdstep.bdbe.jni.BdbeIndexImpl;
import com.birdstep.bdbe.jni.BdbeSchemaImpl;
import com.birdstep.bdbe.jni.BdbeSelectionImpl;
import com.birdstep.bdbe.jni.BirdstepUnknownImpl;
import com.birdstep.bdbe.jni.BirdstepUnknownNative;
import com.birdstep.bdbe.jni.FloatingPointUtil;
import com.birdstep.jni.JNIObject;
import com.birdstep.util.ObjectCreationListener;
import com.birdstep.util.WeakEntry;
import java.util.Hashtable;
import java.util.Vector;

class BdbeDBImpl
extends BirdstepUnknownImpl
implements BdbeDB,
ObjectCreationListener {
    BdbeSchemaImpl schema;
    private Hashtable typeMapping;
    int addrefsExcluded = 0;
    boolean origReleased = false;
    JNIObject owner = null;
    boolean schemaAbsorbed = false;
    Vector unreleased = new Vector();

    BdbeDBImpl(long cID) {
        super(cID);
    }

    public synchronized void abortTransaction() throws BdbeException {
        this.checkNotReleased();
        BdbeDBNative.abortTransaction(this.cObjectID);
    }

    public synchronized void beginTransaction(boolean fReadOnly) throws BdbeException {
        this.checkNotReleased();
        BdbeDBNative.beginTransaction(this.cObjectID, fReadOnly);
    }

    public Object clone() {
        throw new RuntimeException("Can't clone database");
    }

    public BdbeCursor createObject(String szLabel, BdbeClass typeClass, BdbeObjectId id) throws BdbeException {
        return this.createObject(szLabel, typeClass, id, null);
    }

    public synchronized BdbeCursor createObject(String szLabel, BdbeClass typeClass, BdbeObjectId id, BdbeAttributeValue[] defaultValues) throws BdbeException {
        long defValues;
        this.checkNotReleased();
        int length = 0;
        if (defaultValues != null) {
            length = defaultValues.length;
        }
        long next = defValues = BdbeAttributeValueNative.allocateAttributeValueArray(length);
        int i = 0;
        while (i < length) {
            BdbeAttributeValueNative.setAttributeValue(defaultValues[i], next, BdbeImpl.sizeof(defaultValues[i].value));
            next = BdbeAttributeValueNative.nextAttributeValueArray(next);
            ++i;
        }
        long dbID = 0L;
        int localOID = 0;
        if (id != null) {
            dbID = id.dbid;
            localOID = id.loid;
        }
        return new BdbeCursorImpl(BdbeDBNative.createObject(this.cObjectID, szLabel, ((BdbeClassImpl)typeClass).cObjectID, dbID, localOID, length, defValues), this);
    }

    public void defineAttribute(BdbeClass typeClass, String szAttributeName, int base, short uAttributeId) throws BdbeException {
        this.getSchema().defineAttribute(typeClass, szAttributeName, base, uAttributeId);
    }

    public void defineAttribute(BdbeClass typeClass, String szAttributeName, int base, short uAttributeId, int flags) throws BdbeException {
        this.getSchema().defineAttribute(typeClass, szAttributeName, base, uAttributeId, flags);
    }

    public void defineAttribute(BdbeClass typeClass, String szAttributeName, int base, short uAttributeId, int flags, Object defaultValue) throws BdbeException {
        Object obj = defaultValue;
        if (defaultValue instanceof BdbeObject) {
            obj = ((BdbeObject)defaultValue).getObjectId();
        }
        this.getSchema().defineAttribute(typeClass, szAttributeName, base, uAttributeId, flags, obj);
    }

    public BdbeClass defineClass(BdbeClass typeParentClass, String szClassName, int classFlags) throws BdbeException {
        return this.getSchema().defineClass(typeParentClass, szClassName, classFlags);
    }

    public BdbeIndex defineIndex(BdbeClass typeClass, String szIndexName, int indexFlags, BdbeIndexSegment[] nde) throws BdbeException {
        return this.getSchema().defineIndex(typeClass, szIndexName, indexFlags, nde);
    }

    public void defineMandatoryAttribute(BdbeClass typeClass, String szAttributeName, int base, short uAttributeId) throws BdbeException {
        this.getSchema().defineMandatoryAttribute(typeClass, szAttributeName, base, uAttributeId);
    }

    public void defineMandatoryAttribute(BdbeClass typeClass, String szAttributeName, int base, short uAttributeId, int flags) throws BdbeException {
        this.getSchema().defineMandatoryAttribute(typeClass, szAttributeName, base, uAttributeId, flags);
    }

    public void defineMandatoryAttribute(BdbeClass typeClass, String szAttributeName, int base, short uAttributeId, int flags, Object defaultValue) throws BdbeException {
        Object obj = defaultValue;
        if (defaultValue instanceof BdbeObject) {
            obj = ((BdbeObject)defaultValue).getObjectId();
        }
        this.getSchema().defineMandatoryAttribute(typeClass, szAttributeName, base, uAttributeId, flags, obj);
    }

    public void defineOptionalAttribute(BdbeClass typeClass, String szAttributeName, int base, short uAttributeId) throws BdbeException {
        this.getSchema().defineOptionalAttribute(typeClass, szAttributeName, base, uAttributeId);
    }

    public void defineOptionalAttribute(BdbeClass typeClass, String szAttributeName, int base, short uAttributeId, int flags) throws BdbeException {
        this.getSchema().defineOptionalAttribute(typeClass, szAttributeName, base, uAttributeId, flags);
    }

    public void defineOptionalAttribute(BdbeClass typeClass, String szAttributeName, int base, short uAttributeId, int flags, Object defaultVaue) throws BdbeException {
        this.getSchema().defineOptionalAttribute(typeClass, szAttributeName, base, uAttributeId, flags, defaultVaue);
    }

    public void dropAttribute(BdbeClass clazz, short id) throws BdbeException {
        this.getSchema().dropAttribute(clazz, id);
    }

    public void dropClass(BdbeClass clazz) throws BdbeException {
        this.getSchema().dropClass(clazz);
    }

    public void dropIndex(BdbeIndex ndx) throws BdbeException {
        this.getSchema().dropIndex(ndx);
    }

    public synchronized void endTransaction() throws BdbeException {
        this.checkNotReleased();
        BdbeDBNative.endTransaction(this.cObjectID);
    }

    public synchronized int getActiveTransactionType() {
        this.checkNotReleased();
        return BdbeDBNative.getActiveTransactionType(this.cObjectID);
    }

    public short getApplicationTypeOfAttribute(BdbeClass clazz, short attrid) throws BdbeException {
        return this.getSchema().getApplicationTypeOfAttribute(clazz, attrid);
    }

    public short getAttribute(BdbeClass typeClass, String szAttributeName) {
        return this.getSchema().getAttribute(typeClass, szAttributeName);
    }

    public int getAttributeFlags(BdbeClass clazz, short attrId) {
        return this.getSchema().getAttributeFlags(clazz, attrId);
    }

    public String getAttributeName(BdbeClass typeClass, short uAttributeID) throws BdbeException {
        return this.getSchema().getAttributeName(typeClass, uAttributeID);
    }

    public int getAttributeType(BdbeClass typeClass, short uAttributeID) {
        return this.getSchema().getAttributeType(typeClass, uAttributeID);
    }

    public BdbeClass getClass(String szClassName) {
        return this.getSchema().getClass(szClassName);
    }

    public int getClassFlags(BdbeClass typeClass) {
        return this.getSchema().getClassFlags(typeClass);
    }

    public String getClassName(BdbeClass type) {
        return this.getSchema().getClassName(type);
    }

    public Object getDefaultValue(BdbeClass clazz, short id) throws BdbeException {
        Class classType;
        Object obj = this.getSchema().getDefaultValue(clazz, id);
        if (obj instanceof BdbeObjectId && this.getTypeMap() != null && (classType = (Class)this.getTypeMap().get(this.getClassName(clazz))) != null) {
            try {
                BdbeObject attrObject;
                String className;
                Class attrType;
                BdbeObject classObject = (BdbeObject)classType.newInstance();
                if (classObject.getTypeMap() != null && (attrType = (Class)classObject.getTypeMap().get(this.getAttributeName(clazz, id))) != null && (className = (attrObject = (BdbeObject)attrType.newInstance()).getClassName()) != null) {
                    obj = this.getObject(this.getClass(className), (BdbeObjectId)obj);
                }
            }
            catch (InstantiationException exc) {
                throw new RuntimeException(exc.getMessage());
            }
            catch (IllegalAccessException exc) {
                throw new RuntimeException(exc.getMessage());
            }
        }
        return obj;
    }

    public short getFirstAttribute(BdbeClass typeClass) {
        return this.getSchema().getFirstAttribute(typeClass);
    }

    public BdbeClass getFirstClass() {
        return this.getSchema().getFirstClass();
    }

    public BdbeIndex getFirstIndex(BdbeClass clazz) {
        return this.getSchema().getFirstIndex(clazz);
    }

    public BdbeIndex getIndex(BdbeClass clazz, String szName) {
        return this.getSchema().getIndex(clazz, szName);
    }

    public BdbeClass getIndexedClass(BdbeIndex ndx) {
        return this.getSchema().getIndexedClass(ndx);
    }

    public int getIndexFlags(BdbeIndex index) {
        return this.getSchema().getIndexFlags(index);
    }

    public String getIndexName(BdbeIndex ndx) {
        return this.getSchema().getIndexName(ndx);
    }

    public BdbeIndexSegment[] getIndexSegments(BdbeIndex ndx) {
        return this.getSchema().getIndexSegments(ndx);
    }

    public synchronized long getInstanceId() throws BdbeException {
        this.checkNotReleased();
        return BdbeDBNative.getInstanceId(this.cObjectID);
    }

    public short getMaxSizeOfAttribute(BdbeClass clazz, short attrid) throws BdbeException {
        return this.getSchema().getMaxSizeOfAttribute(clazz, attrid);
    }

    public short getNextAttribute(BdbeClass typeClass, short uPrevAttributeID) {
        return this.getSchema().getNextAttribute(typeClass, uPrevAttributeID);
    }

    public BdbeClass getNextClass(BdbeClass typePrevious) {
        return this.getSchema().getNextClass(typePrevious);
    }

    public BdbeIndex getNextIndex(BdbeIndex ndxPrevious) {
        return this.getSchema().getNextIndex(ndxPrevious);
    }

    public int getNumberOfAttributes(BdbeClass typeClass) {
        return this.getSchema().getNumberOfAttributes(typeClass);
    }

    public int getNumberOfIndexSegments(BdbeIndex ndx) {
        return this.getSchema().getNumberOfIndexSegments(ndx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BdbeObject getObject(BdbeClass clazz, BdbeObjectId id) throws BdbeException {
        BdbeCursor cursor = this.lookupObject(clazz, id);
        if (cursor != null) {
            BdbeObject bdbeObject;
            try {
                bdbeObject = this.getObject(cursor);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                cursor.release();
                throw throwable;
            }
            cursor.release();
            return bdbeObject;
        }
        return null;
    }

    BdbeObject getObject(BdbeCursor cursor) throws BdbeException {
        Class clazz;
        if (this.getTypeMap() != null && (clazz = (Class)this.getTypeMap().get(this.getClassName(cursor.getBdbeClass()))) != null) {
            try {
                BdbeObject toReturn = (BdbeObject)clazz.newInstance();
                toReturn.read(cursor);
                return toReturn;
            }
            catch (InstantiationException exc) {
                throw new RuntimeException(exc.getMessage());
            }
            catch (IllegalAccessException exc) {
                throw new RuntimeException(exc.getMessage());
            }
        }
        return null;
    }

    BdbeObject getObject(BdbeCursor cursor, String attrName, BdbeObjectId id) throws BdbeException {
        Class attrType;
        BdbeObject obj = this.getObject(cursor);
        if (obj != null && (attrType = FloatingPointUtil.getClass(obj.getClass(), attrName)) != null) {
            try {
                BdbeObject attrObject = (BdbeObject)attrType.newInstance();
                if (attrObject != null) {
                    return this.getObject(this.getClass(attrObject.getClassName()), id);
                }
            }
            catch (InstantiationException exc) {
                throw new RuntimeException(exc.getMessage());
            }
            catch (IllegalAccessException exc) {
                throw new RuntimeException(exc.getMessage());
            }
        }
        return null;
    }

    BdbeObject getObject(BdbeCursor cursor, short attrId, BdbeObjectId id) throws BdbeException {
        String attrName = this.getAttributeName(cursor.getBdbeClass(), attrId);
        return this.getObject(cursor, attrName, id);
    }

    public BdbeClass getParentClass(BdbeClass typeClass) {
        return this.getSchema().getParentClass(typeClass);
    }

    private synchronized BdbeSchemaImpl getSchema() {
        if (this.schema == null) {
            this.checkNotReleased();
            try {
                this.schema = new BdbeSchemaImpl(BirdstepUnknownNative.queryInterface(this.cObjectID, BirdstepIf.BIRDSTEP_IF_BDBE_SCHEMA));
                this.schema.released = true;
                this.schema.nativeRelease();
            }
            catch (BdbeException exc) {
                throw new RuntimeException(exc.getMessage());
            }
        }
        return this.schema;
    }

    public int getVersion() {
        return this.getSchema().getVersion();
    }

    public synchronized BdbeCursor lookupChangedObjects() throws BdbeException {
        this.checkNotReleased();
        return new BdbeCursorImpl(BdbeDBNative.lookupChangedObjects(this.cObjectID), this);
    }

    public synchronized BdbeCursor lookupObject(BdbeClass clazz, BdbeObjectId pOid) throws BdbeException {
        this.checkNotReleased();
        long id = BdbeDBNative.lookupObject(this.cObjectID, ((BdbeClassImpl)clazz).cObjectID, pOid.dbid, pOid.loid);
        if (id == 0L) {
            return null;
        }
        return new BdbeCursorImpl(id, this);
    }

    public synchronized BirdstepUnknown lookupObjectsByClass(String szPath, BdbeClass type, int mode, int uInterfaceID) throws BdbeException {
        this.checkNotReleased();
        return BdbeImpl.getBdbeUnknownObject(uInterfaceID, BdbeDBNative.lookupObjectsByClass(this.cObjectID, szPath, ((BdbeClassImpl)type).cObjectID, mode, uInterfaceID), this);
    }

    public synchronized BirdstepUnknown lookupObjectsByIndex(String szPath, BdbeIndex ndx, int uInterfaceID) throws BdbeException {
        return BdbeImpl.getBdbeUnknownObject(uInterfaceID, BdbeDBNative.lookupObjectsByIndex(this.cObjectID, szPath, ((BdbeIndexImpl)ndx).cObjectID, uInterfaceID), this);
    }

    public BirdstepUnknown lookupObjectsByIndex(String szPath, BdbeIndex ndx, int op, Object[] data, int uInterfaceID) throws BdbeException {
        return this.lookupObjectsByIndex(szPath, ndx, op, data, uInterfaceID, null);
    }

    public synchronized BirdstepUnknown lookupObjectsByIndex(String szPath, BdbeIndex ndx, int op, Object[] data, int uInterfaceID, int[] flags) throws BdbeException {
        this.checkNotReleased();
        long dataPtr = BdbeImpl.getVoidVoidArray(data);
        long dataSizes = BdbeImpl.getArrayLengths(data);
        int length = 0;
        if (data != null) {
            length = data.length;
        }
        long flagsPtr = BdbeImpl.getUnsigned32Array(flags);
        return BdbeImpl.getBdbeUnknownObject(uInterfaceID, BdbeDBNative.lookupObjectsByIndex(this.cObjectID, szPath, ((BdbeIndexImpl)ndx).cObjectID, length, op, dataPtr, dataSizes, uInterfaceID, flagsPtr), this);
    }

    public BirdstepUnknown lookupObjectsByIndex(String szPath, BdbeIndex ndx, int opLower, Object[] lowerData, int opUpper, Object[] upperData, int uInterfaceID) throws BdbeException {
        return this.lookupObjectsByIndex(szPath, ndx, opLower, lowerData, opUpper, upperData, uInterfaceID, null);
    }

    public synchronized BirdstepUnknown lookupObjectsByIndex(String szPath, BdbeIndex ndx, int opLower, Object[] lowerData, int opUpper, Object[] upperData, int uInterfaceID, int[] flags) throws BdbeException {
        this.checkNotReleased();
        int length = 0;
        if (lowerData != null) {
            length = lowerData.length;
        }
        if (upperData == null) {
            length = 0;
        } else if (upperData.length < length) {
            length = upperData.length;
        }
        long lowerDataPtr = BdbeImpl.getVoidVoidArray(lowerData);
        long upperDataPtr = BdbeImpl.getVoidVoidArray(upperData);
        long lowerSizes = BdbeImpl.getArrayLengths(lowerData);
        long upperSizes = BdbeImpl.getArrayLengths(upperData);
        long flagsPtr = BdbeImpl.getUnsigned32Array(flags);
        return BdbeImpl.getBdbeUnknownObject(uInterfaceID, BdbeDBNative.lookupObjectsByIndex(this.cObjectID, szPath, ((BdbeIndexImpl)ndx).cObjectID, length, opLower, lowerDataPtr, lowerSizes, opUpper, upperDataPtr, upperSizes, uInterfaceID, flagsPtr), this);
    }

    public synchronized void moveObject(BdbeCursor pcuTarget, int pos, BdbeCursor pcuSource) throws BdbeException {
        this.checkNotReleased();
        ((JNIObject)((Object)pcuSource)).checkNotReleased();
        long targetid = 0L;
        if (pcuTarget != null) {
            ((JNIObject)((Object)pcuTarget)).checkNotReleased();
            targetid = ((BdbeCursorImpl)pcuTarget).cObjectID;
        }
        BdbeDBNative.moveObject(this.cObjectID, targetid, pos, ((BdbeCursorImpl)pcuSource).cObjectID);
    }

    public synchronized void release() {
        if (this.cObjectID == 0L) {
            throw new RuntimeException("Attempted to release object that has already been deleted");
        }
        if (this.addrefsExcluded > 0) {
            --this.addrefsExcluded;
        } else if (this.schemaAbsorbed) {
            this.nativeRelease();
            this.schema.released = true;
            this.schemaAbsorbed = false;
        } else if (!this.origReleased) {
            this.origReleased = true;
            if (this.unreleased.isEmpty()) {
                this.close();
            }
        } else {
            throw new RuntimeException("Attempted to release this object one too many times");
        }
    }

    public void setVersion(int version) throws BdbeException {
        this.getSchema().setVersion(version);
    }

    public synchronized void upgradeTransaction() throws BdbeException {
        this.checkNotReleased();
        BdbeDBNative.upgradeTransaction(this.cObjectID);
    }

    BdbeDBImpl(long cID, BdbeSchemaImpl sch) throws BdbeException {
        this(cID);
        if (sch != null) {
            this.schemaAbsorbed = true;
            this.schema = sch;
        }
    }

    public synchronized void close() {
        if (this.cObjectID == 0L) {
            return;
        }
        if (this.owner == null) {
            this.privateClose();
        }
    }

    public synchronized void closeIfEverythingReleased() {
        if (this.origReleased && !this.schemaAbsorbed && this.unreleased.isEmpty()) {
            this.close();
        }
    }

    public synchronized BdbeSelection createEmptySelection() {
        this.checkNotReleased();
        long cID = BdbeDBNative.createEmptySelection(this.cObjectID);
        if (cID == 0L) {
            return null;
        }
        return new BdbeSelectionImpl(cID, this);
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public Hashtable getTypeMap() {
        return this.typeMapping;
    }

    public synchronized void objectCreated(Object created) {
        WeakEntry entry;
        ((JNIObject)created).weakentry = entry = new WeakEntry(created);
        this.unreleased.addElement(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void privateClose() {
        try {
            int size = this.unreleased.size();
            WeakEntry[] entries = new WeakEntry[size];
            int i = 0;
            while (i < size) {
                entries[i] = (WeakEntry)this.unreleased.elementAt(i);
                ++i;
            }
            int i2 = 0;
            while (i2 < entries.length) {
                JNIObject obj = (JNIObject)entries[i2].get();
                if (obj != null) {
                    this.release(obj);
                }
                ++i2;
            }
            if (this.schemaAbsorbed) {
                try {
                    this.nativeRelease();
                    Object var7_6 = null;
                    this.schema.released = true;
                    this.schemaAbsorbed = false;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    this.schema.released = true;
                    this.schemaAbsorbed = false;
                    throw throwable;
                }
            }
            if (this.unreleased.isEmpty()) {
                try {
                    int refcount = this.nativeRelease();
                    if (refcount > 0) {
                        throw new RuntimeException("The database could not be closed due to BdbeDB internal memory leak");
                    }
                    Object var9_10 = null;
                    this.cObjectID = 0L;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    this.cObjectID = 0L;
                    throw throwable;
                }
            }
            Object var11_13 = null;
            this.addrefsExcluded = 0;
            if (this.schema != null) {
                this.schema.cObjectID = 0L;
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            this.addrefsExcluded = 0;
            if (this.schema != null) {
                this.schema.cObjectID = 0L;
            }
            throw throwable;
        }
    }

    public synchronized void release(JNIObject obj) {
        this.unreleased.removeElement(obj.weakentry);
        obj.weakentry = null;
        if (obj.cObjectID == 0L) {
            throw new RuntimeException("Attempted to release object that has already been deleted");
        }
        int refcount = obj.nativeRelease();
        if (refcount != 0) {
            // empty if block
        }
        obj.cObjectID = 0L;
    }

    public void setTypeMap(Hashtable map) {
        this.typeMapping = map;
    }
}

