/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.common.standard.util;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.xtools.common.standard.resource.ResourceLink;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ProductInformation {
    private static final boolean PRE_CHECK = Precondition.isEnabled((Class)(class$com$softwareag$xtools$common$standard$util$ProductInformation == null ? (class$com$softwareag$xtools$common$standard$util$ProductInformation = ProductInformation.class$("com.softwareag.xtools.common.standard.util.ProductInformation")) : class$com$softwareag$xtools$common$standard$util$ProductInformation));
    private static final boolean POST_CHECK = Postcondition.isEnabled((Class)(class$com$softwareag$xtools$common$standard$util$ProductInformation == null ? (class$com$softwareag$xtools$common$standard$util$ProductInformation = ProductInformation.class$("com.softwareag.xtools.common.standard.util.ProductInformation")) : class$com$softwareag$xtools$common$standard$util$ProductInformation));
    private static Logger logger = LoggerFactory.getLogger((String)(class$com$softwareag$xtools$common$standard$util$ProductInformation == null ? (class$com$softwareag$xtools$common$standard$util$ProductInformation = ProductInformation.class$("com.softwareag.xtools.common.standard.util.ProductInformation")) : class$com$softwareag$xtools$common$standard$util$ProductInformation).getName());
    protected static final String PRODUCTJARFILE_PROPERTY = "com.softwareag.xtools.productjarfile";
    protected Attributes manifestAttributes = new Attributes();
    protected Map componentNamesAndVersions = new HashMap();
    static /* synthetic */ Class class$com$softwareag$xtools$common$standard$util$ProductInformation;

    public static void main(String[] stringArray) throws IllegalArgumentException, ClassNotFoundException, FileNotFoundException, IOException {
        if (stringArray != null && stringArray.length > 1) {
            throw new IllegalArgumentException(ResourceLink.TEXT.getString("MAINARGS"));
        }
        String string = null;
        if (stringArray != null && stringArray.length == 1) {
            string = stringArray[0];
        }
        ProductInformation productInformation = string == null ? new ProductInformation(ClassLoader.getSystemClassLoader().loadClass("com.softwareag.xtools.common.standard.util.ProductInformation")) : new ProductInformation(string);
        System.err.println(productInformation.getProductInformationString(null));
    }

    public ProductInformation() throws FileNotFoundException, IOException {
        String string = System.getProperty(PRODUCTJARFILE_PROPERTY);
        if (string == null) {
            this.readFromJarFile(this.getJarFile(this.getClass()));
        } else {
            this.readFromJarFile(this.getJarFile(string));
        }
    }

    public ProductInformation(String string) throws FileNotFoundException, IOException {
        if (PRE_CHECK) {
            Precondition.check((String)"jarName is not null", (string != null ? 1 : 0) != 0);
        }
        this.readFromJarFile(this.getJarFile(string));
    }

    public ProductInformation(Class clazz) throws FileNotFoundException, IOException {
        JarFile jarFile;
        if (PRE_CHECK) {
            Precondition.check((String)"classInJar is not null", (clazz != null ? 1 : 0) != 0);
        }
        if ((jarFile = this.getJarFile(clazz)) != null) {
            this.readFromJarFile(jarFile);
        }
    }

    protected JarFile getJarFile(String string) throws FileNotFoundException, IOException {
        URL uRL;
        if (PRE_CHECK) {
            Precondition.check((String)"jarName is not null", (string != null ? 1 : 0) != 0);
        }
        if ((uRL = ClassLoader.getSystemClassLoader().getResource(string)) == null) {
            throw new FileNotFoundException(string);
        }
        JarFile jarFile = new JarFile(uRL.getFile());
        return jarFile;
    }

    protected JarFile getJarFile(Class clazz) throws FileNotFoundException, IOException {
        if (PRE_CHECK) {
            Precondition.check((String)"classInJar is not null", (clazz != null ? 1 : 0) != 0);
        }
        JarFile jarFile = null;
        String string = clazz.getName().replace('.', '/') + ".class";
        URL uRL = this.getClass().getClassLoader().getResource(string);
        if (uRL == null) {
            throw new FileNotFoundException(string);
        }
        int n = uRL.toExternalForm().indexOf(33);
        if (n != -1) {
            String string2 = uRL.toExternalForm().substring(4, n);
            URL uRL2 = new URL(string2);
            jarFile = new JarFile(uRL2.getFile());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("ProductInformation", "getJarFile(class)", "class, jar-file:", new Object[]{clazz.getName(), jarFile.getName()});
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("ProductInformation", "getJarFile(class)", "The class is not in a jar-file!", new Object[]{clazz.getName()});
        }
        return jarFile;
    }

    protected void readFromJarFile(JarFile jarFile) throws IOException {
        int n;
        if (PRE_CHECK) {
            Precondition.check((String)"jarFile is not null", (jarFile != null ? 1 : 0) != 0);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("ProductInformation", "readFromJarFile", "jar file:", new Object[]{jarFile.getName()});
        }
        String string = jarFile.getName();
        this.manifestAttributes = jarFile.getManifest().getMainAttributes();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("ProductInformation", "readFromJarFile", "Manifest entries read", new Object[]{this.manifestAttributes.entrySet()});
        }
        int n2 = (n = string.lastIndexOf(System.getProperty("file.separator"))) == -1 ? 0 : n + 1;
        String string2 = string.substring(n2, string.indexOf(ResourceLink.TEXT.getString("DOTJAR")));
        String string3 = ResourceLink.TEXT.getString("METAINF") + "/" + ResourceLink.TEXT.getString("BUILDSEQUENCEPREFIX") + string2 + ResourceLink.TEXT.getString("BUILDSEQUENCESUFFIX");
        ZipEntry zipEntry = jarFile.getEntry(string3);
        if (zipEntry != null) {
            this.readComponentInfos(jarFile.getInputStream(zipEntry));
        }
    }

    protected void readComponentInfos(InputStream inputStream) {
        try {
            InputSource inputSource = new InputSource(new InputStreamReader(inputStream, "UTF-8"));
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            String string = ResourceLink.TEXT.getString("VERSIONATTRIBUTE");
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (node.getNodeType() == 1) {
                    Element element2 = (Element)node;
                    if (!element2.getAttribute(string).equals("")) {
                        String string2 = element2.getAttribute(string);
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("ProductInformation", "readComponentInfos", "component version read:", new Object[]{string2});
                        }
                        this.storeNameAndVersion(string2);
                    } else if (logger.isLoggable(Level.FINE)) {
                        logger.fine("ProductInformation", "readComponentInfos", "buildSequence is not valid, could not read a version attribute");
                    }
                }
                ++n;
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("ProductInformation", "readComponentInfos", "exception occured, clear component infos", new Object[]{parserConfigurationException.toString()});
            }
            this.componentNamesAndVersions.clear();
        }
        catch (SAXException sAXException) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("ProductInformation", "readComponentInfos", "exception occured, clear component infos", new Object[]{sAXException.toString()});
            }
            this.componentNamesAndVersions.clear();
        }
        catch (IOException iOException) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("ProductInformation", "readComponentInfos", "exception occured, clear component infos", new Object[]{iOException.toString()});
            }
            this.componentNamesAndVersions.clear();
        }
    }

    protected void storeNameAndVersion(String string) {
        if (string == null) {
            return;
        }
        String string2 = "";
        String string3 = "";
        String string4 = ResourceLink.TEXT.getString("VERSIONDELIMITER");
        int n = string.indexOf(string4);
        if (n == -1) {
            string2 = string;
        } else {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        string3 = string3.replace(string4.charAt(0), ResourceLink.TEXT.getString("VERSIONDELIMITERNEW").charAt(0));
        this.componentNamesAndVersions.put(string2, string3);
    }

    public Map getComponentNamesAndVersions() {
        return this.componentNamesAndVersions;
    }

    public String getJarFileName() {
        return this.manifestAttributes.getValue(new Attributes.Name(ResourceLink.TEXT.getString("JARNAME")));
    }

    public String getSpecificationTitle() {
        return this.manifestAttributes.getValue(new Attributes.Name(ResourceLink.TEXT.getString("SPECTITLE")));
    }

    public String getSpecificationVersion() {
        return this.manifestAttributes.getValue(new Attributes.Name(ResourceLink.TEXT.getString("SPECVERSION")));
    }

    public String getSpecificationVendor() {
        return this.manifestAttributes.getValue(new Attributes.Name(ResourceLink.TEXT.getString("SPECVENDOR")));
    }

    public String getImplementationTitle() {
        return this.manifestAttributes.getValue(new Attributes.Name(ResourceLink.TEXT.getString("IMPLTITLE")));
    }

    public String getImplementationVersion() {
        return this.manifestAttributes.getValue(new Attributes.Name(ResourceLink.TEXT.getString("IMPLVERSION")));
    }

    public String getImplementationVendor() {
        return this.manifestAttributes.getValue(new Attributes.Name(ResourceLink.TEXT.getString("IMPLVENDOR")));
    }

    public String getBuildTime() {
        return this.manifestAttributes.getValue(new Attributes.Name(ResourceLink.TEXT.getString("BUILDTIME")));
    }

    public String getBuildSequenceId() {
        return this.manifestAttributes.getValue(new Attributes.Name(ResourceLink.TEXT.getString("BUILDSEQUENCEID")));
    }

    public String getBuildName() {
        return this.manifestAttributes.getValue(new Attributes.Name(ResourceLink.TEXT.getString("BUILDNAME")));
    }

    public String getBuildRoot() {
        return this.manifestAttributes.getValue(new Attributes.Name(ResourceLink.TEXT.getString("BUILDROOT")));
    }

    public String getProductInformationString(String string) {
        if (string == null) {
            string = this.getSpecificationTitle();
        }
        return MessageFormat.format(ResourceLink.TEXT.getString("PRINTLINE"), string, this.getSpecificationVersion(), this.getBuildTimeYear(this.getBuildTime()), this.getSpecificationVendor());
    }

    public String getBuildTimeYear(String string) {
        int n;
        int n2;
        int n3;
        String string2 = null;
        if (string != null && (n3 = string.indexOf(32)) != -1 && (n2 = string.indexOf(32, n3 + 1)) != -1 && (n = string.indexOf(32, n2 + 1)) != -1) {
            string2 = string.substring(n2 + 1, n);
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

