/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.common.standard.util;

import com.softwareag.xtools.common.standard.util.TimeoutException;
import java.io.Serializable;
import java.util.Vector;

public class Condition
implements Serializable {
    static int counter = 0;
    boolean state = false;
    transient Vector waitingThreads = null;
    String name = null;

    public Condition(String string) {
        this.name = string;
    }

    public Condition() {
        this("Condition" + Integer.toString(counter++));
    }

    final Vector getWaitingThreads() {
        if (this.waitingThreads == null) {
            this.waitingThreads = new Vector();
        }
        return this.waitingThreads;
    }

    public final boolean isSet() {
        return this.state;
    }

    public final synchronized void set() {
        this.state = true;
        this.notifyAll();
    }

    public final synchronized void clear() {
        this.state = false;
    }

    public final synchronized long waitFor(long l) throws InterruptedException, TimeoutException {
        long l2 = l;
        long l3 = System.currentTimeMillis();
        long l4 = l3 + l;
        Vector vector = this.getWaitingThreads();
        vector.addElement(Thread.currentThread());
        try {
            while (!this.isSet()) {
                this.wait(l2);
                l3 = System.currentTimeMillis();
                if (l3 >= l4) {
                    vector.removeElement(Thread.currentThread());
                    throw new TimeoutException("Waited for " + l + " milliseconds");
                }
                l2 = l4 - l3;
            }
        }
        catch (InterruptedException interruptedException) {
            vector.removeElement(Thread.currentThread());
            interruptedException.fillInStackTrace();
            throw interruptedException;
        }
        catch (Error error) {
            vector.removeElement(Thread.currentThread());
            error.fillInStackTrace();
            throw error;
        }
        vector.removeElement(Thread.currentThread());
        return l - l2;
    }

    public final synchronized void waitFor() throws InterruptedException {
        Vector vector = this.getWaitingThreads();
        vector.addElement(Thread.currentThread());
        try {
            while (!this.isSet()) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            vector.removeElement(Thread.currentThread());
            interruptedException.fillInStackTrace();
            throw interruptedException;
        }
        catch (Error error) {
            vector.removeElement(Thread.currentThread());
            error.fillInStackTrace();
            throw error;
        }
        vector.removeElement(Thread.currentThread());
    }

    public final synchronized void waitForAndClear(long l) throws InterruptedException, TimeoutException {
        this.waitFor(l);
        this.clear();
    }

    public final synchronized void waitForAndClear() throws InterruptedException {
        this.waitFor();
        this.clear();
    }

    public final synchronized boolean isWaiting(Thread thread) {
        return this.getWaitingThreads().contains(thread);
    }

    public final synchronized boolean interruptIfIsWaiting(Thread thread) {
        boolean bl = this.isWaiting(thread);
        if (bl) {
            thread.interrupt();
        }
        return bl;
    }

    public final synchronized boolean testAndSet() {
        boolean bl = this.isSet();
        this.set();
        return bl;
    }

    public final synchronized boolean testAndClear() {
        boolean bl = this.isSet();
        this.clear();
        return bl;
    }

    public String toString() {
        return "Condition variable: " + this.name + ", state: " + this.state;
    }
}

