/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.common.standard.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class WaitCursorEventQueue
extends EventQueue {
    protected Timer timer = new Timer(true);
    protected long delay;
    protected Map parentMap = new HashMap();
    protected Map timerTaskMap = new HashMap();

    public WaitCursorEventQueue(long l) {
        this.delay = l;
    }

    protected void dispatchEvent(AWTEvent aWTEvent) {
        this.setWaitCursorEnabled(true, aWTEvent);
        try {
            super.dispatchEvent(aWTEvent);
            Object var3_2 = null;
            this.setWaitCursorEnabled(false, aWTEvent);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.setWaitCursorEnabled(false, aWTEvent);
            throw throwable;
        }
    }

    public synchronized void setWaitCursorEnabled(boolean bl, AWTEvent aWTEvent) {
        List list = this.getWindows(aWTEvent.getSource());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Set<AWTEvent> set;
            Component component = (Component)iterator.next();
            if (component == null) continue;
            if (bl) {
                set = (HashSet<AWTEvent>)this.parentMap.get(component);
                if (set != null) {
                    set.add(aWTEvent);
                    continue;
                }
                set = new HashSet<AWTEvent>();
                set.add(aWTEvent);
                this.parentMap.put(component, set);
                this.startTimer(component);
                continue;
            }
            set = (Set)this.parentMap.get(component);
            if (set == null) continue;
            set.remove(aWTEvent);
            if (!set.isEmpty()) continue;
            this.parentMap.remove(component);
            this.stopTimer(component);
        }
    }

    protected synchronized void startTimer(Component component) {
        TimerTask timerTask = (TimerTask)this.timerTaskMap.get(component);
        if (timerTask == null) {
            timerTask = new WaitCursorTask(component);
            this.timerTaskMap.put(component, timerTask);
            this.timer.schedule(timerTask, this.delay);
        }
    }

    protected synchronized void stopTimer(Component component) {
        TimerTask timerTask = (TimerTask)this.timerTaskMap.remove(component);
        if (timerTask != null) {
            timerTask.cancel();
        }
    }

    protected List getWindows(Object object) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        Component component = this.getTopLevelAncestor(object);
        if (component != null) {
            arrayList.add(component);
            if (component instanceof Window) {
                Window window = ((Window)component).getOwner();
                while (window != null) {
                    arrayList.add(window);
                    window = window.getOwner();
                }
            }
        }
        return arrayList;
    }

    protected Component getTopLevelAncestor(Object object) {
        MenuContainer menuContainer;
        Component component = null;
        if (object instanceof Component) {
            component = SwingUtilities.getRoot((Component)object);
        } else if (object instanceof MenuComponent && (menuContainer = ((MenuComponent)object).getParent()) instanceof Component) {
            component = SwingUtilities.getRoot((Component)menuContainer);
        }
        return component;
    }

    public static void main(String[] stringArray) {
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(new WaitCursorEventQueue(500L));
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().setLayout(new FlowLayout());
        final JDialog jDialog = new JDialog(jFrame);
        jDialog.getContentPane().setLayout(new FlowLayout());
        JButton jButton = new JButton("action");
        jDialog.getContentPane().add(jButton);
        ((Component)jDialog).setSize(200, 200);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Thread.currentThread();
                    Thread.sleep(2000L);
                    jDialog.hide();
                    Thread.currentThread();
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        JButton jButton2 = new JButton("open dialog");
        jFrame.getContentPane().add(jButton2);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.show();
            }
        });
        ((Component)jFrame).setSize(300, 300);
        ((Component)jFrame).setVisible(true);
    }

    public static class WaitCursorTask
    extends TimerTask {
        protected Component component = null;
        protected Cursor originalCursor = null;

        public WaitCursorTask(Component component) {
            this.component = component;
        }

        public boolean cancel() {
            boolean bl = super.cancel();
            if (!bl && this.component != null) {
                this.component.setCursor(this.originalCursor);
            }
            return bl;
        }

        public synchronized void run() {
            if (this.component != null) {
                this.originalCursor = this.component.getCursor();
                this.component.setCursor(Cursor.getPredefinedCursor(3));
            }
        }
    }
}

