/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.common.standard.awt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.JFrame;

public class AWTUtility {
    protected static Window[] helperWindowArray = new Window[2];
    protected static final int X_DISPLACEMENT = 20;
    protected static final int Y_DISPLACEMENT = 20;
    protected static final int WIDTH_VISIBLE = 1;
    protected static final int HEIGHT_VISIBLE = 2;
    protected static final int WIDTH_AND_HEIGHT_VISIBLE = 3;

    protected static int getXDisplacement() {
        return 20;
    }

    protected static int getYDisplacement() {
        return 20;
    }

    protected static int checkCompletelyVisibleOnScreen(Window window, Point point, Dimension dimension) {
        int n = 0;
        Dimension dimension2 = window.getSize();
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        if (point.x + dimension.width + dimension2.width < dimension3.width) {
            n |= 1;
        }
        if (point.y + dimension.height + dimension2.height < dimension3.height) {
            n |= 2;
        }
        return n;
    }

    protected static Dimension cascade(Window window, Window window2, Dimension dimension, List list) {
        Dimension dimension2 = new Dimension(dimension);
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension4 = window2.getSize();
        boolean bl = false;
        Point point = new Point(window.getLocation());
        Point point2 = new Point(point);
        point2.x += dimension2.width;
        point2.y += dimension2.height;
        int n = AWTUtility.checkCompletelyVisibleOnScreen(window2, point, dimension2);
        while (!bl && (n != 3 || list.contains(point2))) {
            if (dimension2.width == dimension.width && dimension2.height == dimension.height) {
                dimension2.width = -dimension.width;
                dimension2.height = -dimension.height;
            } else if (dimension2.width == -dimension.width && dimension2.height == -dimension.height) {
                dimension2.width = -dimension.width;
                dimension2.height = dimension.height;
            } else if (dimension2.width == -dimension.width && dimension2.height == dimension.height) {
                dimension2.width = dimension.width;
                dimension2.height = -dimension.height;
            } else {
                dimension2.width = dimension.width;
                dimension2.height = dimension.height;
                bl = true;
            }
            point2.x = point.x + dimension2.width;
            point2.y = point.y + dimension2.height;
            n = AWTUtility.checkCompletelyVisibleOnScreen(window2, point, dimension2);
        }
        if (n != 3 || list.contains(point2)) {
            int n2;
            n = AWTUtility.checkCompletelyVisibleOnScreen(window2, point, dimension);
            if ((n & 1) == 0) {
                n2 = dimension4.width - (dimension3.width - (point.x + dimension.width));
                dimension2.width = n2 <= point.x + dimension.width ? -n2 : -point.x;
            }
            if ((n & 2) == 0) {
                n2 = dimension4.height - (dimension3.height - (point.y + dimension.height));
                dimension2.height = n2 <= point.y + dimension.height ? -n2 : -point.y;
            }
        }
        point.x += dimension2.width;
        point.y += dimension2.height;
        ((Component)window2).setLocation(point);
        list.add(point);
        dimension2.width = dimension2.width > 0 ? (dimension.width > 0 ? dimension.width : -dimension.width) : (dimension.width < 0 ? dimension.width : -dimension.width);
        dimension2.height = dimension2.height > 0 ? (dimension.height > 0 ? dimension.height : -dimension.height) : (dimension.height < 0 ? dimension.height : -dimension.height);
        return dimension2;
    }

    public static void cascade(Window[] windowArray) {
        if (windowArray != null && windowArray.length > 1) {
            Dimension dimension = new Dimension(AWTUtility.getXDisplacement(), AWTUtility.getYDisplacement());
            ArrayList arrayList = new ArrayList();
            int n = 0;
            while (n < windowArray.length - 1) {
                dimension = AWTUtility.cascade(windowArray[n], windowArray[n + 1], dimension, arrayList);
                ++n;
            }
        }
    }

    public static synchronized void cascade(Window window, Window window2) {
        AWTUtility.helperWindowArray[0] = window;
        AWTUtility.helperWindowArray[1] = window2;
        AWTUtility.cascade(helperWindowArray);
    }

    public static void centerOnScreen(Window window) {
        if (window != null) {
            Dimension dimension = window.getSize();
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (dimension2.width - dimension.width) / 2;
            int n2 = (dimension2.height - dimension.height) / 2;
            ((Component)window).setLocation(n, n2);
        }
    }

    public static void center(Window window, Component component) {
        int n;
        int n2;
        Dimension dimension = window.getToolkit().getScreenSize();
        Dimension dimension2 = window.getSize();
        boolean bl = false;
        if (dimension2.width > dimension.width || dimension2.height > dimension.height) {
            bl = true;
            dimension2 = new Dimension(Math.min(dimension2.width, dimension.width), Math.min(dimension2.height, dimension.height));
        }
        if (component != null && component.isVisible()) {
            Point point = component.getLocation();
            Dimension dimension3 = component.getSize();
            n2 = point.x + (dimension3.width - dimension2.width) / 2;
            n = point.y + (dimension3.height - dimension2.height) / 2;
        } else {
            n2 = (dimension.width - dimension2.width) / 2;
            n = (dimension.height - dimension2.height) / 2;
        }
        n2 = Math.min(n2, dimension.width - dimension2.width);
        n = Math.min(n, dimension.height - dimension2.height);
        n2 = Math.max(n2, 0);
        n = Math.max(n, 0);
        if (bl) {
            ((Component)window).setBounds(n2, n, dimension2.width, dimension2.height);
        } else {
            ((Component)window).setLocation(n2, n);
        }
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("Centered Frame");
        ((Component)frame).setSize(300, 200);
        AWTUtility.centerOnScreen(frame);
        ((Component)frame).setVisible(true);
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ((Component)frame).setVisible(false);
        Window[] windowArray = new Window[30];
        Random random = new Random();
        int n = 0;
        while (n < windowArray.length) {
            windowArray[n] = new JFrame(Integer.toString(n));
            ((Component)windowArray[n]).setSize(random.nextInt(500), random.nextInt(400));
            ((JFrame)windowArray[n]).setDefaultCloseOperation(1);
            ((Component)windowArray[n]).setVisible(true);
            ++n;
        }
        AWTUtility.centerOnScreen(windowArray[0]);
        AWTUtility.cascade(windowArray);
    }
}

