/*
 * Decompiled with CFR 0.152.
 */
package com.birdstep.bdbe.xml.sax.jni;

import com.birdstep.bdbe.xml.jni.BirdstepUnknownImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class ContentHandlerImpl
extends BirdstepUnknownImpl
implements ContentHandler {
    protected ContentHandlerImpl(long cID) {
        super(cID);
    }

    private static native void addAttrToArray(long var0, String var2, String var3, String var4, String var5, String var6);

    private static native long allocateAttrArray();

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.checkNotReleased();
        if (ch == null) {
            throw new NullPointerException();
        }
        String s = new String(ch);
        ContentHandlerImpl.characters(this.cObjectID, s, start, length);
    }

    private static native void characters(long var0, String var2, int var3, int var4) throws SAXException;

    public void endDocument() throws SAXException {
        this.checkNotReleased();
        ContentHandlerImpl.endDocument(this.cObjectID);
    }

    private static native void endDocument(long var0) throws SAXException;

    private static native void endElement(long var0, String var2, String var3, String var4) throws SAXException;

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.checkNotReleased();
        if (uri == null || localName == null || qName == null) {
            throw new NullPointerException();
        }
        ContentHandlerImpl.endElement(this.cObjectID, uri, localName, qName);
    }

    private static native void endPrefixMapping(long var0, String var2) throws SAXException;

    public void endPrefixMapping(String prefix) throws SAXException {
        this.checkNotReleased();
        if (prefix == null) {
            throw new NullPointerException();
        }
        ContentHandlerImpl.endPrefixMapping(this.cObjectID, prefix);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.checkNotReleased();
        if (ch == null) {
            throw new NullPointerException();
        }
        String s = new String(ch);
        ContentHandlerImpl.ignorableWhitespace(this.cObjectID, s, start, length);
    }

    private static native void ignorableWhitespace(long var0, String var2, int var3, int var4) throws SAXException;

    private static native void processingInstruction(long var0, String var2, String var3) throws SAXException;

    public void processingInstruction(String target, String data) throws SAXException {
        this.checkNotReleased();
        if (target == null || data == null) {
            throw new NullPointerException();
        }
        ContentHandlerImpl.processingInstruction(this.cObjectID, target, data);
    }

    public void release() {
    }

    public void setDocumentLocator(Locator loc) {
    }

    private static native void skippedEntity(long var0, String var2) throws SAXException;

    public void skippedEntity(String name) throws SAXException {
        this.checkNotReleased();
        if (name == null) {
            throw new NullPointerException();
        }
        ContentHandlerImpl.skippedEntity(this.cObjectID, name);
    }

    public void startDocument() throws SAXException {
        this.checkNotReleased();
        ContentHandlerImpl.startDocument(this.cObjectID);
    }

    private static native void startDocument(long var0) throws SAXException;

    private static native void startElement(long var0, String var2, String var3, String var4, long var5) throws SAXException;

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.checkNotReleased();
        if (uri == null || localName == null || qName == null) {
            throw new NullPointerException();
        }
        int length = attributes.getLength();
        long attrs = ContentHandlerImpl.allocateAttrArray();
        int i = 0;
        while (i < length) {
            String u = attributes.getURI(i);
            if (u == null) {
                throw new NullPointerException();
            }
            String localname = attributes.getLocalName(i);
            if (localname == null) {
                throw new NullPointerException();
            }
            String qname = attributes.getQName(i);
            if (qname == null) {
                throw new NullPointerException();
            }
            String type = attributes.getType(i);
            String value = attributes.getValue(i);
            ContentHandlerImpl.addAttrToArray(attrs, u, localname, qname, type, value);
            ++i;
        }
        ContentHandlerImpl.startElement(this.cObjectID, uri, localName, qName, attrs);
    }

    private static native void startPrefixMapping(long var0, String var2, String var3) throws SAXException;

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.checkNotReleased();
        if (prefix == null || uri == null) {
            throw new NullPointerException();
        }
        ContentHandlerImpl.startPrefixMapping(this.cObjectID, prefix, uri);
    }
}

