/*
 * Decompiled with CFR 0.152.
 */
package com.birdstep.bdbe.xml.sax;

import com.birdstep.BirdstepException;
import com.birdstep.BirdstepIf;
import com.birdstep.BirdstepUnknown;
import com.birdstep.bdbe.BdbeAttrFlags;
import com.birdstep.bdbe.BdbeAxis;
import com.birdstep.bdbe.BdbeAxisFlags;
import com.birdstep.bdbe.BdbeClass;
import com.birdstep.bdbe.BdbeCursor;
import com.birdstep.bdbe.BdbeDB;
import com.birdstep.bdbe.BdbeException;
import com.birdstep.bdbe.BdbeLookupMode;
import com.birdstep.bdbe.BdbeObjectId;
import com.birdstep.bdbe.xml.BdXMLEnvironment;
import com.birdstep.bdbe.xml.BdXMLErrorCodes;
import com.birdstep.bdbe.xml.def.BdXMLCharactersAttributes;
import com.birdstep.bdbe.xml.def.BdXMLDefConstants;
import com.birdstep.bdbe.xml.def.BdXMLDoctypeAttributes;
import com.birdstep.bdbe.xml.def.BdXMLDocumentAttributes;
import com.birdstep.bdbe.xml.def.BdXMLElementAttributes;
import com.birdstep.bdbe.xml.def.BdXMLEntityAttributes;
import com.birdstep.bdbe.xml.def.BdXMLEntityRefAttributes;
import com.birdstep.bdbe.xml.def.BdXMLNamespaceMapAttributes;
import com.birdstep.bdbe.xml.def.BdXMLNotationAttributes;
import com.birdstep.bdbe.xml.def.BdXMLPIAttributes;
import com.birdstep.bdbe.xml.sax.BdXMLImportHandler;
import com.birdstep.bdbe.xml.sax.BdXMLSAXParseException;
import com.birdstep.bdbe.xml.util.BdXMLInputSource;
import com.birdstep.bdbe.xml.util.BdXMLShared;
import java.io.IOException;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class BdXMLReader
implements XMLReader {
    BdbeDB db;
    BdbeCursor documentTreeCursor;
    private String FeatureNamespacePrefixes = "http://xml.org/sax/features/namespace-prefixes";
    private String FeatureNamespaces = "http://xml.org/sax/features/namespaces";
    private boolean _namespaces = true;
    private boolean _namespace_prefixes = true;
    private ContentHandler contentHandler;
    private DTDHandler dtdHandler;
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;
    private DeclHandler declHandler;
    private LexicalHandler lexicalHandler;
    private boolean _sort_attributes = false;
    public String FeatureSortAttributes = "http://www.birdstep.com/features/sortattributes";
    private BdXMLImportHandler importHandler;
    NamespaceSupport namespaceSupport;
    private boolean parsing = false;

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public DeclHandler getDeclHandler() {
        return this.declHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public boolean getFeature(String name) throws SAXNotSupportedException, SAXNotRecognizedException {
        if (name == this.FeatureNamespaces) {
            return this._namespaces;
        }
        if (name == this.FeatureNamespacePrefixes) {
            return this._namespace_prefixes;
        }
        return false;
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public Object getProperty(String name) throws SAXNotSupportedException, SAXNotRecognizedException {
        return null;
    }

    public void parse(String systemId) throws IOException, SAXException {
        throw new SAXException("This parser accepts only BdXMLInputSources");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource input) throws IOException, SAXException {
        if (this.parsing) {
            throw new SAXException("A parse is already in progress");
        }
        this.parsing = true;
        try {
            try {
                if (!(input instanceof BdXMLInputSource)) {
                    throw new SAXException("This parser accepts only BdXMLInputSources");
                }
                BirdstepUnknown unknown = ((BdXMLInputSource)((Object)input)).getUnknown();
                if (unknown instanceof BdbeDB) {
                    this.db = (BdbeDB)unknown;
                    this._parseDtd();
                } else if (unknown instanceof BdbeCursor) {
                    this.db = ((BdbeCursor)unknown).getDatabase();
                    try {
                        this.parseCursor((BdbeCursor)unknown);
                        Object var4_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        this.db.release();
                        throw throwable;
                    }
                    this.db.release();
                    {
                    }
                }
                Object var6_7 = null;
                this.parsing = false;
            }
            catch (BirdstepException exc) {
                throw new SAXException(exc);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.parsing = false;
            throw throwable;
        }
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public void setDeclHandler(DeclHandler handler) {
        this.declHandler = handler;
    }

    public void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public void setFeature(String name, boolean value) throws SAXNotSupportedException, SAXNotRecognizedException {
        if (name.equals(this.FeatureNamespaces)) {
            this._namespaces = value;
        } else if (name.equals(this.FeatureNamespacePrefixes)) {
            this._namespace_prefixes = value;
        } else if (name.equals(this.FeatureSortAttributes)) {
            this._sort_attributes = value;
        }
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this.lexicalHandler = handler;
    }

    public void setProperty(String name, Object value) throws SAXNotSupportedException, SAXNotRecognizedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _follow(BdbeCursor parentCursor) throws SAXException, BirdstepException {
        BdbeCursor currentCursor = parentCursor.lookupObjectsByAxis(BdbeAxis.BDBE_AXIS_CHILD, BdbeAxisFlags.BDBE_AX_SNAPSHOT);
        try {
            boolean selected = currentCursor.selectFirst();
            while (selected) {
                this._followCurrent(currentCursor);
                selected = currentCursor.selectNext();
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            currentCursor.release();
            throw throwable;
        }
        currentCursor.release();
    }

    private void _followCurrent(BdbeCursor currentCursor) throws SAXException, BdbeException {
        this.documentTreeCursor = currentCursor;
        try {
            block27: {
                try {
                    BdbeClass thisType = currentCursor.getBdbeClass();
                    boolean isElement = currentCursor.isObjectKindOf(this.db.getClass(BdXMLDefConstants.ELEMENTCLASSNAME));
                    if (isElement) {
                        this._followElement(currentCursor, thisType);
                        break block27;
                    }
                    if (thisType.equals(this.db.getClass(BdXMLDefConstants.COMMENTCLASSNAME))) {
                        if (this.lexicalHandler != null) {
                            String val = currentCursor.getAttributeString(BdXMLCharactersAttributes.CHARACTERS_ATTRIBUTES_CONTENT);
                            this.lexicalHandler.comment(val.toCharArray(), 0, val.length());
                        }
                        break block27;
                    }
                    if (thisType.equals(this.db.getClass(BdXMLDefConstants.PICLASSNAME))) {
                        if (this.contentHandler != null) {
                            String data = currentCursor.getAttributeString(BdXMLPIAttributes.PI_ATTRIBUTES_DATA);
                            String target = currentCursor.getLabel();
                            this.contentHandler.processingInstruction(target, data);
                        }
                        break block27;
                    }
                    if (thisType.equals(this.db.getClass(BdXMLDefConstants.ENTITYREFCLASSNAME))) {
                        this._followEntityRef(currentCursor);
                        break block27;
                    }
                    if (thisType.equals(this.db.getClass(BdXMLDefConstants.STRINGCLASSNAME))) {
                        if (this.contentHandler != null) {
                            String data = currentCursor.getAttributeString(BdXMLCharactersAttributes.CHARACTERS_ATTRIBUTES_CONTENT);
                            this.contentHandler.characters(data.toCharArray(), 0, data.length());
                        }
                        break block27;
                    }
                    if (thisType.equals(this.db.getClass(BdXMLDefConstants.CDATACLASSNAME))) {
                        if (this.lexicalHandler != null) {
                            this.lexicalHandler.startCDATA();
                        }
                        if (this.contentHandler != null) {
                            String data = currentCursor.getAttributeString(BdXMLCharactersAttributes.CHARACTERS_ATTRIBUTES_CONTENT);
                            this.contentHandler.characters(data.toCharArray(), 0, data.length());
                        }
                        if (this.lexicalHandler != null) {
                            this.lexicalHandler.endCDATA();
                        }
                        break block27;
                    }
                    if (thisType.equals(this.db.getClass(BdXMLDefConstants.DOCTYPECLASSNAME))) {
                        this._followDoctype(currentCursor);
                        break block27;
                    }
                    if (thisType.equals(this.db.getClass(BdXMLDefConstants.DOCUMENTCLASSNAME))) {
                        if (this.contentHandler != null) {
                            this.contentHandler.startDocument();
                        }
                        if (this.importHandler != null) {
                            String version = currentCursor.getAttributeString(BdXMLDocumentAttributes.DOCUMENT_ATTRIBUTES_VERSION);
                            if (version == null) {
                                version = "";
                            }
                            String _encoding = "";
                            int standalone = -1;
                            if (currentCursor.isAttributePresent(BdXMLDocumentAttributes.DOCUMENT_ATTRIBUTES_STANDALONE)) {
                                standalone = currentCursor.getAttributeShort(BdXMLDocumentAttributes.DOCUMENT_ATTRIBUTES_STANDALONE);
                            }
                            this.importHandler.xmlDeclaration(version, _encoding, standalone);
                        }
                        this._followChildren(currentCursor);
                        if (this.contentHandler != null) {
                            this.contentHandler.endDocument();
                        }
                        break block27;
                    }
                    if (thisType.equals(this.db.getClass(BdXMLDefConstants.NOTATIONCLASSNAME))) {
                        this._followNotation(currentCursor);
                        break block27;
                    }
                    if (thisType.equals(this.db.getClass(BdXMLDefConstants.ENTITYCLASSNAME))) {
                        this._followEntity(currentCursor);
                        break block27;
                    }
                    ((BdXMLShared)((Object)BdXMLEnvironment.getEnvironment())).throwBdXMLException(BdXMLErrorCodes.ERROR_BDXML_WRONG_NODE_TYPE);
                }
                catch (SAXException exc) {
                    throw exc;
                }
                catch (Exception exc) {
                    BdXMLSAXParseException e = new BdXMLSAXParseException("Internal error", exc, this.documentTreeCursor.getPath());
                    if (this.errorHandler != null) {
                        this.errorHandler.fatalError(e);
                    }
                    throw e;
                }
            }
            Object var8_15 = null;
            this.documentTreeCursor = null;
        }
        catch (Throwable throwable) {
            Object var8_16 = null;
            this.documentTreeCursor = null;
            throw throwable;
        }
    }

    private void _followAll(BdbeCursor currentCursor) throws BirdstepException, SAXException {
        boolean hasMore = currentCursor.selectFirst();
        while (hasMore) {
            this._followCurrent(currentCursor);
            hasMore = currentCursor.selectNext();
        }
    }

    private AttributesImpl _followAttributes(BdbeCursor currentCursor) throws SAXException, BdbeException {
        AttributesImpl attributes = new AttributesImpl();
        if (this.contentHandler != null) {
            String attrname;
            String val;
            if (this._namespaces && (val = currentCursor.getAttributeString(BdXMLElementAttributes.ELEMENT_ATTRIBUTES_XMLNSDEF)) != null) {
                String value = val;
                while (value != null) {
                    String prefix = BdXMLReader.lookupPrefix(value);
                    String uri = this.LookupNamespaceURIById(BdXMLReader.lookupNamespaceID(value));
                    this.contentHandler.startPrefixMapping(prefix, uri);
                    if (this._namespace_prefixes) {
                        attrname = "xmlns";
                        if (!prefix.equals("")) {
                            attrname = attrname + ":" + prefix;
                        }
                        attributes.addAttribute("", "", attrname, "CDATA", uri);
                    }
                    this.namespaceSupport.declarePrefix(prefix, uri);
                    value = BdXMLReader.lookupNextPrefix(value);
                }
            }
            BdbeClass clazz = this.db.getClass(BdXMLDefConstants.ELEMENTCLASSNAME);
            short[] attrs = currentCursor.getAttributeIdentifiers(0, clazz);
            int i = 0;
            while (i < attrs.length) {
                String value = currentCursor.getAttributeString(attrs[i]);
                attrname = currentCursor.getAttributeName(attrs[i]);
                String attrprefix = attrname.substring(0, attrname.indexOf(":"));
                String attruri = this.namespaceSupport.getURI(attrprefix);
                if (attruri == null) {
                    attruri = "";
                }
                String attrlocalname = attrname.substring(attrname.indexOf(":") + 1);
                String attrqname = attrname;
                if (attrqname.startsWith(":")) {
                    attrqname = attrqname.substring(1);
                }
                attributes.addAttribute(attruri, attrlocalname, attrqname, "CDATA", value);
                ++i;
            }
        }
        if (this._sort_attributes) {
            attributes = this.sortAttributes(attributes);
        }
        return attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _followChildren(BdbeCursor parentCursor) throws BirdstepException, SAXException {
        BdbeCursor currentCursor = parentCursor.lookupObjectsByAxis(BdbeAxis.BDBE_AXIS_CHILD, BdbeAxisFlags.BDBE_AX_SNAPSHOT);
        try {
            this._followAll(currentCursor);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            currentCursor.release();
            throw throwable;
        }
        currentCursor.release();
    }

    private void _followDoctype(BdbeCursor currentCursor) throws BirdstepException, SAXException {
        String name = currentCursor.getLabel();
        String publicId = currentCursor.getAttributeString(BdXMLDoctypeAttributes.DOCTYPE_ATTRIBUTES_PUBLICID);
        String systemId = currentCursor.getAttributeString(BdXMLDoctypeAttributes.DOCTYPE_ATTRIBUTES_SYSTEMID);
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startDTD(name, publicId, systemId);
        }
        this._parseDtd();
        if (this.declHandler != null) {
            this._followChildren(currentCursor);
        }
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endDTD();
        }
    }

    private void _followDtd() throws SAXException, BdbeException {
        if (this.declHandler != null) {
            BdbeClass elementClass = this.db.getClass(BdXMLDefConstants.ELEMENTCLASSNAME);
            BdbeClass clazz = this.db.getFirstClass();
            while (clazz != null) {
                if (elementClass.equals(this.db.getParentClass(clazz))) {
                    String eName = this.db.getClassName(clazz);
                    String elName = eName.substring(2);
                    this.declHandler.elementDecl(elName, null);
                    short attrid = this.db.getFirstAttribute(clazz);
                    while (attrid != 0) {
                        String attrname;
                        String value = null;
                        String aName = this.db.getAttributeName(clazz, attrid);
                        int flags = this.db.getAttributeFlags(clazz, attrid);
                        boolean hasdefvalue = (flags & BdbeAttrFlags.BDBE_AF_USER_DEFINED_DEFAULT_VALUE) == BdbeAttrFlags.BDBE_AF_USER_DEFINED_DEFAULT_VALUE;
                        String valueDefault = (flags & BdbeAttrFlags.BDBE_AF_MANDATORY) == BdbeAttrFlags.BDBE_AF_MANDATORY ? "#REQUIRED" : "#IMPLIED";
                        if (hasdefvalue) {
                            value = (String)this.db.getDefaultValue(clazz, attrid);
                        }
                        if ((attrname = aName).startsWith(":")) {
                            attrname = attrname.substring(1);
                        }
                        this.declHandler.attributeDecl(elName, attrname, null, valueDefault, value);
                        attrid = this.db.getNextAttribute(clazz, attrid);
                    }
                }
                clazz = this.db.getNextClass(clazz);
            }
        }
    }

    private void _followElement(BdbeCursor currentCursor, BdbeClass thisType) throws SAXException, BirdstepException {
        if (this.contentHandler != null) {
            if (this._namespaces) {
                this.namespaceSupport.pushContext();
            }
            AttributesImpl attrs = this._followAttributes(currentCursor);
            String uri = null;
            if (this._namespaces) {
                uri = this.LookupNamespaceURIById(currentCursor.getAttributeInt(BdXMLElementAttributes.ELEMENT_ATTRIBUTES_NAMESPACE));
            }
            String localname = currentCursor.getLabel();
            String locname = uri.equals("") ? "" : localname;
            String qname = currentCursor.getAttributeString(BdXMLElementAttributes.ELEMENT_ATTRIBUTES_PREFIX);
            qname = qname != null ? qname + ":" : "";
            qname = qname + localname;
            this.contentHandler.startElement(uri, locname, qname, attrs);
            this._followChildren(currentCursor);
            this.contentHandler.endElement(uri, locname, qname);
            this._followPrefixMappingsEnd(currentCursor);
            if (this._namespaces) {
                this.namespaceSupport.popContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _followEntity(BdbeCursor currentCursor) throws BirdstepException, SAXException {
        String name = currentCursor.getLabel();
        BdbeCursor children = currentCursor.lookupObjectsByAxis(BdbeAxis.BDBE_AXIS_CHILD, BdbeAxisFlags.BDBE_AX_SNAPSHOT);
        try {
            boolean hasMore = children.selectFirst();
            if (hasMore) {
                this._followInternalEntity(children, name);
            } else {
                String systemId = currentCursor.getAttributeString(BdXMLEntityAttributes.ENTITY_ATTRIBUTES_SYSTEMID);
                String publicId = currentCursor.getAttributeString(BdXMLEntityAttributes.ENTITY_ATTRIBUTES_PUBLICID);
                String notationName = currentCursor.getAttributeString(BdXMLEntityAttributes.ENTITY_ATTRIBUTES_NOTATIONNAME);
                if (notationName != null) {
                    if (this.dtdHandler != null) {
                        this.dtdHandler.unparsedEntityDecl(name, publicId, systemId, notationName);
                    }
                } else if (this.declHandler != null) {
                    this.declHandler.externalEntityDecl(name, publicId, systemId);
                }
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            children.release();
            throw throwable;
        }
        children.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _followEntityRef(BdbeCursor currentCursor) throws BirdstepException, SAXException {
        BdbeObjectId oid = new BdbeObjectId();
        oid.loid = currentCursor.getAttributeInt(BdXMLEntityRefAttributes.ENTITY_REF_ATTRIBUTES_ENTITYOID);
        oid.dbid = this.db.getInstanceId();
        BdbeClass entityType = this.db.getClass(BdXMLDefConstants.ENTITYCLASSNAME);
        BdbeCursor entityCursor = this.db.lookupObject(entityType, oid);
        if (entityCursor != null) {
            try {
                String name = entityCursor.getLabel();
                if (this.lexicalHandler != null) {
                    this.lexicalHandler.startEntity(name);
                    this._followChildren(entityCursor);
                } else if (this.contentHandler != null) {
                    this.contentHandler.characters(("&" + name + ";").toCharArray(), 0, name.length() + 2);
                }
                if (this.lexicalHandler != null) {
                    this.lexicalHandler.endEntity(name);
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                entityCursor.release();
                throw throwable;
            }
            entityCursor.release();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _followInternalEntity(BdbeCursor children, String name) throws BirdstepException, SAXException {
        String buf = "";
        boolean hasMore = true;
        while (hasMore) {
            if (children.getClass().equals(this.db.getClass(BdXMLDefConstants.ENTITYREFCLASSNAME))) {
                BdbeObjectId oid = new BdbeObjectId();
                oid.loid = children.getAttributeInt(BdXMLEntityRefAttributes.ENTITY_REF_ATTRIBUTES_ENTITYOID);
                oid.dbid = this.db.getInstanceId();
                BdbeClass entityType = this.db.getClass(BdXMLDefConstants.ENTITYCLASSNAME);
                BdbeCursor entityCursor = this.db.lookupObject(entityType, oid);
                if (entityCursor != null) {
                    Object var9_8;
                    try {
                        buf = buf + "&" + entityCursor.getLabel() + ";";
                        entityCursor.release();
                        var9_8 = null;
                    }
                    catch (Throwable throwable) {
                        var9_8 = null;
                        entityCursor.release();
                        throw throwable;
                    }
                    entityCursor.release();
                    {
                    }
                }
            } else if (children.getClass().equals(this.db.getClass(BdXMLDefConstants.STRINGCLASSNAME))) {
                buf = buf + children.getAttribute(BdXMLCharactersAttributes.CHARACTERS_ATTRIBUTES_CONTENT);
            } else {
                ((BdXMLShared)((Object)BdXMLEnvironment.getEnvironment())).throwBdXMLException(BdXMLErrorCodes.ERROR_BDXML_WRONG_NODE_TYPE);
            }
            hasMore = children.selectNext();
        }
        this.declHandler.internalEntityDecl(name, buf);
    }

    private void _followNotation(BdbeCursor currentCursor) throws BdbeException, SAXException {
        if (this.dtdHandler != null) {
            String name = currentCursor.getLabel();
            String publicId = (String)currentCursor.getAttribute(BdXMLNotationAttributes.NOTATION_ATTRIBUTES_PUBLICID);
            String systemId = (String)currentCursor.getAttribute(BdXMLNotationAttributes.NOTATION_ATTRIBUTES_SYSTEMID);
            this.dtdHandler.notationDecl(name, publicId, systemId);
        }
    }

    private void _followPrefixMappingsEnd(BdbeCursor currentCursor) throws BdbeException, SAXException {
        String val;
        if (this._namespaces && (val = (String)currentCursor.getAttribute(BdXMLElementAttributes.ELEMENT_ATTRIBUTES_XMLNSDEF)) != null) {
            String value = val;
            while (value != null) {
                String prefix = BdXMLReader.lookupPrefix(value);
                this.contentHandler.endPrefixMapping(prefix);
                value = BdXMLReader.lookupNextPrefix(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _parseDtd() throws SAXException, BirdstepException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startEntity("[dtd]");
        }
        this._followDtd();
        BdbeCursor cursor = (BdbeCursor)this.db.lookupObjectsByClass(null, this.db.getClass(BdXMLDefConstants.ENTITYCLASSNAME), BdbeLookupMode.BDBE_LOOKUP_ONLY_CLASS, BirdstepIf.BIRDSTEP_IF_BDBE_CURSOR);
        try {
            this._followAll(cursor);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            cursor.release();
            throw throwable;
        }
        cursor.release();
        cursor = (BdbeCursor)this.db.lookupObjectsByClass(null, this.db.getClass(BdXMLDefConstants.NOTATIONCLASSNAME), BdbeLookupMode.BDBE_LOOKUP_ONLY_CLASS, BirdstepIf.BIRDSTEP_IF_BDBE_CURSOR);
        try {
            this._followAll(cursor);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            cursor.release();
            throw throwable;
        }
        cursor.release();
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endEntity("[dtd]");
        }
    }

    int compare(String qname1, String qname2) {
        int toReturn = 0;
        if (qname1.equals(qname2)) {
            return 0;
        }
        toReturn = qname1.equals("xmlns") ? -1 : (qname2.equals("xmlns") ? 1 : (qname1.startsWith("xmlns:") ? (qname2.startsWith("xmlns:") ? qname1.substring(6).compareTo(qname2.substring(6)) : -1) : (qname2.startsWith("xmlns:") ? 1 : qname1.compareTo(qname2))));
        return toReturn;
    }

    private int getNextIndex(AttributesImpl attributes, String prevqname) {
        String currentqname = null;
        int toReturn = -1;
        int length = attributes.getLength();
        int i = 0;
        while (i < length) {
            String thisqname = attributes.getQName(i);
            if (!(prevqname != null && this.compare(prevqname, thisqname) >= 0 || currentqname != null && this.compare(thisqname, currentqname) >= 0)) {
                currentqname = thisqname;
                toReturn = i;
            }
            ++i;
        }
        return toReturn;
    }

    private static int lookupNamespaceID(String namespacedeclstring) {
        int indexSpace = namespacedeclstring.indexOf(" ");
        String idstring = indexSpace != -1 ? namespacedeclstring.substring(namespacedeclstring.indexOf("=") + 1, indexSpace) : namespacedeclstring.substring(namespacedeclstring.indexOf("=") + 1);
        return Integer.decode("0x" + idstring);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String LookupNamespaceURIById(int ID) throws BdbeException {
        if (ID == 0) {
            return "";
        }
        BdbeClass cls = this.db.getClass(BdXMLDefConstants.NAMESPACEMAPCLASSNAME);
        BdbeObjectId OID = new BdbeObjectId();
        OID.dbid = this.db.getInstanceId();
        OID.loid = ID;
        BdbeCursor cu = this.db.lookupObject(cls, OID);
        if (cu != null) {
            String string;
            try {
                string = (String)cu.getAttribute(BdXMLNamespaceMapAttributes.NAMESPACEMAP_ATTRIBUTES_URI);
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                cu.release();
                throw throwable;
            }
            cu.release();
            return string;
        }
        throw new RuntimeException("NamespaceObject has been deleted, but reference to it still exists");
    }

    private static String lookupNextPrefix(String namespacedeclstring) {
        int nextspaceindex = namespacedeclstring.indexOf(" ");
        if (nextspaceindex == -1) {
            return null;
        }
        return namespacedeclstring.substring(nextspaceindex + 1);
    }

    private static String lookupPrefix(String namespacedeclstring) {
        return namespacedeclstring.substring(0, namespacedeclstring.indexOf("="));
    }

    private void parseCursor(BdbeCursor documentCursor) throws BirdstepException, SAXException {
        if (this._namespaces) {
            this.namespaceSupport = new NamespaceSupport();
        }
        this._followCurrent(documentCursor);
        if (this._namespaces) {
            this.namespaceSupport.reset();
        }
    }

    public void setImportHandler(BdXMLImportHandler handler) {
        this.importHandler = handler;
    }

    public AttributesImpl sortAttributes(AttributesImpl attributes) {
        AttributesImpl newattrs = new AttributesImpl();
        String prevqname = null;
        int i = 0;
        while (i < attributes.getLength()) {
            int next = this.getNextIndex(attributes, prevqname);
            prevqname = attributes.getQName(next);
            newattrs.addAttribute(attributes.getURI(next), attributes.getLocalName(next), prevqname, attributes.getType(next), attributes.getValue(next));
            ++i;
        }
        return newattrs;
    }
}

