/*
 * Decompiled with CFR 0.152.
 */
package com.birdstep.bdbe.xml.jni;

import com.birdstep.BirdstepUnknown;
import com.birdstep.bdbe.BdbeDB;
import com.birdstep.bdbe.jni.BdbeImpl;
import com.birdstep.bdbe.xml.BdSAXIOConstants;
import com.birdstep.bdbe.xml.BdXML;
import com.birdstep.bdbe.xml.BdXMLConstants;
import com.birdstep.bdbe.xml.BdXMLDB;
import com.birdstep.bdbe.xml.BdXMLException;
import com.birdstep.bdbe.xml.BdXMLOpenFlags;
import com.birdstep.bdbe.xml.dom.jni.DOMNode;
import com.birdstep.bdbe.xml.jni.BdXMLDBImpl;
import com.birdstep.bdbe.xml.jni.BdXMLDBNative;
import com.birdstep.bdbe.xml.jni.BdXMLNative;
import com.birdstep.bdbe.xml.sax.jni.BdXMLExportHandlerNative;
import com.birdstep.bdbe.xml.util.BdXMLShared;
import com.birdstep.jni.JNIObject;
import com.birdstep.util.Reporter;
import java.io.IOException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class BdXMLImpl
implements BdXML,
BdXMLShared {
    public void exportXML(Node node, String toDocname) throws BdXMLException, IOException, SAXException {
        this.exportXML(node, toDocname, 0);
    }

    public short getRevision() {
        return BdXMLNative.getRevision();
    }

    public short getVersion() {
        return BdXMLNative.getVersion();
    }

    static void securityCheckRead(String szName) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(szName);
        }
    }

    static void securityCheckWrite(String szName) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite(szName);
        }
    }

    public BirdstepUnknown createExportHandler(String name) {
        long id = BdXMLNative.createExportHandler(name);
        if (id != 0L) {
            return new BdXMLExportHandlerNative(id);
        }
        return null;
    }

    public BdXMLDB createXMLDatabase(String name, int flags, long dbId) throws BdXMLException {
        BdXMLImpl.securityCheckRead(name);
        BdXMLImpl.securityCheckWrite(name);
        if (name == null) {
            throw new NullPointerException();
        }
        long cID = BdXMLNative.createXMLDatabase(name, flags, dbId);
        BdbeDB db = BdbeImpl.getDatabase(BdXMLDBNative.getDatabase(cID));
        BdXMLDBImpl xmldb = new BdXMLDBImpl(cID, db);
        BdbeImpl.setOwner(db, xmldb);
        return xmldb;
    }

    public String exportXML(Node node) throws BdXMLException, SAXException {
        return this.exportXML(node, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exportXML(Node node, int flags) throws BdXMLException, SAXException {
        BdbeDB bdbeDB = ((DOMNode)node).db;
        synchronized (bdbeDB) {
            ((JNIObject)((Object)node)).checkNotReleased();
            String string = BdXMLNative.exportXML(((JNIObject)((Object)node)).cObjectID, flags);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportXML(Node node, String toDocname, int flags) throws BdXMLException, IOException, SAXException {
        BdbeDB bdbeDB = ((DOMNode)node).db;
        synchronized (bdbeDB) {
            ((JNIObject)((Object)node)).checkNotReleased();
            if (toDocname == null) {
                throw new NullPointerException();
            }
            BdXMLNative.exportXML(((JNIObject)((Object)node)).cObjectID, toDocname, flags);
        }
    }

    public BdXMLDB openXMLDatabase(String name, int flags) throws BdXMLException {
        BdXMLImpl.securityCheckRead(name);
        if ((flags & BdXMLOpenFlags.BDXML_OF_READONLY) != BdXMLOpenFlags.BDXML_OF_READONLY) {
            BdXMLImpl.securityCheckWrite(name);
        }
        if (name == null) {
            throw new NullPointerException();
        }
        long cID = BdXMLNative.openXMLDatabase(name, flags);
        BdbeDB db = BdbeImpl.getDatabase(BdXMLDBNative.getDatabase(cID));
        BdXMLDBImpl xmldb = new BdXMLDBImpl(cID, db);
        BdbeImpl.setOwner(db, xmldb);
        return xmldb;
    }

    public void throwBdXMLException(int code) throws BdXMLException {
        BdXMLNative.throwBdXMLException(code);
    }

    static {
        try {
            System.loadLibrary("bdjxml");
            BdXMLNative.checkVersion(BdXMLConstants.BDXML_VERSION, BdSAXIOConstants.BDSAXIO_VERSION);
            Reporter.report("bdjxml library loaded");
        }
        catch (UnsatisfiedLinkError x) {
            System.err.println("Problem loading library bdjxml");
            throw x;
        }
    }
}

