/*
 * Decompiled with CFR 0.152.
 */
package com.birdstep.bdbe.xml.dom;

import com.birdstep.BirdstepException;
import com.birdstep.BirdstepIf;
import com.birdstep.bdbe.BdbeCursor;
import com.birdstep.bdbe.BdbeDB;
import com.birdstep.bdbe.jni.BdbeImpl;
import com.birdstep.bdbe.xml.BdXML;
import com.birdstep.bdbe.xml.BdXMLCreateFlags;
import com.birdstep.bdbe.xml.BdXMLCursor;
import com.birdstep.bdbe.xml.BdXMLDB;
import com.birdstep.bdbe.xml.BdXMLEnvironment;
import com.birdstep.bdbe.xml.BdXMLException;
import com.birdstep.bdbe.xml.def.BdXMLDocumentAttributes;
import com.birdstep.bdbe.xml.util.BdXMLInputSource;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BdXMLDocumentBuilder
extends DocumentBuilder {
    private static BdXMLDB database;

    public BdXMLDocumentBuilder() {
        if (database != null) {
            database.close();
            database = null;
        }
    }

    public DOMImplementation getDOMImplementation() {
        if (database == null) {
            BdXML env = BdXMLEnvironment.getEnvironment();
            try {
                database = env.createXMLDatabase("bdbe_jaxp.bdbe", BdXMLCreateFlags.BDXML_CR_CREATE_ALWAYS, 0L);
            }
            catch (BdXMLException exc) {
                throw new RuntimeException(exc.getMessage());
            }
        }
        return database;
    }

    public boolean isNamespaceAware() {
        return false;
    }

    public boolean isValidating() {
        return false;
    }

    public Document newDocument() {
        throw new RuntimeException("You have to create documents through a DOM implementation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document parse(InputSource is) throws IOException, SAXException {
        if (!(is instanceof BdXMLInputSource)) {
            throw new SAXException("Accepts only BdXMLInputSources");
        }
        BdXMLInputSource bdbeIs = (BdXMLInputSource)((Object)is);
        try {
            Document document;
            BdbeCursor cursor = (BdbeCursor)bdbeIs.getUnknown();
            BdbeDB db = cursor.getDatabase();
            try {
                BdXMLDB xmldb = (BdXMLDB)((Object)BdbeImpl.getOwner(db));
                BdXMLCursor xmlcursor = xmldb.lookupDocument(cursor.getAttributeString(BdXMLDocumentAttributes.DOCUMENT_ATTRIBUTES_NAME));
                try {
                    document = (Document)((Object)xmlcursor.inspect(BirdstepIf.BIRDSTEP_IF_DOM_DOCUMENT));
                    Object var9_9 = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    xmlcursor.release();
                    throw throwable;
                }
                xmlcursor.release();
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                db.release();
                throw throwable;
            }
            db.release();
            return document;
        }
        catch (BirdstepException exc) {
            throw new SAXException(exc);
        }
    }

    public void setEntityResolver(EntityResolver er) {
    }

    public void setErrorHandler(ErrorHandler eh) {
    }
}

