/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.common.resourceutilities.message;

import com.softwareag.common.resourceutilities.AbstractXMLBasedResourceBundle;
import com.softwareag.common.resourceutilities.XMLResourceBundleFailureHandler;
import com.softwareag.common.resourceutilities.message.MessageConstants;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLMessageResourceBundle
extends AbstractXMLBasedResourceBundle
implements MessageConstants {
    protected static XMLMessageResourceBundleFactory factory = new XMLMessageResourceBundleFactory();

    protected XMLMessageResourceBundle(URL uRL, Locale locale) throws SAXException, ParserConfigurationException, IOException {
        super(uRL, locale);
    }

    public static ResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader) {
        return XMLMessageResourceBundle.getBundle(string, locale, classLoader, null);
    }

    public static ResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader, XMLResourceBundleFailureHandler xMLResourceBundleFailureHandler) throws MissingResourceException {
        return AbstractXMLBasedResourceBundle.getBundle(string, locale, classLoader, xMLResourceBundleFailureHandler, factory);
    }

    protected DefaultHandler getDefaultHandler() {
        return new SAXHandler(this);
    }

    protected static class SAXHandler
    extends DefaultHandler {
        public static final String MESSAGE_INFO_TAG = "message-info";
        public static final String MESSAGE_TAG = "message";
        public static final String MESSAGE_TEXT_TAG = "mess-text";
        public static final String MESS_EXPL_TAG = "mess-expl";
        public static final String P_TAG = "p";
        public static final String TITLE_TAG = "title";
        public static final String GUI_TITLE_TAG = "gui-title";
        public static final String ACTION_TAG = "action";
        public static final String ID_ATTRIBUTE = "id";
        public static final String EMPTY_STRING = "";
        protected XMLMessageResourceBundle resourceBundle = null;
        protected String propertyKey = "";
        protected Stack propertyKeyStack = new Stack();
        protected StringBuffer propertyValue = new StringBuffer();
        protected Stack propertyValueStack = new Stack();
        protected Stack elementNameStack = new Stack();
        protected String elementName = "";
        protected String id = null;
        protected boolean isMessageInfo = false;

        public SAXHandler(XMLMessageResourceBundle xMLMessageResourceBundle) {
            this.resourceBundle = xMLMessageResourceBundle;
        }

        protected String getPropertyKeyForElement(String string) {
            String string2 = EMPTY_STRING;
            if (this.id != null) {
                if (string.equals(MESSAGE_TEXT_TAG)) {
                    string2 = this.id;
                } else if (string.equals(TITLE_TAG) || string.equals(GUI_TITLE_TAG)) {
                    String string3 = (String)this.elementNameStack.peek();
                    if (MESSAGE_TAG.equals(string3)) {
                        string2 = this.id + "_TITLE";
                    } else if (MESS_EXPL_TAG.equals(string3)) {
                        string2 = this.id + "_EXPLANATION_TITLE";
                    } else if (ACTION_TAG.equals(string3)) {
                        string2 = this.id + "_ACTION_TITLE";
                    }
                } else if (string.equals(P_TAG)) {
                    String string4 = (String)this.elementNameStack.peek();
                    if (MESS_EXPL_TAG.equals(string4)) {
                        string2 = this.id + "_EXPLANATION";
                    } else if (ACTION_TAG.equals(string4)) {
                        string2 = this.id + "_ACTION";
                    }
                }
            }
            return string2;
        }

        protected void processAttributes(String string, Attributes attributes) {
            if (string.equals(MESSAGE_INFO_TAG)) {
                this.id = attributes.getValue(ID_ATTRIBUTE);
                if (this.id != null) {
                    XMLMessageResourceBundle.super.put(this.id + "_HELP_ID", this.id);
                }
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals(MESSAGE_INFO_TAG)) {
                this.isMessageInfo = true;
            }
            if (this.isMessageInfo) {
                this.propertyKeyStack.push(this.propertyKey);
                this.propertyValueStack.push(this.propertyValue);
                this.elementNameStack.push(this.elementName);
                this.propertyKey = EMPTY_STRING;
                this.propertyValue = new StringBuffer();
                this.elementName = string3;
                this.processAttributes(string3, attributes);
                this.propertyKey = this.getPropertyKeyForElement(string3);
                if (this.propertyKey.equals(this.id)) {
                    this.propertyValue.append(this.id);
                    this.propertyValue.append(" ");
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.isMessageInfo) {
                if (this.propertyKey != EMPTY_STRING) {
                    XMLMessageResourceBundle.super.put(this.propertyKey, this.propertyValue.toString());
                }
                this.propertyKey = (String)this.propertyKeyStack.pop();
                this.propertyValue = (StringBuffer)this.propertyValueStack.pop();
                this.elementName = (String)this.elementNameStack.pop();
            }
            if (string3.equals(MESSAGE_INFO_TAG)) {
                this.isMessageInfo = false;
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.isMessageInfo && this.propertyKey != EMPTY_STRING) {
                this.propertyValue.append(cArray, n, n2);
            }
        }

        public void warning(SAXException sAXException) throws SAXException {
            throw sAXException;
        }

        public void error(SAXException sAXException) throws SAXException {
            throw sAXException;
        }

        public void fatalError(SAXException sAXException) throws SAXException {
            throw sAXException;
        }
    }

    protected static class XMLMessageResourceBundleFactory
    implements AbstractXMLBasedResourceBundle.XMLBasedResourceBundleFactory {
        protected XMLMessageResourceBundleFactory() {
        }

        public AbstractXMLBasedResourceBundle createXMLResourceBundle(URL uRL, Locale locale) throws SAXException, ParserConfigurationException, IOException {
            return new XMLMessageResourceBundle(uRL, locale);
        }
    }
}

