/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.common.resourceutilities;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;

public class ResourceLocator {
    private static final boolean PRE_CHECK = Precondition.isEnabled((Class)(class$com$softwareag$common$resourceutilities$ResourceLocator == null ? (class$com$softwareag$common$resourceutilities$ResourceLocator = ResourceLocator.class$("com.softwareag.common.resourceutilities.ResourceLocator")) : class$com$softwareag$common$resourceutilities$ResourceLocator));
    private static final boolean POST_CHECK = Postcondition.isEnabled((Class)(class$com$softwareag$common$resourceutilities$ResourceLocator == null ? (class$com$softwareag$common$resourceutilities$ResourceLocator = ResourceLocator.class$("com.softwareag.common.resourceutilities.ResourceLocator")) : class$com$softwareag$common$resourceutilities$ResourceLocator));
    protected static Map cache = null;
    static /* synthetic */ Class class$com$softwareag$common$resourceutilities$ResourceLocator;

    public static ResourceLocation getResourceLocation(String string, String string2) {
        return ResourceLocator.getResourceLocation(string, string2, null, null);
    }

    public static ResourceLocation getResourceLocation(String string, String string2, ClassLoader classLoader) {
        return ResourceLocator.getResourceLocation(string, string2, null, classLoader);
    }

    public static ResourceLocation getResourceLocation(String string, String string2, Locale locale) {
        return ResourceLocator.getResourceLocation(string, string2, locale, null);
    }

    public static ResourceLocation getResourceLocation(String string, String string2, Locale locale, ClassLoader classLoader) {
        ResourceLocation resourceLocation = null;
        List list = ResourceLocator.getAllResourceLocations(string, string2, locale, classLoader);
        if (list.size() > 0) {
            resourceLocation = (ResourceLocation)list.get(0);
        }
        return resourceLocation;
    }

    public static List getAllResourceLocations(String string, String string2) {
        return ResourceLocator.getAllResourceLocations(string, string2, null, null);
    }

    public static List getAllResourceLocations(String string, String string2, ClassLoader classLoader) {
        return ResourceLocator.getAllResourceLocations(string, string2, null, classLoader);
    }

    public static List getAllResourceLocations(String string, String string2, Locale locale) {
        return ResourceLocator.getAllResourceLocations(string, string2, locale, null);
    }

    public static synchronized List getAllResourceLocations(String string, String string2, Locale locale, ClassLoader classLoader) {
        ArrayList<ResourceLocation> arrayList = new ArrayList<ResourceLocation>();
        List list = ResourceLocator.getLocalizedResourceNames(string, string2, locale);
        if (classLoader == null) {
            classLoader = (class$com$softwareag$common$resourceutilities$ResourceLocator == null ? (class$com$softwareag$common$resourceutilities$ResourceLocator = ResourceLocator.class$("com.softwareag.common.resourceutilities.ResourceLocator")) : class$com$softwareag$common$resourceutilities$ResourceLocator).getClassLoader();
        }
        Iterator iterator = list.iterator();
        LocalizedResourceName localizedResourceName = null;
        CacheKey cacheKey = null;
        ResourceLocation resourceLocation = null;
        while (iterator.hasNext()) {
            URL uRL;
            localizedResourceName = (LocalizedResourceName)iterator.next();
            cacheKey = new CacheKey(localizedResourceName.getName(), classLoader);
            if (cache != null) {
                resourceLocation = (ResourceLocation)cache.get(cacheKey);
            }
            if (resourceLocation == null && (uRL = classLoader.getResource(localizedResourceName.getName())) != null) {
                if (cache == null) {
                    cache = new WeakHashMap();
                }
                resourceLocation = new ResourceLocation(uRL, localizedResourceName.getLocale());
                cache.put(cacheKey, resourceLocation);
            }
            if (resourceLocation == null) continue;
            arrayList.add(resourceLocation);
        }
        return arrayList;
    }

    static List getLocalizedResourceNames(String string, String string2, Locale locale) {
        ArrayList<LocalizedResourceName> arrayList = new ArrayList<LocalizedResourceName>();
        if (string != null) {
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            string = string.replace('.', '/');
            ResourceLocator.getLocalizedResourceNames(string, string2, locale, arrayList);
            if (locale == null || ResourceLocator.checkForDifferentLanguageOrLessSpecific(locale, Locale.getDefault())) {
                ResourceLocator.getLocalizedResourceNames(string, string2, Locale.getDefault(), arrayList);
            }
            if (string2 != null) {
                arrayList.add(new LocalizedResourceName(string + "." + string2, new Locale("", "")));
            } else {
                arrayList.add(new LocalizedResourceName(string, new Locale("", "")));
            }
        }
        return arrayList;
    }

    protected static void getLocalizedResourceNames(String string, String string2, Locale locale, List list) {
        if (locale != null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (locale.getLanguage().length() > 0 & locale.getCountry().length() > 0 & locale.getVariant().length() > 0) {
                stringBuffer.setLength(0);
                stringBuffer.append(string);
                stringBuffer.append("_");
                stringBuffer.append(locale.getLanguage());
                stringBuffer.append("_");
                stringBuffer.append(locale.getCountry());
                stringBuffer.append("_");
                stringBuffer.append(locale.getVariant());
                if (string2 != null) {
                    stringBuffer.append(".");
                    stringBuffer.append(string2);
                }
                list.add(new LocalizedResourceName(stringBuffer.toString(), new Locale(locale.getLanguage(), locale.getCountry(), locale.getVariant())));
            }
            if (locale.getLanguage().length() > 0 & locale.getCountry().length() > 0) {
                stringBuffer.setLength(0);
                stringBuffer.append(string);
                stringBuffer.append("_");
                stringBuffer.append(locale.getLanguage());
                stringBuffer.append("_");
                stringBuffer.append(locale.getCountry());
                if (string2 != null) {
                    stringBuffer.append(".");
                    stringBuffer.append(string2);
                }
                list.add(new LocalizedResourceName(stringBuffer.toString(), new Locale(locale.getLanguage(), locale.getCountry())));
            }
            if (locale.getLanguage().length() > 0) {
                stringBuffer.setLength(0);
                stringBuffer.append(string);
                stringBuffer.append("_");
                stringBuffer.append(locale.getLanguage());
                if (string2 != null) {
                    stringBuffer.append(".");
                    stringBuffer.append(string2);
                }
                list.add(new LocalizedResourceName(stringBuffer.toString(), new Locale(locale.getLanguage(), "")));
            }
        }
    }

    static boolean checkForDifferentLanguageOrLessSpecific(Locale locale, Locale locale2) {
        if (PRE_CHECK) {
            Precondition.check((String)"Parameter 'original' must not be null", (locale != null ? 1 : 0) != 0);
        }
        if (PRE_CHECK) {
            Precondition.check((String)"Parameter 'toCheck' must not be null", (locale2 != null ? 1 : 0) != 0);
        }
        boolean bl = true;
        boolean bl2 = bl = locale.getLanguage().length() > 0 && !locale.getLanguage().equals(locale2.getLanguage());
        if (!bl) {
            boolean bl3 = bl = locale.getCountry().length() > 0 && locale2.getCountry().length() == 0;
        }
        if (!bl) {
            bl = locale.getVariant().length() > 0 && locale2.getVariant().length() == 0;
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class LocalizedResourceName {
        String name = null;
        Locale locale = null;

        public LocalizedResourceName(String string, Locale locale) {
            this.name = string;
            this.locale = locale;
        }

        public String getName() {
            return this.name;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public boolean isEqual(Object object) {
            boolean bl = false;
            if (object instanceof LocalizedResourceName) {
                LocalizedResourceName localizedResourceName = (LocalizedResourceName)object;
                bl = this.getName().equals(localizedResourceName.getName());
                bl &= this.getLocale().equals(localizedResourceName.getLocale());
            }
            return bl;
        }

        public int hashCode() {
            return this.getName().hashCode() + 13 * this.getLocale().hashCode();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("LocalizedResourceName[");
            stringBuffer.append(this.getName());
            stringBuffer.append(", ");
            stringBuffer.append(this.getLocale());
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }

    public static class ResourceLocation {
        URL url = null;
        Locale locale = null;

        public ResourceLocation(URL uRL, Locale locale) {
            this.url = uRL;
            this.locale = locale;
        }

        public URL getURL() {
            return this.url;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public boolean isEqual(Object object) {
            boolean bl = false;
            if (object instanceof ResourceLocation) {
                ResourceLocation resourceLocation = (ResourceLocation)object;
                bl = this.getURL().equals(resourceLocation.getURL());
                bl &= this.getLocale().equals(resourceLocation.getLocale());
            }
            return bl;
        }

        public int hashCode() {
            return this.getURL().hashCode() + 13 * this.getLocale().hashCode();
        }
    }

    protected static class CacheKey {
        protected String resourceName = null;
        protected ClassLoader classLoader = null;

        public CacheKey(String string, ClassLoader classLoader) {
            this.resourceName = string;
            this.classLoader = classLoader;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof CacheKey) {
                CacheKey cacheKey = (CacheKey)object;
                bl = this.resourceName.equals(cacheKey.resourceName);
                bl &= this.classLoader.equals(cacheKey.classLoader);
            }
            return bl;
        }

        public int hashCode() {
            return this.resourceName.hashCode() + 13 * this.classLoader.hashCode();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("CacheKey[");
            stringBuffer.append(this.resourceName);
            stringBuffer.append(", ");
            stringBuffer.append(this.classLoader);
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }
}

