/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.mobile.xplorer;

import com.birdstep.bdbe.xml.BdXMLException;
import com.softwareag.mobile.xplorer.MobileDBAccessor;
import com.softwareag.mobile.xplorer.MobileDBFileFilter;
import com.softwareag.mobile.xplorer.MobileDBViewer;
import com.softwareag.mobile.xplorer.MobileDocument;
import java.awt.Component;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPlorer {
    protected static final String TITLE = "Tamino Mobile DB Viewer - ";
    protected JFrame applicationFrame = new JFrame();
    protected MobileDBAccessor accessor = null;
    protected MobileDBViewer viewer = null;

    public XPlorer() {
        this.applicationFrame.setDefaultCloseOperation(3);
        File databaseFile = this.getDatabaseFile(this.getApplicationFrame());
        if (databaseFile == null) {
            System.exit(0);
        }
        try {
            this.accessor = new MobileDBAccessor(databaseFile);
            MobileDocument[] documents = this.accessor.getMobileDocuments();
            this.viewer = new MobileDBViewer(documents);
            this.applicationFrame.getContentPane().add(this.viewer);
            ((Component)this.applicationFrame).setSize(500, 300);
            this.applicationFrame.setTitle(new StringBuffer().append(TITLE).append(databaseFile.getName()).toString());
            ((Component)this.applicationFrame).setVisible(true);
        }
        catch (BdXMLException e) {
            this.displayException((Exception)((Object)e), this.getApplicationFrame());
            System.exit(0);
        }
    }

    public JFrame getApplicationFrame() {
        return this.applicationFrame;
    }

    public File getDatabaseFile(JFrame parentFrame) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Open database file");
        fileChooser.setFileFilter(new MobileDBFileFilter());
        fileChooser.showOpenDialog(parentFrame);
        File selectedFile = fileChooser.getSelectedFile();
        return selectedFile;
    }

    public void displayException(Exception e, JFrame parentFrame) {
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        JOptionPane.showMessageDialog(parentFrame, stringWriter.toString());
    }

    public static void main(String[] args) {
        new XPlorer();
    }
}

