/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.mobile.xplorer;

import com.birdstep.bdbe.xml.BdXMLException;
import com.softwareag.mobile.xplorer.MobileDBAccessor;
import com.softwareag.mobile.xplorer.MobileDBFileFilter;
import com.softwareag.mobile.xplorer.MobileDBViewer;
import com.softwareag.xtools.common.standard.awt.AWTUtility;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class MobileXPlorer {
    protected static final String TITLE = "Tamino Mobile DB XPlorer - ";
    protected JFrame applicationFrame = new JFrame();
    protected MobileDBAccessor accessor = null;
    protected MobileDBViewer viewer = null;

    public MobileXPlorer() {
        this.applicationFrame.setDefaultCloseOperation(3);
        File file = this.getDatabaseFile(this.getApplicationFrame());
        if (file == null) {
            System.exit(0);
        }
        try {
            this.accessor = new MobileDBAccessor(file);
            this.viewer = new MobileDBViewer(this.accessor);
            this.applicationFrame.getContentPane().add(this.viewer);
            ((Component)this.applicationFrame).setSize(500, 300);
            this.applicationFrame.setTitle(TITLE + file.getName());
            AWTUtility.centerOnScreen((Window)this.applicationFrame);
            ((Component)this.applicationFrame).setVisible(true);
        }
        catch (BdXMLException bdXMLException) {
            this.displayException((Exception)((Object)bdXMLException), this.getApplicationFrame());
            System.exit(0);
        }
    }

    public JFrame getApplicationFrame() {
        return this.applicationFrame;
    }

    public File getDatabaseFile(JFrame jFrame) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Open database file");
        jFileChooser.setFileFilter(new MobileDBFileFilter());
        jFileChooser.showOpenDialog(jFrame);
        File file = jFileChooser.getSelectedFile();
        return file;
    }

    public void displayException(Exception exception, JFrame jFrame) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        JOptionPane.showMessageDialog(jFrame, stringWriter.toString());
    }

    public static void main(String[] stringArray) {
        System.out.println("java.library.path: ");
        System.out.println(System.getProperty("java.library.path"));
        new MobileXPlorer();
    }
}

