/*
 -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

 Legal notice:

 This free of charge, unsupported Software is provided on an "AS IS" basis,
 without warranty of any kind. The entire risk as to the quality and performance
 of the software is borne by you. Should the software prove defective, you and
 only you assume the entire cost of any service and repair.

 WEBMETHODS DOES NOT MAKE ANY EXPRESS OR IMPLIED WARRANTIES OF ANY KIND
 INCLUDING, BUT NOT LIMITED TO, WARRANTIES OF TITLE, MERCHANTABILITY OR
 FITNESS FOR A PARTICULAR PURPOSE, OR WARRANTIES ARISING BY STATUTE, COURSE
 OF DEALING, CUSTOM OR USAGE, TRADE PRACTICE OR OTHERWISE.

 IN NO EVENT WILL WEBMETHODS BE LIABLE FOR ANY LOST REVENUES, PROFITS,
 BUSINESS OR INTERRUPTION OF BUSINESS OR OTHER SPECIAL, INDIRECT, INCIDENTAL
 OR CONSEQUENTIAL DAMAGES, EVEN IF WEBMETHODS HAS BEEN ADVISED OF THE
 POSSIBILITY OF SUCH DAMAGES, AND NOTWITHSTANDING ANY FAILURE OF ESSENTIAL
 PURPOSE OF ANY LIMITED REMEDY OF ANY KIND, HOWEVER CAUSED AND UNDER ANY
 THEORY OF LIABILITY.

 -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 */

package com.webmethods.portal.portlet.wp_custauth;

import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Category;

import com.webmethods.portal.PortalException;
import com.webmethods.portal.bizPolicy.IContext;
import com.webmethods.portal.bizPolicy.ITraits;
import com.webmethods.portal.bizPolicy.impl.ContextFactory;
import com.webmethods.portal.framework.FrameworkException;
import com.webmethods.portal.framework.Handler;
import com.webmethods.portal.framework.auth.AuthInfo;
import com.webmethods.portal.framework.auth.IAuthHandler;
import com.webmethods.portal.service.dir.DirectoryTools;
import com.webmethods.portal.service.portlet.IPortletBean;
import com.webmethods.portal.service.portlet.IPortletProvider;
import com.webmethods.portal.system.IComponentData;
import com.webmethods.portal.system.IURI;
import com.webmethods.portal.system.PortalSystem;
import com.webmethods.portal.system.init.InitializationException;
import com.webmethods.rtl.util.Debug;
import com.webmethods.rtl.util.StringTools;
import com.webmethods.sc.directory.DirectoryException;
import com.webmethods.sc.directory.DirectorySystemFactory;
import com.webmethods.sc.directory.IDirectoryPrincipal;
import com.webmethods.sc.directory.IDirectoryRole;
import com.webmethods.sc.directory.IDirectorySession;
import com.webmethods.sc.directory.IDirectorySystem;
import com.webmethods.sc.directory.IDirectoryUser;

/**
 * IAuth handler
 */
public class CustAuthHandler extends Handler implements IAuthHandler {

	public static final String AUTH_TYPE = "custAuth";

	protected static final String HTTP_CUSTAUTH = "/portlet/wp_custauth";

	protected Category m_logCategory = Debug.getLogCategory("portalLogin");

	protected String m_logoutURL = null;

	protected String m_userHeaderName;

	protected boolean m_enabledCustAuth = false;
	
	@Override
	public void init(IComponentData arg0, String arg1)
			throws InitializationException {
		super.init(arg0, arg1);
	}

	public void setUserHeaderName(String userHeaderName) {
		m_userHeaderName = userHeaderName;
	}

	public void setEnableCustAuth(String value) {
		m_enabledCustAuth = "true".equalsIgnoreCase(value);
	}

	public void setLogoffLink(String logoffLink) {
		m_logoutURL = logoffLink;
	}

	public String getUserHeaderName() throws FrameworkException {
		if (m_userHeaderName == null) {
			loadConfig();
		}

		return m_userHeaderName;
	}

	public String getLogoutURL() throws FrameworkException {
		if (m_logoutURL == null) {
			loadConfig();
		}

		return m_logoutURL;
	}
	/*
	 * Add logic for custom authentication
	 */
	public boolean handle(HttpServletRequest request) throws FrameworkException {
		 
		 String username = request.getParameter("username");
	     String password = request.getParameter("password");
	     if (StringTools.isEmpty(username)) {
	    	 return false;
	     }
	//     String ecnumber = request.getParameter("ecnumber");
	     
	     IContext context = null;
	     ITraits cachedTraits = null;
	     IDirectorySystem system = null;
	     IDirectorySession session = null;	    	     
	     
		try
		{	       	 
			// suppress permissions checking
			 context = ContextFactory.acquireContext(true);
		     cachedTraits = context.getTraits();
		     cachedTraits.updateTraits(ITraits.ACCESS, false);
		     context.setTraits(cachedTraits);
			
			
			 system = DirectorySystemFactory.getDirectorySystem();
			 session = system.createSession();
			
			// authenticate user (throws exception if auth fails)
			 IDirectoryUser user = session.authenticateUser(username, password);		
			
			 
			 // init AuthInfo for user
	         AuthInfo authInfo = AuthInfo.getAuthInfo(request.getSession());
	         authInfo.setInfo(username, password, "", "custAuth");
	         authInfo.setIsAnonymous(false);
	         authInfo.setIsPrivilegedInfo(false);
	         
	         // invoke your webservice here
	         
	         //Find specified role
	         IDirectoryPrincipal role = session.lookupPrincipalByName("ETIC", IDirectoryPrincipal.TYPE_ROLE);
	         
	        // add user to role
	         session.addPrincipalToRole(user.getID(), role.getID());
	         
	         // print our role membership
	         for (IDirectoryRole o : session.getRoleMembership(user.getID()))
	         {
	        	 Debug.info("The Role assigned is:"+o.getName(),m_logCategory);
	         }  

	         return true; // success

	     } catch (Exception e) {
	         // authentication failed
	    	 Debug.warn(e, m_logCategory);	    	 		    	 	

	     } finally {
	         system.destroySession(session);
	         cachedTraits.updateTraits(ITraits.ACCESS, true);
		     context.setTraits(cachedTraits);
	     }

	     return false; // failure		
	}
		


	protected void loadConfig() throws FrameworkException {
		try {
			IContext adminContext = ContextFactory
					.acquireContext(new HashMap());
			IURI uri = PortalSystem.getPortalSystem().acquireURI(HTTP_CUSTAUTH);
			IPortletProvider portletProvider = (IPortletProvider) PortalSystem
					.getPortletProvider();
			IPortletBean smAdminBean = portletProvider.getPortletBean(uri,
					adminContext.getUserID());
			setUserHeaderName((String) smAdminBean
					.getProperty(CustAuth.PROPERTY_USERHEADERNAME));
			setEnableCustAuth((String) smAdminBean
					.getProperty(CustAuth.PROPERTY_ENABLECUSTAUTH));
			Debug.info("wp_custauth enabled = " + m_enabledCustAuth);
		} catch (PortalException e) {
			throw FrameworkException.reuseOrWrap(e);
		}
	}
}
