/*
 -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

 Legal notice:

 This free of charge, unsupported Software is provided on an "AS IS" basis,
 without warranty of any kind. The entire risk as to the quality and performance
 of the software is borne by you. Should the software prove defective, you and
 only you assume the entire cost of any service and repair.

 WEBMETHODS DOES NOT MAKE ANY EXPRESS OR IMPLIED WARRANTIES OF ANY KIND
 INCLUDING, BUT NOT LIMITED TO, WARRANTIES OF TITLE, MERCHANTABILITY OR
 FITNESS FOR A PARTICULAR PURPOSE, OR WARRANTIES ARISING BY STATUTE, COURSE
 OF DEALING, CUSTOM OR USAGE, TRADE PRACTICE OR OTHERWISE.

 IN NO EVENT WILL WEBMETHODS BE LIABLE FOR ANY LOST REVENUES, PROFITS,
 BUSINESS OR INTERRUPTION OF BUSINESS OR OTHER SPECIAL, INDIRECT, INCIDENTAL
 OR CONSEQUENTIAL DAMAGES, EVEN IF WEBMETHODS HAS BEEN ADVISED OF THE
 POSSIBILITY OF SUCH DAMAGES, AND NOTWITHSTANDING ANY FAILURE OF ESSENTIAL
 PURPOSE OF ANY LIMITED REMEDY OF ANY KIND, HOWEVER CAUSED AND UNDER ANY
 THEORY OF LIABILITY.

 -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
 */

package com.webmethods.portal.portlet.wp_custauth;

import com.webmethods.portal.PortalException;
import com.webmethods.portal.bizPolicy.biz.IBizPolicyManager;
import com.webmethods.portal.bizPolicy.biz.meta.IBasicPolicy;
import com.webmethods.portal.framework.portlet.beans.JspPortletBean;
import com.webmethods.portal.service.meta2.thing.IThingID;
import com.webmethods.portal.system.IComponentData;
import com.webmethods.portal.system.PortalSystem;

import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Category;

import com.webmethods.rtl.util.Debug;
import com.webmethods.rtl.util.StringTools;

/**
 * CustAuth portlet implementation.
 *
 */
public class CustAuth extends JspPortletBean {

	private static final long serialVersionUID = 1L;
	public final static String PROPERTY_USERHEADERNAME = "userHeaderName";
    public final static String PROPERTY_ENABLECUSTAUTH = "enableCustAuth";
	public final static String PROPERTY_LOGOUTURL = "logoutURL";
	
	protected Category m_logCategory = Debug.getLogCategory("portalLogin");

    /**
     * Gets the value of the userHeaderName property.
     *
     * @return the value of the userHeaderName property
     */
    public String getUserHeaderName() {
        return getPropertyAsString(PROPERTY_USERHEADERNAME);
    }

    /**
     * Sets the value of the userHeaderName property.
     *
     * @param value the value to use for the userHeaderName property
     */
    public void setUserHeaderName(String value) {
        setProperty(PROPERTY_USERHEADERNAME, value);
    }

    /**
     * Sets the value of the 'enableCustAuth' property.
     *
     * @param value the value to use for the 'enableCustAuth' property
     */
    public void setEnableCustAuth(String value) {
        setProperty(PROPERTY_ENABLECUSTAUTH, value);
    }

    /**
     * Gets the value of the 'enableCustAuth' property.
     *
     * @return the value of the 'enableCustAuth' property
     */
    public String getEnableCustAuth() throws PortalException {
        String strValue = getPropertyAsString(PROPERTY_ENABLECUSTAUTH, null);
        return strValue;
    }

    /**
     * this method is called by portlet controller dispatch handler
     */
    public void updateAuthHandler() throws PortalException {
        IThingID thingID = getPortletInfo().getXTypeID();

        //get the basic Policy from the biz policy manager
        IBizPolicyManager bizPolicyManager = (IBizPolicyManager) PortalSystem.getBizPolicyProvider();
        IBasicPolicy basicPolicy = (IBasicPolicy) bizPolicyManager.getBizPolicy(thingID);

        //populate the property map to set
        Map props = new HashMap();
        props.put(PROPERTY_USERHEADERNAME, getUserHeaderName());
        props.put(PROPERTY_ENABLECUSTAUTH, getEnableCustAuth());
        props.put(PROPERTY_LOGOUTURL, getLogoutURL());

        //update the props on the thingID
        basicPolicy.updateProperties(getPortletContext(), thingID, props);

        thingID = (IThingID) PortalSystem.getPortalSystem().acquireURI("/webApp/authManager/CustAuthHandler");
        IComponentData componentData = (IComponentData) thingID.getThing();
        CustAuthHandler custAuthHandler = (CustAuthHandler) componentData.getComponent();
        custAuthHandler.setUserHeaderName(getUserHeaderName());
        custAuthHandler.setEnableCustAuth(getEnableCustAuth());
        
        Debug.info("CustAuth AuthHandler enabled set to  " + getEnableCustAuth(), m_logCategory);
    }

	/**
	     * Sets the value of the 'logoutURL' property.  
	     *
	     * @param value the value to use for the 'logoutURL' property
	     */
	    public void setLogoutURL(java.lang.String value) {
	        setProperty(PROPERTY_LOGOUTURL, value);
	    }

	/**
	     * Gets the value of the 'logoutURL' property.  
	     *
	     * @return the value of the 'logoutURL' property
	     */
	    public java.lang.String getLogoutURL() throws PortalException {
	        String strValue = getPropertyAsString(PROPERTY_LOGOUTURL, null);
	        if (StringTools.isEmpty(strValue)) { //null check
	            return null;    
	        }
	        return strValue;
	    };
}
