<!-- *** Copyright (c) 2001 - 2003 Software AG. All Rights Reserved. *** -->
<!-- *** Version: $Revision: 1.11 $                           *** -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xapp="http://www.softwareag.com/xtools/xapplication"
                xmlns="http://www.w3.org/1999/xhtml" version="1.0">
                
<xsl:import href="./basics.xsl" />

<!-- *** Definition of the stye sheet parameters -->
<!-- appConfig contains the content of the xapplication.xml  -->
<xsl:param name="appConfig" />
<!-- Contains the content of the config.xml -->
<xsl:param name="genConfig" />

<xsl:output method = "xml" omit-xml-declaration = "yes" indent = "yes" encoding = "UTF-8"/>

<xsl:strip-space elements="*" />

<xsl:template match="/">
    <xsl:apply-templates/>
</xsl:template>

<xsl:template match="modify">
  <xsl:call-template name="page">
    <xsl:with-param name="title">Modify <xsl:value-of select="//@name"/></xsl:with-param>
    <xsl:with-param name="nextPage">view</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template name="pageContent">
  <table border="0" cellpadding="3" cellspacing="0" width="100%">
    <tr>
      <td align="left" valign="top" width="21%">
         <xsl:choose>
		<xsl:when test="//@displayname">
			<b><font size="+3">Modify <xsl:value-of select="//@displayname"/></font></b> 
		</xsl:when>
		<xsl:otherwise>
			<b><font size="+3">Modify <xsl:value-of select="//@name"/></font></b> 
		</xsl:otherwise>
	   </xsl:choose>	
      </td>
      <td align="left" valign="top" width="16%">
        <xsl:call-template name="buildAnimatedCommit" />
      </td>
      <td align="left" valign="top" width="15%">
        <xsl:call-template name="buildAnimatedAbort">
          <xsl:with-param name="nextPage">view</xsl:with-param>
        </xsl:call-template>
      </td>
      <td align="right" valign="top" width="42%">
        <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
      </td>
    </tr>
    <tr>
      <td colspan="3">
        <b>Please <font color="#FF6300">confirm modifications</font> by pressing the commit button.</b>
      </td>
	<xsl:if test="//@explanation='true'">
      <td>
        <font size="-1">Pressing <img src="/images/addButton.gif" width="64" height="20" border="0" /> adds a new entry at the bottom.<br/></font>
        <font size="-1">Pressing <img src="/images/delete.gif" width="18" height="16" border="0" /> deletes an entry.</font>
      </td>
	</xsl:if>
    </tr>
    <tr>
      <td colspan="4">
        <!-- ****************** BEGIN DYNAMIC PART ********************* -->
        <table border="0" cellpadding="0" cellspacing="0" width="100%">
          <xsl:apply-templates select="heading"/>
          <xsl:apply-templates select="field"/>
        </table>
        <!-- ****************** END DYNAMIC PART *********************** -->
      </td>
    </tr>
  </table>
</xsl:template>

<!-- ********** Generates a heading for the top level elements ********** -->
<xsl:template match="modify/heading">
  <xsl:call-template name="buildTopLevelHeading" />
</xsl:template>

<!-- ********** Generates a heading inside a heading directly at top level ********** -->
<xsl:template match="modify/heading/heading">
  <xsl:call-template name="buildHeadingOfTopLevelHeading" />
</xsl:template>

<!-- ********** Generates a heading in a deeper level ********** -->
<xsl:template match="modify/heading/*//heading">
  <xsl:param name="indent">0</xsl:param>
    
  <xsl:call-template name="buildDeeperLevelHeadings">
    <xsl:with-param name="indent" select="$indent" />
  </xsl:call-template>
</xsl:template>

<!-- ********* Generates the loop tag for occurring elements ********** -->
<xsl:template match="modify//loop">
  <xsl:param name="indent">0</xsl:param>
  
  <xsl:call-template name="buildLoop">
    <xsl:with-param name="indent" select="$indent"/>
    <xsl:with-param name="pageName" select="string('modify')" />
    <xsl:with-param name="isModifiable" select="true()" />
  </xsl:call-template>
</xsl:template>

<!-- ********** Processes a choice ********** -->
<xsl:template match="modify//choice">
  <xsl:param name="indent">0</xsl:param>
   
  <xsl:call-template name="buildChoice">
    <xsl:with-param name="indent" select="$indent"/>
    <xsl:with-param name="isModifiable" select="true()"/>
  </xsl:call-template>
</xsl:template>

<!-- ********** Processes a setchoice ********** -->
<xsl:template match="modify//setchoice">
  <xsl:param name="indent">0</xsl:param>
  
  <xsl:call-template name="buildSetChoice">
    <xsl:with-param name="indent" select="$indent" />
    <xsl:with-param name="pageName" select="string('modify')" />
  </xsl:call-template>
</xsl:template>


<!-- ********* Generates output for simple elements ********** -->
<xsl:template match="modify//field">
  <xsl:param name="indent">0</xsl:param>
  
  <xsl:call-template name="buildField">
    <xsl:with-param name="indent" select="$indent" />
    <xsl:with-param name="pageName" select="string('create')" />
    <xsl:with-param name="isModifiable" select="true()" />
  </xsl:call-template>
</xsl:template>

</xsl:stylesheet>

