<!-- *** Copyright (c) 2001 - 2003 Software AG. All Rights Reserved. *** -->
<!-- *** Version: $Revision: 1.11 $                           *** -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xapp="http://www.softwareag.com/xtools/xapplication"
                xmlns="http://www.w3.org/1999/xhtml" version="1.0">
  <!--
    ** Prints common page containing the enclosing table with links to the
    ** create page and search page. When invoking this template it requires
    ** a template with name 'pageContent' that defines a table with the page
    ** specific content.
    **
    ** @param title     html title of the page
    ** @param nextPage  name of the next jsp page when the html form is submitted.
    ** @param simple    indicates whether this is a simple code file
    ** @param action    indicates the action such as delete etc.
    -->
  <xsl:template name="page">
    <xsl:param name="title" />
    <xsl:param name="nextPage" />
    <xsl:param name="simple"/>
    <xsl:param name="action"/>
  
    <xsl:call-template name="buildCommonHeader" />
    
    <html>
      <xsl:call-template name="buildHtmlHeader">
        <xsl:with-param name="title" select="$title" />
      </xsl:call-template>

<!-- add three script elements. 1. Animation of action buttons on screen 	anim.js
     2. General validation functions to be used by all or most pages 		valgen.js
     3. Specific validation for each schema						validations.js -->

      <!-- TODO: check the reason why the page is not displayed if the following
           script tag is included. -->
        <script language="JavaScript" src="/scripts/anim.js" type="text/javascript">
<!-- need to put this blank space in otherwise the script tag is created as en empty element
     and the IE 6 browser does not show the page (as per TODO note above) -->
		<xsl:text> </xsl:text>
        </script>
        <script language="JavaScript" src="/scripts/valgen.js" type="text/javascript">
		<xsl:text> </xsl:text>
        </script>

	  <xsl:choose>
         <xsl:when test="$action='delete'">
           <script language="JavaScript" src="/scripts/valdelete.js" type="text/javascript">
 		<xsl:text> </xsl:text>
           </script>
         </xsl:when>
         <xsl:otherwise>
	      <script language="JavaScript" src="validations.js" type="text/javascript">
	 	<xsl:text> </xsl:text>
            </script>
         </xsl:otherwise>
        </xsl:choose>


<!-- If this is a simple code file, then the search page should not be displayed -->

        <xsl:if test="$simple='true'">
            <SCRIPT FOR="window" EVENT="onload">
		    document.form1.submit();
		</SCRIPT>
        </xsl:if>
      
	<body bgcolor="#FFFFFF"  topmargin="0" leftmargin="0" bottommargin="0" style="font-family:Arial">      
	<xapp:module>
        <form name="form1" method="post">
          <xsl:attribute name="action">
            <xsl:apply-templates select="$genConfig//application">
              <xsl:with-param name="page" select="$nextPage" />
            </xsl:apply-templates>
          </xsl:attribute>
        <xapp:form>
          <xsl:call-template name="buildDocAttribute" />

<!-- If this is a simple code file, then the search page should have a directcommand -->

        <xsl:if test="$simple='true'">
          <xsl:call-template name="buildSimpleSearchDirectCommand" />
        </xsl:if>

        <table border="0" cellpadding="0" cellspacing="0" width="100%">
          <tr><td colspan="3"><img src="/images/ddnewpic.bmp"/></td></tr>
		<tr>
		<td valign="top" bgcolor="#AAB7AC"><img width="10" src="/images/ddline2a.jpg" height="376"/></td>
		<td width="150" valign="top" bgcolor="#AAB7AC" align="left">
<!-- Links to the home pages -->
              <table border="0" cellpadding="0" cellspacing="3" width="150">
			<tr>
				<td valign="top" colspan="2" align="left">
					<b><a href="/SDL/index.htm"><font size="+2">Home</font></a></b>
				</td>
			</tr>
			<tr>
				<td valign="top" colspan="2" align="left">
					<a href="/SDL/admin.htm"><li>Admin Home</li></a>
				</td>
			</tr>
			<tr>
				<td valign="top" colspan="2" align="left">
					<a href="/SDL/sdf.htm"><li>SDF Home</li></a>
				</td>
			</tr>
			<tr>
				<td valign="top" colspan="2" align="left">
					<a href="/SDL/manager.htm"><li>Manager Home</li></a>
				</td>
			</tr>							
             </table>
		<p></p>
		<br/><br/><br/>
              <!-- cell which contains the link to the search and the create page -->
              <table border="0" cellpadding="0" cellspacing="3" width="150">
                <tr>
                  <td align="left" colspan="2" valign="top">
                    <b>
                      <a>
                        <xsl:attribute name="href">
                          <xsl:apply-templates select="$genConfig//application">
                            <xsl:with-param name="page">search</xsl:with-param>
                          </xsl:apply-templates>
                        </xsl:attribute>
                        <font size="+2">Search</font>
                      </a>
                    </b>
                  </td>
                </tr>
                <tr>
                  <td align="left" colspan="2" valign="top">
                    <b><xsl:call-template name="buildCreateLink" /></b>
                  </td>
                </tr>
		 </table>
            </td>
            <td bgcolor="#ffffff" valign="top" width="100%">
              <!-- cell page specific content -->
              <xsl:call-template name="pageContent" />
            </td>
          </tr>
        </table>
      
        </xapp:form>
        </form>
      </xapp:module>
      </body>
    </html>
  </xsl:template>
  
  <xsl:template name="buildAnimatedCommit">
    <xsl:param name="nextPage" select="string('')"/>
    
    <xapp:action type="commit" form="form1">
      <a  onMouseOut="MM_nbGroup('out');" onMouseOver="MM_displayStatusMsg('Commit changes');MM_nbGroup('over','commit_r2_c2','/images/commit_r2_c2_f2.gif','/images/commit_r2_c2_f4.gif',1);return document.MM_returnValue"  onclick2="MM_nbGroup('down','navbar1','commit_r2_c2','/images/commit_r2_c2_f3.gif',1);" >
<!--        <xsl:attribute name="href"><xsl:value-of select="$nextPage" /></xsl:attribute>-->
<!-- to ensure that the commit will first do the client side validations -->
        <xsl:attribute name="href">javascript:mySubmit();</xsl:attribute>
        <img name="commit_r2_c2" src="/images/commit_r2_c2.gif" border="0" alt="commit" />
      </a>
    </xapp:action>
  </xsl:template>
  
  <xsl:template name="buildAnimatedAbort">
    <xsl:param name="nextPage" />
    
    <xapp:action type="abandon" form="form1">
      <a onMouseOut="MM_nbGroup('out');" onMouseOver="MM_displayStatusMsg('abandon');MM_nbGroup('over','abandon_r2_c2','/images/abandon_r2_c2_f2.gif','/images/abandon_r2_c2_f4.gif',1);return document.MM_returnValue"  onclick2="MM_nbGroup('down','navbar1','abandon_r2_c2','/images/abandon_r2_c2_f3.gif',1);" >
        <xsl:attribute name="href"><xsl:value-of select="$nextPage" />.jsp</xsl:attribute>
        <img name="abandon_r2_c2" src="/images/abandon_r2_c2.gif" border="0" alt="commit" />
      </a>
    </xapp:action>
  </xsl:template>
  
  <xsl:template name="buildConfirmationRow">
    <tr>
      <td colspan="3">
        <b>Please <font color="#FF6300">confirm creation</font> by pressing the commit button.</b>
      </td>
	<xsl:if test="//@explanation='true'">
      <td>
        <font size="-1">Pressing <img src="/images/addButton.gif" width="64" height="20" border="0" /> adds a new entry at the bottom.<br/></font>
        <font size="-1">Pressing <img src="/images/delete.gif" width="18" height="16" border="0" /> deletes an entry.</font>
      </td>
	</xsl:if>
    </tr>
  </xsl:template>
  
  <!--
    ** Prints common header for a generated file
    -->
  <xsl:template name="buildCommonHeader">
    <xsl:text disable-output-escaping="yes">&lt;!-- *** Generated by Tamino X-Application *** --&gt;</xsl:text>
    
    <xsl:text disable-output-escaping="yes">
      &lt;!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"&gt;
    
      &lt;%@ page language="java" contentType="text/html; charset=UTF-8"  errorPage="Error.jsp"%&gt;
      &lt;%@ taglib uri="http://www.softwareag.com/xtools/xapplication" prefix="xapp" %&gt;
    </xsl:text>
  </xsl:template>
  
  <!--
    ** Prints out the HTML tag 'head'
    **
    ** @param title     content of the head's title tag
    -->
  <xsl:template name="buildHtmlHeader">
    <xsl:param name="title" />
    <head>
      <title><xsl:value-of select="$title" /></title>
      <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
      <style type="text/css">
          .link {
            COLOR: #000000; FONT-WEIGHT: bold; TEXT-DECORATION: none
          }
          A {
            COLOR: #000000; FONT-WEIGHT: bold; TEXT-DECORATION: none
          }
          A:link {
            FONT-WEIGHT: bold
          }
          A:hover {
            COLOR: #000000; FONT-WEIGHT: bold; TEXT-DECORATION: underline
          }
      </style>
    </head>
  </xsl:template>
  
  <!--
    ** Prints out the HTML tag 'form'
    **
    ** @param action     content of the forms's action attribute
    -->
  <xsl:template name="buildHtmlForm">
    <xsl:param name="title" />
    <head>
      <title><xsl:value-of select="$title" /></title>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <style type="text/css">
          .link {
            COLOR: #000000; FONT-WEIGHT: bold; TEXT-DECORATION: none
          }
          A {
            COLOR: #000000; FONT-WEIGHT: bold; TEXT-DECORATION: none
          }
          A:link {
            FONT-WEIGHT: bold
          }
          A:hover {
            COLOR: #000000; FONT-WEIGHT: bold; TEXT-DECORATION: underline
          }
        </style>
    </head>
  </xsl:template>
  
  <!--
    ** Returns the name of the jspFile, in order to create a link ***
    -->
  <xsl:template match="application">
    <xsl:param name="page">default</xsl:param>
    
    <xsl:for-each select="page">
      <xsl:if test="contains(@xsl, concat($page,'.xsl'))">
         <xsl:value-of select="@jsp"/>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>
  
  <!--
    ** Prints out the xapp:action that links to the create page
    -->
  <xsl:template name="buildCreateLink">
    <xapp:action type="create">
      <xsl:attribute name="schema"><xsl:call-template name="getDoctype"/></xsl:attribute>
      <xsl:attribute name="collection">${<xsl:value-of select="$appConfig//collection/@variable" />$}</xsl:attribute>
      <xsl:call-template name="buildDocAttribute" />
      <a>
        <xsl:attribute name="href">
          <xsl:apply-templates select="$genConfig//application">
            <xsl:with-param name="page">create</xsl:with-param>
          </xsl:apply-templates>
        </xsl:attribute>
        <font size="+2">Create</font>
      </a>
    </xapp:action>
  </xsl:template>
  
  <!-- templates for the page content -->

  <!--
    ** Generates a heading for the top level elements
    -->
  <xsl:template name="buildTopLevelHeading">
    <xsl:param name="indent">0</xsl:param>
    
    <tr bgcolor="#859687">
      <td>
        <b><font color="#000000"><xsl:value-of select="@name"/></font></b>
      </td>
    </tr>
    <xsl:apply-templates select="field"/>
    <xsl:apply-templates select="loop">
      <xsl:with-param name="indent" select="$indent + 5" />
    </xsl:apply-templates>
    <xsl:apply-templates select="choice">
      <xsl:with-param name="indent" select="$indent + 5" />
    </xsl:apply-templates>
    <xsl:apply-templates select="heading">
      <xsl:with-param name="indent" select="$indent + 5" />
    </xsl:apply-templates>
  </xsl:template>
  
  <!--
    ** Loop equivalent which produces indent whitespace chars
    ** Since there's no loop in XSL this recursive function is used to resemble the
    ** behaviour of a for loop
    -->
  <xsl:template name="spacer">
    <xsl:param name="indent">0</xsl:param>
    
    <xsl:if test="$indent > 0">
       <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
       <xsl:call-template name="spacer">
          <xsl:with-param name="indent"><xsl:value-of select="$indent - 1"/></xsl:with-param>
       </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <!--
    ** Generates a heading inside a heading directly at top level
    -->
  <xsl:template name="buildHeadingOfTopLevelHeading">
    <xsl:param name="indent">0</xsl:param>
    
    <tr bgcolor="#859687">
      <td>
        <xsl:call-template name="spacer">
          <xsl:with-param name="indent" select="$indent" />
        </xsl:call-template>
        <xsl:value-of select="@name"/>
      </td>
    </tr>
    <xsl:apply-templates select="field" />
    <xsl:apply-templates select="heading">
      <xsl:with-param name="indent" select="$indent + 5" />
    </xsl:apply-templates>
    <xsl:apply-templates select="loop">
      <xsl:with-param name="indent" select="$indent + 5" />
    </xsl:apply-templates>
    <xsl:apply-templates select="choice">
      <xsl:with-param name="indent" select="$indent" />
    </xsl:apply-templates>
  </xsl:template>
  
  <!--
    ** Prints out heading of the third level.
    -->
  <xsl:template name="buildDeeperLevelHeadings">
    <xsl:param name="indent">0</xsl:param>
    
    <tr bgcolor="#AAB7AC">
      <td>
        <xsl:call-template name="spacer">
          <xsl:with-param name="indent" select="$indent"/>
        </xsl:call-template>
        <xsl:choose>
          <xsl:when test="local-name(..)='choice'">
            <b><xsl:value-of select="@name"/></b>
          </xsl:when>
          <xsl:otherwise>
            <b><xsl:value-of select="@name"/></b>
          </xsl:otherwise>
        </xsl:choose>
      </td>
    </tr>
    
    <xsl:apply-templates select="field"/>
    <xsl:apply-templates select="heading">
      <xsl:with-param name="indent" select="$indent + 5" />
    </xsl:apply-templates>
    <xsl:apply-templates select="loop">
      <xsl:with-param name="indent" select="$indent + 5" />
    </xsl:apply-templates>
    <xsl:apply-templates select="choice">
      <xsl:with-param name="indent" select="$indent" />
    </xsl:apply-templates>
  </xsl:template>
  
  <!--
    ** Prints out an xapp:loop tag
    -->
  <xsl:template name="buildLoop">
    <xsl:param name="indent">0</xsl:param>
    <xsl:param name="pageName" />
    <xsl:param name="isModifiable" />
    
    <xsl:choose>
      <xsl:when test="string(@option) = string('true')">
        <xsl:call-template name="buildOptional">
          <xsl:with-param name="indent" select="$indent" />
          <xsl:with-param name="pageName" select="$pageName" />
          <xsl:with-param name="isModifiable" select="$isModifiable" />
        </xsl:call-template>
      </xsl:when>
      <xsl:when test="@table='true'">
          <xsl:choose>
		<xsl:when test="@modifyNewPage">
        	  <xsl:call-template name="buildTable">
                 <xsl:with-param name="pageName" select="$pageName" />
                 <xsl:with-param name="tableModifiable" select="false()" />
                 <xsl:with-param name="isModifiable" select="$isModifiable" />
                 <xsl:with-param name="modifyNewPage" select="@modifyNewPage" />
              </xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
        	  <xsl:call-template name="buildTable">
                 <xsl:with-param name="pageName" select="$pageName" />
                <xsl:with-param name="tableModifiable" select="$isModifiable" />
                <xsl:with-param name="isModifiable" select="$isModifiable" />
                 <xsl:with-param name="modifyNewPage" select="@modifyNewPage" />
              </xsl:call-template>
		</xsl:otherwise>
	    </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="buildRealLoop">
          <xsl:with-param name="indent" select="$indent" />
          <xsl:with-param name="pageName" select="$pageName" />
          <xsl:with-param name="isModifiable" select="$isModifiable" />
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
    
  <!--
    **
    -->
  <xsl:template name="buildRealLoop">
    <xsl:param name="indent" select="number(0)" />
    <xsl:param name="pageName" select="string('')" />
    <xsl:param name="isModifiable" select="false()" />
    
    <xapp:loop>
      <!-- attributes of the loop tag -->
      <xsl:call-template name="buildDocAttribute" />
      <xsl:attribute name="select">
        <xsl:choose>
          <xsl:when test="@select">
            <xsl:value-of select="@select"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="string('.')"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
      <xsl:if test="@extselect">
        <xsl:attribute name="extselect"><xsl:value-of select="@extselect"/></xsl:attribute>
      </xsl:if>
      <xsl:if test="@iterate">
        <xsl:attribute name="iterate"><xsl:value-of select="@iterate"/></xsl:attribute>
      </xsl:if>
      <xsl:if test="@base">
        <xsl:attribute name="base"><xsl:value-of select="@base"/></xsl:attribute>
      </xsl:if>
      <xsl:attribute name="targetbase"><xsl:value-of select="@targetbase"/></xsl:attribute>
      
	<xsl:if test="not(field/@remove-option='true')">
      <tr bgcolor="#EEEEEE">
        <td>
          <xsl:call-template name="spacer">
            <xsl:with-param name="indent" select="$indent" />
          </xsl:call-template>
          <xapp:display select="$POS" />. <xsl:value-of select="@name"/>
          <xsl:if test="$isModifiable">
            <xapp:if condition="isRemovable">
              <xapp:elementaction type="remove" form="form1">
                <a>
                  <xsl:attribute name="href">
                    <xsl:call-template name="buildJavaScript">
                      <xsl:with-param name="actionPage" select="$pageName" />
                    </xsl:call-template>
                  </xsl:attribute>
                  <img src="/images/delete.gif" width="18" height="16" border="0" />
                </a>
              </xapp:elementaction>
            </xapp:if>
          </xsl:if>
        </td>
      </tr>
	</xsl:if>
      
      <xsl:apply-templates select="field"/>
      <xsl:apply-templates select="loop">
        <xsl:with-param name="indent" select="$indent + 5"/>
      </xsl:apply-templates>
      <xsl:apply-templates select="choice">
        <xsl:with-param name="indent" select="$indent"/>
      </xsl:apply-templates>
      <xsl:apply-templates select="heading">
        <xsl:with-param name="indent" select="$indent + 5"/>
      </xsl:apply-templates>
    </xapp:loop>
    
    <xsl:if test="$isModifiable">
      <tr bgcolor="#EEEEEE">
        <td>
          <xsl:call-template name="spacer">
            <xsl:with-param name="indent" select="$indent"/>
          </xsl:call-template>
          <xapp:elementaction type="insertAfter" form="form1">
            <xsl:attribute name="base"><xsl:value-of select="@targetbase"/></xsl:attribute>
            <a>
              <xsl:attribute name="href">
                <xsl:call-template name="buildJavaScript">
                  <xsl:with-param name="actionPage" select="$pageName" />
                </xsl:call-template>
              </xsl:attribute>
              <img src="/images/addButton.gif" width="64" height="20" border="0" />
             </a>
          </xapp:elementaction>
          <xsl:call-template name="spacer">
            <xsl:with-param name="indent" select="$indent"/>
          </xsl:call-template>
          <xsl:value-of select="@name"/>
        </td>
      </tr>
    </xsl:if>
  </xsl:template>
  
  <!--
    ** Print out an if statement around the context node
    -->
  <xsl:template name="buildOptional">
    <xsl:param name="indent">0</xsl:param>
    <xsl:param name="pageName" />
    <xsl:param name="isModifiable" />
    
    <xapp:loop>
      <!-- attributes of the loop tag -->
      <xsl:call-template name="buildDocAttribute" />
      <xsl:attribute name="select">
        <xsl:choose>
          <xsl:when test="@select">
            <xsl:value-of select="@select"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="string('.')"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
      <xsl:if test="@extselect">
        <xsl:attribute name="extselect"><xsl:value-of select="@extselect"/></xsl:attribute>
      </xsl:if>
      <xsl:if test="@iterate">
        <xsl:attribute name="iterate"><xsl:value-of select="@iterate"/></xsl:attribute>
      </xsl:if>
      <xsl:if test="@base">
        <xsl:attribute name="base"><xsl:value-of select="@base"/></xsl:attribute>
      </xsl:if>
      <xsl:attribute name="targetbase"><xsl:value-of select="@targetbase"/></xsl:attribute>
      
      <xsl:if test="$isModifiable">
        <tr bgcolor="#EEEEEE">
          <td>
            <xsl:call-template name="spacer">
              <xsl:with-param name="indent" select="$indent"/>
            </xsl:call-template>
            <xsl:value-of select="@name" />
            <xapp:elementaction type="remove" select="." form="form1">
              <a>
                <xsl:attribute name="href">
                  <xsl:call-template name="buildJavaScript">
                    <xsl:with-param name="actionPage" select="$pageName" />
                  </xsl:call-template>
                </xsl:attribute>
                <img src="/images/delete.gif" width="18" height="16" border="0" />
              </a>
            </xapp:elementaction>
          </td>
        </tr>
      </xsl:if>
      <xsl:call-template name="walkContent">
        <xsl:with-param name="indent" select="$indent" />
      </xsl:call-template>
    </xapp:loop>
    <xsl:if test="$isModifiable">
      <xapp:if condition="notexist">
        <xsl:attribute name="select">
          <xsl:choose>
            <xsl:when test="@select">
              <xsl:value-of select="@select"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="string('.')"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:attribute>
        <xsl:if test="@extselect">
          <xsl:attribute name="extselect"><xsl:value-of select="@extselect"/><xsl:text>/xapp:child(1)</xsl:text></xsl:attribute>
        </xsl:if>
        <xsl:if test="@base">
          <xsl:attribute name="base"><xsl:value-of select="@base"/></xsl:attribute>
        </xsl:if>
        
        <tr bgcolor="#EEEEEE">
          <td>
            <xsl:call-template name="spacer">
              <xsl:with-param name="indent" select="$indent"/>
            </xsl:call-template>
            <xsl:value-of select="@name" />
            <xapp:elementaction type="insertAfter" form="form1">
              <xsl:attribute name="base"><xsl:value-of select="@targetbase"/></xsl:attribute>
                
              <a>
                <xsl:attribute name="href">
                  <xsl:call-template name="buildJavaScript">
                    <xsl:with-param name="actionPage" select="$pageName" />
                  </xsl:call-template>
                </xsl:attribute>
                <img src="/images/addButton.gif" width="64" height="20" border="0" />
              </a>
            </xapp:elementaction>
          </td>
        </tr>
      </xapp:if>
    </xsl:if>
  </xsl:template>
  
  <!--
    ** walk through the children of the current selected node
    -->
  <xsl:template name="walkContent">
    <xsl:param name="indent">0</xsl:param>
    
    <xsl:apply-templates select="field"/>
    <xsl:apply-templates select="loop">
      <xsl:with-param name="indent" select="$indent + 5"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="choice">
      <xsl:with-param name="indent" select="$indent"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="heading">
      <xsl:with-param name="indent" select="$indent + 5"/>
    </xsl:apply-templates>
  </xsl:template>
  
  <!--
    ** Prints out an xapp:choice tag
    -->
  <xsl:template name="buildChoice">
    <xsl:param name="indent">0</xsl:param>
    <xsl:param name="isModifiable" />
   
    <xsl:if test="count(.//loop) &gt; 0 or count(.//field) or count(.//heading) &gt; 0">
      <xapp:choice>
        <xsl:attribute name="select"><xsl:value-of select="@select" /></xsl:attribute>
        <xsl:if test="@extselect">
          <xsl:attribute name="extselect"><xsl:value-of select="@extselect" /></xsl:attribute>
        </xsl:if>
        <xsl:attribute name="type"><xsl:value-of select="@type" /></xsl:attribute>
     
        <xsl:apply-templates select="field"/>
        <xsl:apply-templates select="loop">
          <xsl:with-param name="indent" select="$indent + 5" />
        </xsl:apply-templates>
        <xsl:apply-templates select="choice">
          <xsl:with-param name="indent" select="$indent + 5" />
        </xsl:apply-templates>
   
        <xsl:apply-templates select="heading">
          <xsl:with-param name="indent" select="$indent + 5" />
        </xsl:apply-templates>
  
        <xsl:if test="$isModifiable">
          <tr bgcolor="#EEEEEE">
            <td>
              <xsl:call-template name="spacer">
                <xsl:with-param name="indent" select="$indent + 5" />
              </xsl:call-template>
              Switch to
              <xsl:apply-templates select="setchoice">
                <xsl:with-param name="indent" select="$indent + 5" />
              </xsl:apply-templates>
            </td>
          </tr>
        </xsl:if>
      </xapp:choice>
    </xsl:if>
  </xsl:template>
  
  <!--
    ** Prints out an xapp:setchoice tag
    -->
  <xsl:template name="buildSetChoice">
    <xsl:param name="indent">0</xsl:param>
    <xsl:param name="pageName" />
    
    <xapp:setchoice form="form1">
      <xsl:attribute name="select"><xsl:value-of select="@select" /></xsl:attribute>
      <xsl:if test="@extselect">
        <xsl:attribute name="extselect"><xsl:value-of select="@extselect" /></xsl:attribute>
      </xsl:if>
      <xsl:attribute name="type"><xsl:value-of select="@type" /></xsl:attribute>

      <a>
        <xsl:attribute name="href">
          <xsl:call-template name="buildJavaScript">
            <xsl:with-param name="actionPage" select="$pageName" />
          </xsl:call-template>
        </xsl:attribute>
        <font color="darkblue"><xsl:value-of select="@type"/></font>
      </a>
    </xapp:setchoice>
  </xsl:template>
  
  <!--
    ** Prints out an xapp:display or xapp:edit tag
    -->
  <xsl:template name="buildField">
    <xsl:param name="indent" select="number(0)" />
    <xsl:param name="pageName" select="string('')" />
    <xsl:param name="isModifiable" select="false()" />
   
    <xsl:for-each select=".">
      <xsl:choose>
        <xsl:when test="boolean(@optionAttr) and (string(@optionAttr) = 'true')">
          <xapp:if condition="exist" select="{@select}">
            <xsl:if test="$isModifiable">
              <tr bgcolor="#EEEEEE" >
                <td>
                  <xsl:call-template name="spacer">
                    <xsl:with-param name="indent" select="$indent"/>
                  </xsl:call-template>
                  <xsl:value-of select="@name" />
                  <xapp:elementaction type="remove" select="{@select}" form="form1">
                    <a>
                      <xsl:attribute name="href">
                        <xsl:call-template name="buildJavaScript">
                          <xsl:with-param name="actionPage" select="$pageName" />
                        </xsl:call-template>
                      </xsl:attribute>
                      <img src="/images/delete.gif" width="18" height="16" border="0" />
                    </a>
                  </xapp:elementaction>
                </td>
              </tr>
            </xsl:if>
            <xsl:call-template name="buildRealField">
              <xsl:with-param name="isModifiable" select="$isModifiable" />
              <xsl:with-param name="pageName" select="$pageName" />
            </xsl:call-template>
          </xapp:if>
          <xsl:if test="$isModifiable">
            <xapp:if condition="notexist" select="{@select}">
              <tr bgcolor="#EEEEEE" >
                <td>
                  <xsl:call-template name="spacer">
                    <xsl:with-param name="indent" select="$indent"/>
                  </xsl:call-template>
                  <xsl:value-of select="@name" />
                  <xapp:elementaction type="addAttribute" select="{@elem}" form="form1">
                    <xsl:attribute name="arg"><xsl:value-of select="substring-after(@select, string('/@'))" /></xsl:attribute>
                    <a>
                      <xsl:attribute name="href">
                        <xsl:call-template name="buildJavaScript">
                          <xsl:with-param name="actionPage" select="$pageName" />
                        </xsl:call-template>
                      </xsl:attribute>
                      <img src="/images/addButton.gif" width="64" height="20" border="0" />
                    </a>
                  </xapp:elementaction>
                </td>
              </tr>
            </xapp:if>
          </xsl:if>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="buildRealField">
            <xsl:with-param name="isModifiable" select="$isModifiable" />
            <xsl:with-param name="pageName" select="$pageName" />
          </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:for-each>
  </xsl:template>
  
  <xsl:template name="buildRealField">
    <xsl:param name="isModifiable" />
    <xsl:param name="pageName" /> 
  
      <tr bgcolor="#EEEEEE" >
      <td>
        <table border="0" cellpadding="0" cellspacing="0" width="100%">
            <tr bgcolor="#EEEEEE" cellpadding="0">
		<xsl:if test="not(@remove-option='true')">
              <td align="left" valign="top" width="28%" height="12">
                <div align="right">
                  <b><font color="#000000"><xsl:value-of select="@name"/></font></b>
                </div>
              </td>
             </xsl:if>
		<xsl:if test="@remove-option='true'">
              <td align="left" valign="top" width="28%" height="12">
                <div align="right">
			 <b><font color="#000000"><xapp:display select="$POS" />. <xsl:value-of select="@name"/></font></b>
                </div>
              </td>
             </xsl:if>
              <td align="left" valign="top" height="12" width="1%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></td>
              <td align="left" valign="top" height="12" width="43%">
                <xsl:choose>
                  <xsl:when test="$isModifiable">
			<xsl:choose>
			  <xsl:when test="@radio='true'">
				<xsl:call-template name="buildRadioButton"/>
			  </xsl:when>
			  <xsl:when test="@remove-option='true'">
  				<xsl:call-template name="buildRemoveOptionField">
			            <xsl:with-param name="isModifiable" select="$isModifiable" />
			            <xsl:with-param name="pageName" select="$pageName" />
				</xsl:call-template>
			  </xsl:when>                   
                    <xsl:otherwise>
                    <xapp:edit>
                      <xsl:attribute name="select"><xsl:value-of select="@select"/></xsl:attribute>
                      <xsl:if test="@rawcontent">
                        <xsl:attribute name="rawcontent"><xsl:value-of select="@rawcontent"/></xsl:attribute>
                      </xsl:if>
                    
                      <xsl:choose>
                        <xsl:when test="@rawcontent">
                          <textarea rows="6" cols="30"/>
                        </xsl:when>
				<xsl:when test="@dropdowntext">
					<xsl:call-template name="buildOptionsList"/>
				</xsl:when>
                        <xsl:otherwise>
                          <input type="text" size="20"/>
                        </xsl:otherwise>
                      </xsl:choose>
                    </xapp:edit>
			  </xsl:otherwise>
			</xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xapp:display>
                      <xsl:attribute name="select"><xsl:value-of select="@select" /></xsl:attribute>
                      <xsl:if test="@rawcontent">
                        <xsl:attribute name="rawcontent"><xsl:value-of select="@rawcontent" /></xsl:attribute>
                      </xsl:if>
                    </xapp:display>
                  </xsl:otherwise>
                </xsl:choose>
              </td>
              <td align="left" valign="top" height="12" width="28%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></td>
            </tr>
        </table>
      </td>
    </tr>
  </xsl:template>
  
  <!--
    ** Prints out the JavaScript text for a href attribute of a hyperlink
    -->
  <xsl:template name="buildJavaScript">
    <xsl:param name="actionPage" />
    
    <xsl:variable name="page">
      <xsl:apply-templates select="$genConfig//application">
        <xsl:with-param name="page" select="$actionPage" />
      </xsl:apply-templates>
    </xsl:variable>
    <xsl:text disable-output-escaping="yes">javascript:document.forms['form1'].action='</xsl:text><xsl:value-of select="$page" /><xsl:text disable-output-escaping="yes">';document.forms['form1'].submit();</xsl:text>
  </xsl:template>
  
  <!--
    ** Returns the 'document' attribute with reference to the list of queried documents
    -->
  <xsl:template name="buildDocListAttribute">
    <xsl:attribute name="document"><xsl:call-template name="buildDocListName" /></xsl:attribute>
  </xsl:template>
  
  <xsl:template name="buildDocListName">
    <xsl:value-of select="/XAppGenWeb/@name" /><xsl:text>DocList</xsl:text>
  </xsl:template>
  
  <!--
    ** Returns the 'document' attribute with reference to the currently selected document
    -->
  <xsl:template name="buildDocAttribute">
    <xsl:attribute name="document"><xsl:value-of select="/XAppGenWeb/@name" />Document</xsl:attribute>
  </xsl:template>
  <xsl:template name="buildTargetDocAttribute">
    <xsl:attribute name="targetdocument"><xsl:value-of select="/XAppGenWeb/@name" />Document</xsl:attribute>
  </xsl:template>
  
  <!--
    ** Returns the doctype for this application
    -->
  <xsl:template name="getDoctype">
    <xsl:variable name="ns" select="/XAppGenWeb/@namespace" />
    
    <xsl:if test="boolean($ns)">
      <xsl:variable name="prefix" select="$appConfig/xapplication/namespaces/namespace[@uri=$ns]/@prefix" />
      <xsl:if test="boolean($prefix)"><xsl:value-of select="$prefix" />:</xsl:if>
    </xsl:if>
    <xsl:value-of select="/XAppGenWeb/@name" />
  </xsl:template>

<!-- template to build a drop down list : E Jacobs -->
<xsl:template name="buildOptionsList">
   <xapp:select collection="sdl" distinct="true">
	<xsl:attribute name="text"><xsl:value-of select="@dropdowntext"/></xsl:attribute>
      <xsl:if test="@dropdownvalue">
	   <xsl:attribute name="value"><xsl:value-of select="@dropdownvalue"/></xsl:attribute>
      </xsl:if>
	<select>
	<xsl:attribute name="name"><xsl:value-of select="@dropdownname"/></xsl:attribute>
	</select>
</xapp:select>
</xsl:template>

<!-- template to build a radio button : E Jacobs -->
<xsl:template name="buildRadioButton">
<xsl:for-each select="radio">
 <xapp:edit>
 <xsl:attribute name="select"><xsl:value-of select="../@select"/></xsl:attribute>
 <input type="radio">
  <xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute>
 </input>
 </xapp:edit><xsl:value-of select="@name"/>
</xsl:for-each>
</xsl:template>

<!-- template to build the delete button next to an optional field : E Jacobs -->
<xsl:template name="buildRemoveOptionField">
<xsl:param name="isModifiable" />
<xsl:param name="pageName"/>
   <xsl:if test="$isModifiable">
      <xapp:if condition="isRemovable">
          <xapp:elementaction type="remove" form="form1">
              <a>
                 <xsl:attribute name="href">
                   <xsl:call-template name="buildJavaScript">
                    <xsl:with-param name="actionPage" select="$pageName" />
                  </xsl:call-template>
                 </xsl:attribute>
                 <img src="/images/delete.gif" width="18" height="16" border="0" />
              </a>
           </xapp:elementaction>
         </xapp:if>
   </xsl:if>
<xapp:edit>
  <xsl:attribute name="select"><xsl:value-of select="@select"/></xsl:attribute>
<input type="text" size="20"/>
</xapp:edit>
</xsl:template>


<!-- template to show recurring fields as a table E. Jacobs-->
<xsl:template name="buildTable">
<xsl:param name="pageName"/>
<xsl:param name="tableModifiable"/>
<xsl:param name="isModifiable"/>
<xsl:param name="modifyNewPage"/>

<tr><td>
  <table cellspacing="0" width="100%">

<!-- heading of the table -->
    <tr bgcolor="#AAB7AC">
	<td width="5%"> </td>
	  <xsl:for-each select="field">
	    <td><xsl:attribute name="width"><xsl:value-of select="@width"/></xsl:attribute>
		  <xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute>
		<b><xsl:value-of select="@name" /></b>
	    </td>
	   </xsl:for-each>
    </tr>

<!-- to get the recurring values build a forEach tag command -->
    <xapp:loop>
      <!-- attributes of the loop tag -->
      <xsl:call-template name="buildDocAttribute" />
      <xsl:attribute name="select">
        <xsl:choose>
          <xsl:when test="@select">
            <xsl:value-of select="@select"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="string('.')"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
      <xsl:if test="@extselect">
        <xsl:attribute name="extselect"><xsl:value-of select="@extselect"/></xsl:attribute>
      </xsl:if>
      <xsl:if test="@iterate">
        <xsl:attribute name="iterate"><xsl:value-of select="@iterate"/></xsl:attribute>
      </xsl:if>
      <xsl:if test="@base">
        <xsl:attribute name="base"><xsl:value-of select="@base"/></xsl:attribute>
      </xsl:if>
      <xsl:attribute name="targetbase"><xsl:value-of select="@targetbase"/></xsl:attribute>

	  <tr bgcolor="#EEEEEE">
    	   <xsl:choose>
	    <xsl:when test="$isModifiable">
	    <td width="5%" align="center">
            <xapp:if condition="isRemovable">
             <xapp:elementaction form="form1" type="remove">
                <a>
                  <xsl:attribute name="href">
                    <xsl:call-template name="buildJavaScript">
                      <xsl:with-param name="actionPage" select="$pageName" />
                    </xsl:call-template>
                  </xsl:attribute>
                  <img src="/images/delete.gif" border="0"/>
                 </a>
             </xapp:elementaction>
            </xapp:if>
<!-- only show the edit icon when the table values are not modifiable in the table -->
	      <xsl:if test="not($tableModifiable)">
             <xapp:elementaction form="form1" type="select">
                <a>
                  <xsl:attribute name="href">
                      <xsl:text disable-output-escaping="yes">javascript:document.forms['form1'].action='</xsl:text><xsl:value-of select="$modifyNewPage" /><xsl:text disable-output-escaping="yes">';document.forms['form1'].submit();</xsl:text>
                  </xsl:attribute>
                  <img src="/images/EditDetailDetail.gif" border="0"/>
                 </a>
             </xapp:elementaction>
            </xsl:if> 
          </td>
          </xsl:when>
          <xsl:otherwise>
	      <td width="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></td>
          </xsl:otherwise>
        </xsl:choose>
<!-- for each field build a column in the table get the width and alignment from the structure document -->
		<xsl:for-each select="field">
		   <td><xsl:attribute name="width"><xsl:value-of select="@width"/></xsl:attribute>
		       <xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute>
<!-- when modifiable create edit field, else only write value -->
                <xsl:choose>
                  <xsl:when test="$tableModifiable">
			<xsl:choose>
			  <xsl:when test="@radio='true'">
				<xsl:call-template name="buildRadioButton"/>
			  </xsl:when>
                    <xsl:otherwise>
                    <xapp:edit>
                      <xsl:attribute name="select"><xsl:value-of select="@select"/></xsl:attribute>
                      <xsl:if test="@rawcontent">
                        <xsl:attribute name="rawcontent"><xsl:value-of select="@rawcontent"/></xsl:attribute>
                      </xsl:if>
                      <xsl:choose>
                        <xsl:when test="@rawcontent">
                          <textarea rows="6" cols="30"/>
                        </xsl:when>
				<xsl:when test="@dropdowntext">
					<xsl:call-template name="buildOptionsList"/>
				</xsl:when>
                        <xsl:otherwise>
                          <input type="text" size="20"/>
                        </xsl:otherwise>
                      </xsl:choose>
                    </xapp:edit>
			  </xsl:otherwise>
			 </xsl:choose>
                   </xsl:when>
			  <xsl:otherwise>
			      <xapp:display>
			         <xsl:attribute name="select"><xsl:value-of select="@select" /></xsl:attribute>
                  	</xapp:display>
			   </xsl:otherwise>
			</xsl:choose>
		      </td>
		</xsl:for-each>
	  </tr>
	</xapp:loop>
<!-- create the add button at the end -->
      <xsl:if test="$isModifiable">
        <tr bgcolor="#EEEEEE">
        <td>
		<xsl:attribute name="colspan"><xsl:value-of select="count(field)+1"/></xsl:attribute>
        <xapp:elementaction type="insertAfter" form="form1">
             <xsl:attribute name="base"><xsl:value-of select="@targetbase"/></xsl:attribute>
<!-- if table is modifiable then add button invokes current page, else it invokes the createNewPage -->
             <xsl:choose>
               <xsl:when test="$tableModifiable">
                <a>
                  <xsl:attribute name="href">
                    <xsl:call-template name="buildJavaScript">
                      <xsl:with-param name="actionPage" select="$pageName" />
                    </xsl:call-template>
                  </xsl:attribute>
		      <img border="0" height="20" width="64" src="/images/addButton.gif"/>
                </a>
               </xsl:when>
               <xsl:otherwise> 
                <a>
                  <xsl:attribute name="href">
                      <xsl:text disable-output-escaping="yes">javascript:document.forms['form1'].action='</xsl:text><xsl:value-of select="$modifyNewPage" /><xsl:text disable-output-escaping="yes">';document.forms['form1'].submit();</xsl:text>
                  </xsl:attribute>
		      <img border="0" height="20" width="64" src="/images/addButton.gif"/>
                </a>
               </xsl:otherwise>
              </xsl:choose>
              </xapp:elementaction>
		  <xsl:value-of select="@name"/>
<!-- create a hidden field to contain the number of occurrences. 
	The ampersand values need to be replaced by lt and gt symbols after generation -->	
               <input name="occurCount" type="hidden"><xsl:attribute name="value">
			<xsl:text disable-output-escaping="yes">&lt;xapp:count target='loop0'/$gt;</xsl:text>		    
			</xsl:attribute>
               </input>
   	     </td>
	   </tr>
      </xsl:if>
    </table>
</td></tr>
</xsl:template>

</xsl:stylesheet>


