<!-- *** Copyright (c) 2001 - 2003 Software AG. All Rights Reserved. *** -->
<!-- *** Version: $Revision: 1.9 $                            *** -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xapp="http://www.softwareag.com/xtools/xapplication"
                xmlns="http://www.w3.org/1999/xhtml" version="1.0">
                
<xsl:import href="./basics.xsl" />

<!-- *** Definition of the stye sheet parameters -->
<!-- appConfig contains the content of the xapplication.xml  -->
<xsl:param name="appConfig" />
<!-- Contains the content of the config.xml -->
<xsl:param name="genConfig" />

<xsl:output method = "xml" omit-xml-declaration = "yes" indent = "yes" encoding = "UTF-8"/>


<xsl:strip-space elements="*" />

<xsl:template match="/">
   <xsl:apply-templates/>
</xsl:template>

<xsl:template match="view">
  <xsl:call-template name="page">
    <xsl:with-param name="title">View <xsl:value-of select="//@name"/></xsl:with-param>
    <xsl:with-param name="nextPage">view</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template name="pageContent">
  <table border="0" cellpadding="3" cellspacing="0" width="100%">
    <tr>
      <td align="left" valign="top" width="21%">
         <xsl:choose>
		<xsl:when test="//@displayname">
			<b><font size="+3"><xsl:value-of select="//@displayname"/></font></b> 
		</xsl:when>
		<xsl:otherwise>
			<b><font size="+3"><xsl:value-of select="//@name"/></font></b> 
		</xsl:otherwise>
	   </xsl:choose>	
      </td>
      <td align="center" valign="middle" width="16%">
        <xapp:action type="modify" form="form1">
          <a onMouseOut="MM_nbGroup('out');"
             onMouseOver="MM_displayStatusMsg('Modify');MM_nbGroup('over','modify_r2_c2','/images/modify_r2_c2_f2.gif','/images/modify_r2_c2_f4.gif',1);return document.MM_returnValue"
             onClick="MM_nbGroup('down','navbar1','modify_r2_c2','/images/modify_r2_c2_f3.gif',1);">
            <xsl:attribute name="href">
              <xsl:apply-templates select="$genConfig//application">
                <xsl:with-param name="page">modify</xsl:with-param>
              </xsl:apply-templates>
            </xsl:attribute>
            <img name="modify_r2_c2" src="/images/modify_r2_c2.gif" border="0" alt="modify"/>
          </a>
        </xapp:action>
      </td>
      <td align="center" valign="middle" width="15%">
        <xapp:action type="delete" form="form1">
          <a onMouseOut="MM_nbGroup('out');"
             onMouseOver="MM_displayStatusMsg('Delete');MM_nbGroup('over','delete_r2_c2','/images/delete_r2_c2_f2.gif','/images/delete_r2_c2_f4.gif',1);return document.MM_returnValue"
             onClick="MM_nbGroup('down','navbar1','delete_r2_c2','/images/delete_r2_c2_f3.gif',1);">
            <xsl:attribute name="href">
              <xsl:apply-templates select="$genConfig//application">
                <xsl:with-param name="page">delete</xsl:with-param>
              </xsl:apply-templates>
            </xsl:attribute>
            <img name="delete_r2_c2" src="/images/delete_r2_c2.gif" border="0" alt="delete"/>
          </a>
        </xapp:action>
      </td>
      <td align="center" valign="middle" width="42%">
        <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
      </td>
    </tr>
    <tr>
      <td colspan="4">
        <!-- ********************** BEGIN DYNAMIC PART ***************** -->
        <table border="0" cellpadding="0" cellspacing="0" width="100%">
          <xsl:apply-templates select="heading"/>
          <xsl:apply-templates select="field"/>
        </table>
        <!-- ********************** END DYNAMIC PART ******************* -->
      </td>
    </tr>
  </table>
</xsl:template>

<!-- ********** Generates a heading for top level elements ********** -->
<xsl:template match="view/heading">
  <xsl:call-template name="buildTopLevelHeading" />
</xsl:template>

<!-- ********** Generates a heading inside a heading directly at top level********** -->
<xsl:template match="view/heading/heading">
  <xsl:param name="indent">0</xsl:param>
  
  <xsl:call-template name="buildHeadingOfTopLevelHeading">
    <xsl:with-param name="indent" select="$indent" />
  </xsl:call-template>
</xsl:template>


<!-- ********** Generates a heading in a deeper level********** -->
<xsl:template match="view/heading/*//heading">
  <xsl:param name="indent">0</xsl:param>
    
  <xsl:call-template name="buildDeeperLevelHeadings">
    <xsl:with-param name="indent" select="$indent" />
  </xsl:call-template>
</xsl:template>

<!-- ********* Generates the loop tag for occurring elements ********** -->
<xsl:template match="view//loop">
  <xsl:param name="indent">0</xsl:param>
  
  <xsl:call-template name="buildLoop">
    <xsl:with-param name="indent" select="$indent"/>
    <xsl:with-param name="pageName" select="string('view')" />
    <xsl:with-param name="pageName" select="false()" />
  </xsl:call-template>
</xsl:template>

<!-- ********** Processes a choice ********** -->
<xsl:template match="view//choice">
  <xsl:param name="indent">0</xsl:param>
   
  <xsl:call-template name="buildChoice">
    <xsl:with-param name="indent" select="$indent"/>
    <xsl:with-param name="isModifiable" select="false()"/>
  </xsl:call-template>
</xsl:template>
   
<!-- ********* Generates output for simple elements ********** -->
<xsl:template match="view//field">
  <xsl:param name="indent">0</xsl:param>
  
  <xsl:call-template name="buildField">
    <xsl:with-param name="isModifiable" select="false()" />
    <xsl:with-param name="indent" select="$indent"/>
  </xsl:call-template>
</xsl:template>

</xsl:stylesheet>

