<!-- *** Copyright (c) 2001 - 2003 Software AG. All Rights Reserved. *** -->
<!-- *** Version: $Revision: 1.14 $                           *** -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xapp="http://www.softwareag.com/xtools/xapplication"
                xmlns="http://www.w3.org/1999/xhtml" version="1.0">

<xsl:import href="./basics.xsl" />

<!-- *** Definition of the stye sheet parameters -->
<!-- appConfig contains the content of the xapplication.xml  -->
<xsl:param name="appConfig" />
<!-- Contains the content of the config.xml -->
<xsl:param name="genConfig" />

          
<xsl:output method = "xml" omit-xml-declaration = "yes" indent = "yes" encoding = "UTF-8"/>

<xsl:strip-space elements="*" />

<xsl:template match="/">
    <xsl:apply-templates/>
</xsl:template>

<xsl:template match="search">
  <xsl:call-template name="page">
    <xsl:with-param name="title">Query <xsl:value-of select="//@name"/></xsl:with-param>
    <xsl:with-param name="nextPage">browse</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template name="pageContent">
  <!-- *** Fill the variable querySearch with all query filter variables *** -->
  <xapp:setvar name="querySearch" scope="session" default="">
    <xsl:attribute name="value">for $x in input()/<xsl:call-template name="getDoctype" /><xsl:call-template name="buildQuery"/> return $x</xsl:attribute>
  </xapp:setvar>
  <table border="0" cellpadding="3" cellspacing="0" width="100%">
    <tr>
      <td align="left" valign="top">
        <b><font size="+3"><xsl:value-of select="//@name"/> Search</font></b>
      </td>
    </tr>
    <tr>
      <td>
        <table border="0" width="100%">
          <tr>
            <td width="5%">
              <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
            </td>
            <td align="left" width="31%">
              <xsl:call-template name="buildSearchActionButton" />
            </td>
            <td align="right">
              <b>Pagesize</b> <input type="text" name=":pagesize" size="4" value="10"/>
            </td>
          </tr>
          <tr>
            <td colspan="3">
              <table border="0" cellpadding="0" cellspacing="0" width="100%">
                <xsl:apply-templates select="heading"/>
                <xsl:apply-templates select="field"/>
              </table>
            </td>
          </tr>
          <tr>
            <td width="5%">
              <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
            </td>
            <td align="left" width="31%">
              <xsl:call-template name="buildSearchActionButton" />
            </td>
            <td>
              <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
            </td>
          </tr>
        </table>
      </td>
    </tr>
  </table>
</xsl:template>

<!-- *** Process a outer heading *** -->
<xsl:template match="search/heading">
  <xsl:call-template name="buildTopLevelHeading" />
</xsl:template>

<!-- ********** Generates a heading inside a heading directly after top level********** -->
<xsl:template match="search/heading/heading">
  <xsl:param name="indent">0</xsl:param>
  
  <xsl:call-template name="buildHeadingOfTopLevelHeading">
    <xsl:with-param name="indent" select="$indent" />
  </xsl:call-template>
</xsl:template>

<!-- ********** Generates a heading in a deeper level********** -->
<xsl:template match="search/heading/*//heading">
  <xsl:param name="indent">0</xsl:param>
  
  <xsl:call-template name="buildDeeperLevelHeadings">
    <xsl:with-param name="indent" select="$indent" />
  </xsl:call-template>
</xsl:template>

<!-- ********* Generates the loop heading for occurring elements ********** -->
<xsl:template match="search//loop">
  <xsl:param name="indent">0</xsl:param>
  
  <xsl:if test="count(.//field)">
    <xsl:apply-templates select="field"/>
    <xsl:apply-templates select="loop">
      <xsl:with-param name="indent" select="$indent" />
    </xsl:apply-templates>
    <xsl:apply-templates select="choice">
      <xsl:with-param name="indent" select="$indent + 5" />
    </xsl:apply-templates>
    <xsl:apply-templates select="heading">
      <xsl:with-param name="indent" select="$indent + 5" />
    </xsl:apply-templates>
  </xsl:if>
</xsl:template>

<!-- ********* Generates the choice heading  ********** -->
<xsl:template match="search//choice">
  <xsl:param name="indent">0</xsl:param>
   
  <xsl:if test="count(.//field)">
    <tr bgcolor="white">
      <td>
        <xsl:call-template name="spacer">
          <xsl:with-param name="indent" select="$indent" />
        </xsl:call-template>
        choice: <xsl:value-of select="@type"/>
      </td>
    </tr>
    <xsl:apply-templates select="field" />
    <xsl:apply-templates select="loop">
      <xsl:with-param name="indent" select="$indent" />
    </xsl:apply-templates>
    <xsl:apply-templates select="choice">
      <xsl:with-param name="indent" select="$indent + 5" />
    </xsl:apply-templates>
    <xsl:apply-templates select="heading">
      <xsl:with-param name="indent" select="$indent + 5" />
    </xsl:apply-templates>
  </xsl:if>
</xsl:template>

<!-- *** Process the input tags *** -->
<xsl:template match="search//field">
  <xsl:variable name="fieldName"><xsl:call-template name="buildFieldName" /></xsl:variable>
  
  <tr bgcolor="#EEEEEE">
    <td>
      <table border="0" cellpadding="0" cellspacing="0" width="100%">
        <xsl:for-each select=".">
          <tr bgcolor="#EEEEEE" cellpadding="0">
            <td align="right" width="30%" height="12">
              <font color="#000000"><b>
                <xsl:value-of select="@name"/>
              </b></font>
            </td>
            <td align="left" valign="top" height="12">
            <xsl:choose>
              <xsl:when test="@method='RANGE'">
                <table width="100%" border="0">
                  <tr>
                    <td>from:</td>
                    <td>
                      <input type="text" size="20" name="VAL_MIN{$fieldName}" />
                      <xapp:setvar name="FILTER_MIN{$fieldName}" scope="session" default="">
                        <xsl:attribute name="value">[xs:integer(<xsl:value-of select="@select" />) &gt;= ${VAL_MIN<xsl:value-of select="$fieldName" />$}]</xsl:attribute>
                      </xapp:setvar>
                    </td>
                  </tr>
                  <tr>
                    <td>to:</td>
                    <td>
                      <input type="text" size="20" name="VAL_MAX{$fieldName}"/>
                      <xapp:setvar name="FILTER_MAX{$fieldName}" scope="session" default="">
                        <xsl:attribute name="value">[xs:integer(<xsl:value-of select="@select" />) &lt;= ${VAL_MAX<xsl:value-of select="$fieldName" />$}]</xsl:attribute>
                      </xapp:setvar>
                    </td>
                  </tr>
                </table>
              </xsl:when>
              <xsl:otherwise>
                <input type="text" size="20" name="VAL{$fieldName}" />
                <xapp:setvar scope="session" default="" name="FILTER{$fieldName}">
                  <xsl:attribute name="value">[<xsl:value-of select="@select" />='${apos:VAL<xsl:value-of select="$fieldName"/>$}']</xsl:attribute>
                </xapp:setvar>
              </xsl:otherwise>
            </xsl:choose>
            </td>
          </tr>
        </xsl:for-each>
      </table>
    </td>
  </tr>
</xsl:template>


<!-- *** builds a query by concatenating all filter variables for input subnodes in the search subtree *** -->
<xsl:template name="buildQuery">
    <xsl:for-each select="//search//field">
      <xsl:variable name="fieldName"><xsl:call-template name="buildFieldName" /></xsl:variable>
      <xsl:choose>
        <xsl:when test="@method='RANGE'">${FILTER_MIN<xsl:value-of select="$fieldName"/>$}${FILTER_MAX<xsl:value-of select="$fieldName"/>$}</xsl:when>
        <xsl:otherwise>${FILTER<xsl:value-of select="$fieldName"/>$}</xsl:otherwise>
      </xsl:choose>
    </xsl:for-each>
</xsl:template>

<xsl:template name="buildFieldName">
  <xsl:value-of select="translate(translate(./@select, '/', '_'), ':', '!')" />
</xsl:template>

<!--
  ** Prints a xapp:action with type="search"
  -->
<xsl:template name="buildSearchActionButton">
  <xapp:action type="xquery" form="form1">
    <xsl:call-template name="buildDocListAttribute" />
    <xsl:attribute name="arg">${querySearch$}</xsl:attribute>
    <xsl:attribute name="schema"><xsl:call-template name="getDoctype"/></xsl:attribute>
    <xsl:attribute name="collection">${<xsl:value-of select="$appConfig//collection/@variable" />$}</xsl:attribute>
                  
    <a href="javascript:document.forms['form1'].submit();">
      <img src="SearchButton.gif" width="84" height="27" border="0"/>
    </a>
  </xapp:action>
</xsl:template>

</xsl:stylesheet>

