<!-- *** Copyright (c) 2001 - 2003 Software AG. All Rights Reserved. *** -->
<!-- *** Version: $Revision: 1.11 $                           *** -->


<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xapp="http://www.softwareag.com/xtools/xapplication"
                xmlns="http://www.w3.org/1999/xhtml" version="1.0">
                
<xsl:import href="./basics.xsl" />

<!-- *** Definition of the stye sheet parameters -->
<!-- appConfig contains the content of the xapplication.xml  -->
<xsl:param name="appConfig" />
<!-- Contains the content of the config.xml -->
<xsl:param name="genConfig" />

<xsl:output method = "xml" omit-xml-declaration = "yes" indent = "yes" encoding = "UTF-8"/>

<xsl:strip-space elements="*" />

<xsl:template match="/">
    <xsl:apply-templates/>
</xsl:template>

<xsl:template match="browse">
  <xsl:call-template name="page">
    <xsl:with-param name="title">List <xsl:value-of select="//@name"/></xsl:with-param>
    <xsl:with-param name="nextPage">browse</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template name="pageContent">
  <table border="0" cellpadding="3" cellspacing="0" width="100%">
    <tr>
      <td align="left" valign="top" width="21%">
         <xsl:choose>
		<xsl:when test="//@displayname">
			<b><font size="+3">List <xsl:value-of select="//@displayname"/></font></b> 
		</xsl:when>
		<xsl:otherwise>
			<b><font size="+3">List <xsl:value-of select="//@name"/></font></b> 
		</xsl:otherwise>
	   </xsl:choose>	
	</td>
      <td align="right" valign="bottom">
        <xsl:text>found</xsl:text>
        <b>
          <font size="+1">
            <xapp:count>
              <xsl:attribute name="target"><xsl:call-template name="buildDocListName" /></xsl:attribute>
            </xapp:count>
          </font>
        </b>
        <xsl:text>document(s)</xsl:text>
      </td>
    </tr>
    <tr>
      <td colspan="2">
        <table border="0" width="100%">
          <tr>
            <td height="250" valign="top">
              <table border="0" cellpadding="0" cellspacing="0" width="100%">
                <tr bgcolor="#859687">
                  <td align="left" height="21">
                    <b>Pos.</b>
                  </td>
                  <xsl:for-each select=".//field">
                    <td align="left" height="21">
                      <b><xsl:value-of select="@name"/></b>
                    </td>
                  </xsl:for-each>
                </tr>
                <xapp:browse>
                  <xsl:call-template name="buildDocListAttribute" />
                  <xsl:call-template name="buildTargetDocAttribute" />
                  
                  <tr bgcolor="#EEEEEE" cellpadding="0">
                    <td align="left" valign="top" height="19">
                      <div align="left"><font color="#000000"><b>
                      <xapp:action type="read">
                        <a>
                          <xsl:attribute name="href">
                            <xsl:apply-templates select="$genConfig//application">
                              <xsl:with-param name="page">view</xsl:with-param>
                            </xsl:apply-templates>
                          </xsl:attribute>
                          <xapp:display select="$POS" />
                        </a>
                      </xapp:action>
                      </b></font></div>
                    </td>
                    <xsl:for-each select=".//field">
                      <td align="left" valign="top" height="19">
                        <xsl:choose>
                          <xsl:when test="string(@optionAttr) = string('true')">
                            <xapp:if select="{@select}">
                              <xapp:display select="{@select}" />
                            </xapp:if>
                          </xsl:when>
                          <xsl:otherwise>
                            <xapp:display select="{@select}" />
                          </xsl:otherwise>
                        </xsl:choose>
                      </td>
                    </xsl:for-each>
                  </tr>
                </xapp:browse>
              </table>
            </td>
          </tr>
        </table>
      </td>
    </tr>
    <tr>
      <td colspan="2">
        <table border="0" cellpadding="0" cellspacing="0" width="100%">
          <tr bgcolor="#859687">
            <td width="10%">
              <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
            </td>
            <td align="left" width="6%">
              <xapp:browsenavigation direction="previous">
                <xsl:call-template name="buildDocListAttribute" />
                <img src="/images/BrowsePrev.gif" width="28" height="22" />
              </xapp:browsenavigation>
            </td>
            <td align="left" width="6%">
              <xapp:browsenavigation direction="next">
                <xsl:call-template name="buildDocListAttribute" />
                <img src="/images/BrowseNext.gif" width="28" height="22" />
              </xapp:browsenavigation>
            </td>
            <td align="left" width="31%" >
              <div align="right">
              <font size="2">Start from:
              <input type="text" size="6" value="1">
                <xsl:attribute name="name">:goto(<xsl:call-template name="buildDocListName" />)</xsl:attribute>
              </input>
              <input type="submit" value="Go" />
              </font>
              </div>
            </td>
            <td width="10%">
              <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
            </td>
          </tr>
        </table>
      </td>
    </tr>
  </table>
</xsl:template>

</xsl:stylesheet>

