function lazy_frame_resize() {
	var timer = setInterval(function() {
        var frameId = "#{caf:cid('googleFrame')}";
        var frame = CAF.model(frameId).element;

		if (frame != null) {
		    frame_resize();
			clearInterval(timer);
		}
	}, 250);
}
function frame_resize() {
    var frameId = "#{caf:cid('googleFrame')}";
    var frame = $(frameId);
    var parent = frame.getOffsetParent();
    
    var pwo = parseStyle(parent, "paddingLeft", "paddingRight");
    var pho = parseStyle(parent, "paddingBottom", "paddingTop");    
    
    var fh = parsePx(parent.style.height) - pho;
    var fw = parsePx(parent.style.width) - pwo;
    
    frame.style.height = fh + "px"; 
    frame.style.width =  fw + "px";
}

function parseStyle(elem, style1, style2) {
	var val1 = elem.getStyle(style1);
	var val2 = elem.getStyle(style2);
	return parsePx(val1) + parsePx(val2);
}

function parsePx(val) {
	return parseInt(val.replace(/[^0-9]/g, ''));
}

Event.observe(window, "load", lazy_frame_resize);
Event.observe(window, "resize", frame_resize);
OpenAjax.hub.subscribe("Noodle.portlet.*", frame_resize);
