Attribute VB_Name = "Module1"

'***    ENTIRE BROKER API    ***

'ENTIRE BROKER function equates
Global Const F_SEND = 1
Global Const F_RECEIVE = 2
Global Const F_UNDO = 4
Global Const F_EOC = 5
Global Const F_REGZSTER = 6
Global Const F_DEREGISTER = 7
Global Const F_VERSION = 8
Global Const F_LOGON = 9
Global Const F_LOGOFF = 10
Global Const F_SET = 11
Global Const F_GET = 12
Global Const F_SYNCPOZNT = 13

' ENTIRE BROKER option equates
Global Const O_HOLD = 2
Global Const O_IMMED = 3
Global Const O_QUIESCE = 4
Global Const O_EOC = 5
Global Const O_CANCEL = 6
Global Const O_LAST = 7
Global Const O_NEXT = 8
Global Const O_PREVIEW = 9
Global Const O_COMMIT = 10
Global Const O_BACKOUT = 11
Global Const O_SYNC = 12
Global Const O_ATTACH = 13

' ENTIRE BROKER CID equates
Global Const C_NEW = "NEW"
Global Const C_OLD = "OLD"
Global Const C_ANY = "ANY"
Global Const C_NONE = "NONE"

' ENTIRE BROKER API control block structure
Type ETBCBt
     APItype         As String * 1
     version         As String * 1
     function        As String * 1
     option          As String * 1
     reserved        As String * 16
     send_len        As Long
     receive_len     As Long
     return_len      As Long
     errtext_len     As Long
     broker_id       As String * 32
     server_class    As String * 32
     server_name     As String * 32
     service         As String * 32
     user_id         As String * 32
     p_user_id       As String * 32
     token           As String * 32
     security_token  As String * 32
     conv_id         As String * 16
     wait            As String * 8
     error_class     As String * 4
     error_number    As String * 4
     environment     As String * 32
     user_data       As String * 16
     conv_stat       As String * 1
     msg_id          As String * 48
     msg_type        As String * 16
     store           As String * 1
     ptime           As String * 8
     status          As String * 1
     adcount         As String * 4
     newpassword     As String * 32
     adapter_error   As String * 8
     client_uid      As String * 32
End Type

' Information request structure
Type IRSt
     block_Length  As Long
     version       As Integer
     info_level    As Integer
     object_type   As Integer
     user_id       As String * 32
     p_user_id     As String * 32
     token         As String * 32
     server_class  As String * 32
     server_name   As String * 32
     service       As String * 32
     conv_id       As String * 16
     reserved      As Integer
End Type

' Broker information structure
Type BSt
 'Header Structure
      error_code            As Long
      total_num_objects     As Long
      current_num_objects   As Long
      max_sc_len            As Long
      max_sn_len            As Long
      max_sv_len            As Long
      max_uid_len           As Long
      max_tk_len            As Long

' Broker structure
      platform              As String * 8
      run_time              As Long
      num_worker_act        As Long
      num_long              As Long
      long_act              As Long
      long_high             As Long
      num_short             As Long
      short_act             As Long
      short_high            As Long
      long_size             As Long
      short_size            As Long
      num_service           As Long
      service_act           As Long
      num_server            As Long
      server_act            As Long
      server_high           As Long
      num_client            As Long
      client_act            As Long
      client_high           As Long
      num_conv              As Long
      conv_high             As Long
      trace_level           As Integer
      reserve               As Integer
End Type

' Worker Information Structure
Type WSt
' Header Structure
      error_code            As Long
      total_num_objects     As Long
      current_num_objects   As Long
      max_sc_len            As Long
      max_sn_len            As Long
      max_sv_len            As Long
      max_uid_len           As Long
      max_tk_len            As Long

' Worker structure
      worker_id             As Integer
      worker_stat           As Integer
      call_sum              As Long
      idle_sum              As Long
End Type

Type CFG ' Configuration type.
    user_id         As String * 32
    broker_id       As String * 32
    server_class    As String * 32
    server_name     As String * 32
    service         As String * 32
End Type

' Service Information Structure
Type SSt
' Header Structure
     error_code          As Long
     total_num_objects   As Long
     current_num_objects As Long
     max_sc_len          As Long
     max_sn_len          As Long
     max_sv_len          As Long
     max_uid_len         As Long
     max_tk_len          As Long

' Service structure
     server_class        As String * 32
     server_name         As String * 32
     service             As String * 32
     trans               As String * 8
     conv_nonact         As Long
     server_act          As Long
     conv_act            As Long
     conv_high           As Long
     long_act            As Long
     long_high           As Long
     short_act           As Long
     short_high          As Long
     wait_server         As Long
     num_wait_server     As Long
     num_serv_occ        As Long
     num_pend            As Long
     pend_high           As Long
     req_sum             As Long
End Type

' Client/Server Information Structure
Type CSt
' Header Structure
     error_code          As Long
     total_num_objects   As Long
     current_num_objects As Long
     max_sc_len          As Long
     max_sn_len          As Long
     max_sv_len          As Long
     max_uid_len         As Long
     max_tk_len          As Long

' Client/Server Structure
     user_id             As String * 32
     p_user_id           As String * 28
     p_user_id_char      As String * 28
     token               As String * 32
     char_set            As Integer
     endian              As Integer
     status              As Integer
     reserved            As Integer
     wait_conv_type      As String * 16
     wait_server_class   As String * 32
     wait_server_name    As String * 32
     wait_service        As String * 32
     conv_act            As Long
     service_act         As Long
     last_active         As Long
     nonact              As Long
     wait_new            As Integer
     num_wait_new        As Long
     wait_old            As Long
     num_wait_old        As Long
     sum_conv            As Long
End Type

' Conversation Information Structure
Type COt
' Header Structure
     error_code          As Long
     total_num_objects   As Long
     current_num_objects As Long
     max_sc_len          As Long
     max_sn_len          As Long
     max_sv_len          As Long
     max_uid_len         As Long
     max_tk_len          As Long

' Conversation Structure
     conv_id                 As String * 16
     server_user_id          As String * 32
     server_p_user_id        As String * 28
     server_p_user_id_char   As String * 28
     server_token            As String * 32
     client_user_id          As String * 32
     client_p_user_id        As String * 28
     client_p_user_id_char   As String * 28
     client_token            As String * 32
     server_class            As String * 32
     server_name             As String * 32
     service                 As String * 32
     conv_time_out           As Long
     last_active_conv        As Long
     conv_type               As Integer
     reserved                As Integer
End Type


' ENTIRE BROKER API DECLARATION
Global Const G_MSG_LEN_MAX = 8192

Global IRS   As IRSt
Global ETBCB As ETBCBt
Global send_data As IRSt

Global saved_convid As String * 16
Global error_text   As String * 40

' ENTIRE BROKER function declaration
'Broker info
Global recieve_BS As BSt
Declare Sub BrokerBS Lib "brokervb.dll" Alias "Broker" (ETBCB As ETBCBt, send_data As IRSt, rcv_data As BSt, ByVal error_text As String)

'Worker info
Global recieve_WS As WSt
Global WS() As WSt ' Creating an array for Worker info
Declare Sub BrokerWS Lib "brokervb.dll" Alias "Broker" (ETBCB As ETBCBt, send_data As IRSt, rcv_data As WSt, ByVal error_text As String)

'Service info
Global recieve_SS As SSt
Global SS() As SSt ' Creating an array for Service info
Declare Sub BrokerSS Lib "brokervb.dll" Alias "Broker" (ETBCB As ETBCBt, send_data As IRSt, rcv_data As SSt, ByVal error_text As String)

'Client/Server info
Global recieve_CS As CSt
Global CS() As CSt ' Creating an array for client\server info
Declare Sub BrokerCS Lib "brokervb.dll" Alias "Broker" (ETBCB As ETBCBt, send_data As IRSt, rcv_data As CSt, ByVal error_text As String)

'Conversation info
Global recieve_CO As COt
Global CO() As COt ' Creating an array for conversation info
Declare Sub BrokerCO Lib "brokervb.dll" Alias "Broker" (ETBCB As ETBCBt, send_data As IRSt, rcv_data As COt, ByVal error_text As String)

