package wm;

// -----( IS Java Code Template v1.2
// -----( CREATED: 2014-04-16 13:53:18 CEST
// -----( ON-HOST: WIN-ETM6GB8AV69

import com.wm.data.*;
import com.wm.util.Values;
import com.wm.app.b2b.server.Service;
import com.wm.app.b2b.server.ServiceException;
// --- <<IS-START-IMPORTS>> ---
import com.wm.lang.ns.NSName;
import com.wm.util.JournalLogger;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.Stack;
import sun.util.logging.resources.logging;
// --- <<IS-END-IMPORTS>> ---

public final class services

{
	// ---( internal utility methods )---

	final static services _instance = new services();

	static services _newInstance() { return new services(); }

	static services _cast(Object o) { return (services)o; }

	// ---( server methods )---




	public static final void processStep (IData pipeline)
        throws ServiceException
	{
		// --- <<IS-START(processStep)>> ---
		// @sigtype java 3.5
		// [i] recref:1:required steps wm.docs:step
		// [o] recref:1:required steps wm.docs:step
		// pipeline
		IDataCursor pipelineCursor = pipeline.getCursor();
		
		String serviceName = ""; 
		String timestamp = "";
		IData[]	stepsOUT = null;
		int index = 0;
		
		// steps
		IData[]	stepsIN = IDataUtil.getIDataArray( pipelineCursor, "steps" );
				
		if ( stepsIN != null)
		{
			index = stepsIN.length;
			stepsOUT = new IData[index + 1];
			
			for ( int i = 0; i < index; i++ )
			{
				stepsOUT[i] = stepsIN[i];
			}
		} else {
			stepsOUT = new IData[index + 1];
		}
			
		stepsOUT[index] = IDataFactory.create();
		IDataCursor stepsOUTCursor = stepsOUT[index].getCursor();
		
		//get calling service name
		Stack callStack = com.wm.app.b2b.server.InvokeState.getCurrentState().getCallStack();
		com.wm.lang.ns.NSService caller = (com.wm.lang.ns.NSService)callStack.get(0);
		com.wm.lang.ns.NSPackage pkg = caller.getPackage();	
		com.wm.lang.ns.NSService nss = Service.getCallingService();
		serviceName = nss.toString();
				
		//get timestamp
		long timeInMillis = System.currentTimeMillis();
		Calendar cal = Calendar.getInstance();
		cal.setTimeInMillis(timeInMillis);
		java.util.Date date = cal.getTime();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
		timestamp = sdf.format(date);
		
		//IData operations
		IDataUtil.put( stepsOUTCursor, "timestamp", timestamp );
		IDataUtil.put( stepsOUTCursor, "service", serviceName);
		stepsOUTCursor.destroy();
		
		//Logging
		JournalLogger.log(3, 90, 0, "Timestamp: " + timestamp + " Service: " + serviceName);
		
		
		//Write to Pipeline
		IDataUtil.put( pipelineCursor, "steps", stepsOUT );
		pipelineCursor.destroy();	
		// --- <<IS-END>> ---

                
	}



	public static final void randomNumberAndSleep (IData pipeline)
        throws ServiceException
	{
		// --- <<IS-START(randomNumberAndSleep)>> ---
		// @sigtype java 3.5
		// [i] field:0:required rangeMin
		// [i] field:0:required rangeMax
		// [i] field:0:optional sleep {"false","true"}
		// [o] field:0:required value
		// pipeline
		IDataCursor pipelineCursor = pipeline.getCursor();
			int rangeMin = IDataUtil.getInt( pipelineCursor, "rangeMin" ,0);
			int	rangeMax = IDataUtil.getInt( pipelineCursor, "rangeMax" ,0);
			String sleep = IDataUtil.getString( pipelineCursor, "sleep");
		
			pipelineCursor.destroy();
		
		long value = 0;
		
		try {
			Random random = new Random();
			value = (long) (random.nextDouble() * ((rangeMax + 1) - rangeMin) + rangeMin);
			if (sleep != null) if(sleep.equals("true")) Thread.sleep(value);
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		// pipeline
		IDataCursor pipelineCursor_1 = pipeline.getCursor();
		IDataUtil.put( pipelineCursor_1, "value", Long.toString(value) );
		pipelineCursor_1.destroy();
		// --- <<IS-END>> ---

                
	}



	public static final void sleep (IData pipeline)
        throws ServiceException
	{
		// --- <<IS-START(sleep)>> ---
		// @sigtype java 3.5
		// [i] field:0:required millis
		IDataCursor cursor = pipeline.getCursor();
		
		long millis = 0;
		if (cursor.first("millis"))
		{
		  millis = Long.parseLong((String) cursor.getValue());
		}
		else
		{
		  throw new ServiceException("Input parameter \'millis\' was not found.");
		}
		cursor.destroy();
		
		// *** Check if service is on the allowed list ***
		IData in = IDataFactory.create();
		IDataCursor idcIn = in.getCursor();
		idcIn.insertAfter("paramName", "maxSleep");
		NSName nsCheckServiceName = NSName.create("PSUtilities.config:getParameterValue");
		idcIn.destroy();
		IData out;
		try
		{
		  out = Service.doInvoke(nsCheckServiceName, in);
		}
		catch (Exception e)
		{
		  throw new ServiceException(e.getMessage());
		}
		IDataCursor idcOut = out.getCursor();
		String strParamValue = null;
		if (idcOut.first("paramValue"))
		{
		  strParamValue = (String) idcOut.getValue();
		}
		idcOut.destroy();
		
		if (millis > Long.parseLong(strParamValue))
		{
		  throw new ServiceException("Specified sleep interval has exceeded the maximum allowed sleep interval " + strParamValue + " specified by the PSUtiltiies configuration file");
		}
		// *** End check ***
		
		if (millis < 0)
		{
		  throw new ServiceException("Parameter \'millis\' must have a positive value.");
		}
		try
		{
		  Thread.sleep(millis);
		}
		catch (InterruptedException e)
		{
		}
			
		// --- <<IS-END>> ---

                
	}
}

