﻿using System;
using System.Collections.Generic;
using System.Data.Entity;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace DB2EF6CodeFirstInheritanceSample
{
    class SchoolContext: DbContext
    {
        public DbSet<Person> People { get; set; }

        // Base constructor with named connection string
        public SchoolContext() : base("name=SchoolContext")
        {
            // Initializer could be set to DropCreateDatabaseIfModelChanges, other values are
            // DropCreateDatabaseAlways<>, CreateDatabaseIfNotExists<> (default value)
            Database.SetInitializer(new DropCreateDatabaseIfModelChanges<SchoolContext>());
        }
        #region Needed only for Type per concrete class inheritance strategy
#if TPC
        protected override void OnModelCreating(DbModelBuilder modelBuilder)
        {
            modelBuilder.Entity<Student>().Map(m =>
            {
                m.MapInheritedProperties();
                m.ToTable("Student");
            });

            modelBuilder.Entity<Instructor>().Map(m =>
            {
                m.MapInheritedProperties();
                m.ToTable("Instructor");
            });
        }
#endif
        #endregion
    }
}
