﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace DB2EF6CodeFirstInheritanceSample
{
    class Program
    {
        /* The default inheritance strategy in EF is TPH (Table Per Hierarchy),
         * to change it to TPT (Table Per Type) or TPC (Table Per Concrete class)
         * we need to define conditional compilation symbols TPT and TPC respectively
         * and build the code. All migrations were created the same conditional compilation.
        */
        static void Main(string[] args)
        {
            using (SchoolContext db = new SchoolContext())
            {
                // Write EF Log to console
                db.Database.Log = Console.Write;

                // Polymorphic query
                var qry = from ppl in db.People
                          select ppl;
                foreach (var p in qry)
                {
                    Console.WriteLine(p.FullName);
                }

                // NON Polymorphic query
                var qry1 = from ppl in db.People.OfType<Student>()
                          select ppl;
                foreach (var p in qry1)
                {
                    Console.WriteLine(p.FullName);
                }
                Console.ReadLine();
            }
        }
    }
}
