namespace DB2EF6CodeFirstInheritanceSample.Migrations
{
    using System;
    using System.Data.Entity.Migrations;
    
    public partial class TPC : DbMigration
    {
        public override void Up()
        {
            DropForeignKey("dbo.Instructor", "ID", "dbo.People");
            DropForeignKey("dbo.Student", "ID", "dbo.People");
            DropIndex("dbo.Instructor", new[] { "ID" });
            DropIndex("dbo.Student", new[] { "ID" });
            AddColumn("dbo.Instructor", "LastName", c => c.String(nullable: false, maxLength: 50));
            AddColumn("dbo.Instructor", "FirstName", c => c.String(nullable: false, maxLength: 50));
            AddColumn("dbo.Student", "LastName", c => c.String(nullable: false, maxLength: 50));
            AddColumn("dbo.Student", "FirstName", c => c.String(nullable: false, maxLength: 50));
            DropTable("dbo.People");
        }
        
        public override void Down()
        {
            CreateTable(
                "dbo.People",
                c => new
                    {
                        ID = c.Int(nullable: false, identity: true),
                        LastName = c.String(nullable: false, maxLength: 50),
                        FirstName = c.String(nullable: false, maxLength: 50),
                    })
                .PrimaryKey(t => t.ID);
            
            DropColumn("dbo.Student", "FirstName");
            DropColumn("dbo.Student", "LastName");
            DropColumn("dbo.Instructor", "FirstName");
            DropColumn("dbo.Instructor", "LastName");
            CreateIndex("dbo.Student", "ID");
            CreateIndex("dbo.Instructor", "ID");
            AddForeignKey("dbo.Student", "ID", "dbo.People", "ID");
            AddForeignKey("dbo.Instructor", "ID", "dbo.People", "ID");
        }
    }
}
