namespace DB2EF6CodeFirstInheritanceSample.Migrations
{
    using System;
    using System.Data.Entity.Migrations;
    
    public partial class TPT : DbMigration
    {
        public override void Up()
        {
            CreateTable(
                "dbo.Instructor",
                c => new
                    {
                        ID = c.Int(nullable: false),
                        HireDate = c.DateTime(nullable: false),
                    })
                .PrimaryKey(t => t.ID)
                .ForeignKey("dbo.People", t => t.ID)
                .Index(t => t.ID);
            
            CreateTable(
                "dbo.Student",
                c => new
                    {
                        ID = c.Int(nullable: false),
                        EnrollmentDate = c.DateTime(nullable: false),
                    })
                .PrimaryKey(t => t.ID)
                .ForeignKey("dbo.People", t => t.ID)
                .Index(t => t.ID);
            
            DropColumn("dbo.People", "HireDate");
            DropColumn("dbo.People", "EnrollmentDate");
            DropColumn("dbo.People", "Discriminator");
        }
        
        public override void Down()
        {
            AddColumn("dbo.People", "Discriminator", c => c.String(nullable: false, maxLength: 128));
            AddColumn("dbo.People", "EnrollmentDate", c => c.DateTime());
            AddColumn("dbo.People", "HireDate", c => c.DateTime());
            DropForeignKey("dbo.Student", "ID", "dbo.People");
            DropForeignKey("dbo.Instructor", "ID", "dbo.People");
            DropIndex("dbo.Student", new[] { "ID" });
            DropIndex("dbo.Instructor", new[] { "ID" });
            DropTable("dbo.Student");
            DropTable("dbo.Instructor");
        }
    }
}
